# Shopware Building & Metal Materials Store

A custom Shopware 6 project with a specialized theme for selling building and metal materials, created without Docker.

## Project Overview

This project includes:
- **Shopware 6.7.2.2** e-commerce platform
- **MyCustomTheme** - Custom theme designed for building and metal materials
- **Professional design** with industrial color scheme and building materials focus
- **Responsive layout** optimized for both desktop and mobile devices

## Features

### Custom Theme (MyCustomTheme)
- Industrial color palette (steel blue, orange accents)
- Building materials focused design
- Professional navigation with categorized menus
- Hero section with construction imagery
- Product cards optimized for building materials
- Service sections highlighting delivery and technical support
- Newsletter integration
- Mobile-responsive design

### Design Elements
- **Color Scheme**: Steel blue (#2c3e50), Orange (#e67e22), Metal silver (#bdc3c7)
- **Typography**: Roboto font family for professional appearance
- **Icons**: Font Awesome icons for construction and building themes
- **Layout**: Bootstrap-based responsive grid system

## Installation & Setup

### Prerequisites
- PHP 8.2 or higher
- MySQL 8.0 or higher
- Composer
- Node.js (for asset compilation)

### Installation Steps

1. **Install PHP and extensions**:
   ```bash
   sudo apt install php8.2 php8.2-cli php8.2-mysql php8.2-xml php8.2-zip php8.2-curl php8.2-mbstring php8.2-intl php8.2-gd php8.2-fpm
   ```

2. **Install Composer**:
   ```bash
   php -r "copy('https://getcomposer.org/installer', 'composer-setup.php');"
   php composer-setup.php
   sudo mv composer.phar /usr/local/bin/composer
   ```

3. **Install MySQL and create database**:
   ```bash
   sudo apt install mysql-server
   sudo mysql -e "CREATE DATABASE shopware; CREATE USER 'shopware'@'localhost' IDENTIFIED BY 'shopware'; GRANT ALL PRIVILEGES ON shopware.* TO 'shopware'@'localhost'; FLUSH PRIVILEGES;"
   ```

4. **Create Shopware project**:
   ```bash
   composer create-project shopware/production shopware-project
   cd shopware-project
   ```

5. **Configure environment**:
   Update `.env` file with database credentials and app URL.

6. **Install Shopware**:
   ```bash
   bin/console system:install --create-database --basic-setup --shop-name="Building and Metal Store" --shop-email=admin@example.com --shop-locale=en-GB --shop-currency=EUR
   ```

7. **Install custom theme**:
   ```bash
   bin/console plugin:refresh
   bin/console plugin:install --activate MyCustomTheme
   bin/console theme:change MyCustomTheme
   bin/console theme:compile
   ```

## Theme Structure

```
custom/plugins/MyCustomTheme/
├── composer.json
├── src/
│   ├── MyCustomTheme.php
│   └── Resources/
│       ├── theme.json
│       ├── app/storefront/src/
│       │   ├── scss/overrides.scss
│       │   ├── js/main.js
│       │   └── assets/images/
│       └── views/storefront/
│           ├── layout/
│           │   ├── header/header.html.twig
│           │   ├── navigation/navigation.html.twig
│           │   └── footer/footer.html.twig
│           └── page/content/index.html.twig
```

## Theme Configuration

The theme includes configurable color options:
- Primary brand color (#2c3e50)
- Secondary brand color (#e67e22)
- Success color (#27ae60)
- Info color (#3498db)
- Warning color (#f39c12)
- Danger color (#e74c3c)

## Running the Project

1. **Start PHP development server**:
   ```bash
   php -S 0.0.0.0:8000 -t public/
   ```

2. **Access the storefront**:
   Open your browser and navigate to `http://localhost:8000`

3. **Access admin panel**:
   Navigate to `http://localhost:8000/admin`
   - Username: admin
   - Password: shopware

## Sales Channels

The project includes multiple sales channels:
- **Building and Metal Store** - Main storefront
- **BuildMetal Store** - Alternative storefront configuration
- **Headless** - API-only channel

## Customization

### Adding New Styles
Edit `custom/plugins/MyCustomTheme/src/Resources/app/storefront/src/scss/overrides.scss`

### Modifying Templates
Templates are located in `custom/plugins/MyCustomTheme/src/Resources/views/storefront/`

### Adding JavaScript
Edit `custom/plugins/MyCustomTheme/src/Resources/app/storefront/src/js/main.js`

### After Changes
Always run:
```bash
bin/console theme:compile
bin/console cache:clear
```

## Troubleshooting

### Sales Channel Not Found
If you encounter "Sales Channel Not Found" error:
1. Check sales channel configuration: `bin/console sales-channel:list`
2. Update domain: `bin/console sales-channel:update:domain NEW_DOMAIN --previous-domain=OLD_DOMAIN`
3. Clear cache: `bin/console cache:clear`

### Theme Not Applied
1. Verify theme is installed: `bin/console plugin:list`
2. Assign theme to sales channel: `bin/console theme:change MyCustomTheme --sales-channel=CHANNEL_ID`
3. Compile theme: `bin/console theme:compile`

### SCSS Compilation Errors
- Check SCSS syntax in `overrides.scss`
- Avoid using SCSS functions like `darken()` with CSS custom properties
- Use static color values instead

## Technical Details

- **Shopware Version**: 6.7.2.2
- **PHP Version**: 8.2.29
- **Database**: MySQL 8.0
- **Theme Framework**: Twig templating with SCSS styling
- **JavaScript**: Vanilla JavaScript with modern ES6+ features
- **CSS Framework**: Bootstrap-based responsive design

## License

This project is created for demonstration purposes. Shopware is licensed under MIT License.

## Support

For Shopware-specific issues, refer to the official Shopware documentation:
- [Shopware Documentation](https://docs.shopware.com/)
- [Theme Development Guide](https://docs.shopware.com/en/shopware-6-en/themes-plugins/themes)

