# MyCustomTheme - Building & Metal Materials Theme Guide

## Overview

MyCustomTheme is a specialized Shopware 6 theme designed specifically for building materials and metal supplies stores. It features an industrial design aesthetic with professional styling suitable for B2B and B2C construction-related businesses.

## Design Philosophy

The theme follows these design principles:
- **Industrial Aesthetic**: Colors and styling that reflect the construction and metal industries
- **Professional Appearance**: Clean, trustworthy design suitable for business customers
- **Functionality First**: Easy navigation and clear product presentation
- **Mobile Responsive**: Optimized for all device sizes

## Color Palette

### Primary Colors
- **Primary Blue**: `#2c3e50` - Used for headers, primary buttons, and main text
- **Secondary Orange**: `#e67e22` - Used for accents, call-to-action buttons, and highlights
- **Steel Blue**: `#34495e` - Used for gradients and secondary elements

### Supporting Colors
- **Success Green**: `#27ae60` - Used for success messages and positive actions
- **Info Blue**: `#3498db` - Used for informational elements
- **Warning Orange**: `#f39c12` - Used for warnings and special offers
- **Danger Red**: `#e74c3c` - Used for errors and urgent notifications
- **Light Gray**: `#ecf0f1` - Used for backgrounds and subtle elements
- **Metal Silver**: `#bdc3c7` - Used for borders and neutral elements

## Typography

- **Primary Font**: Roboto (with Arial fallback)
- **Headings**: Bold weight (700) for strong hierarchy
- **Body Text**: Regular weight (400) for readability
- **Navigation**: Semi-bold weight (600) with uppercase styling

## Layout Structure

### Header
- **Top Bar**: Contact information and shipping notice
- **Main Header**: Logo, search bar, and user actions
- **Navigation**: Categorized menu with construction-focused categories

### Navigation Categories
1. **Building Materials**
   - Concrete & Cement
   - Lumber & Wood
   - Bricks & Blocks
   - Roofing Materials
   - Insulation

2. **Metal Supplies**
   - Steel Beams & Bars
   - Pipes & Tubes
   - Metal Sheets
   - Fasteners & Hardware
   - Custom Fabrication

3. **Tools & Equipment**
   - Hand Tools
   - Power Tools
   - Safety Equipment
   - Measuring Tools
   - Heavy Equipment

4. **Services**
   - Delivery Service
   - Custom Cutting
   - Project Estimation
   - Technical Support

### Homepage Sections

#### Hero Section
- Large banner with construction imagery
- Call-to-action buttons for shopping and quotes
- Professional messaging about quality and service

#### Features Section
- Four key value propositions:
  - Fast Delivery
  - Quality Materials
  - Expert Support
  - Best Prices

#### Categories Section
- Visual category cards with icons
- Direct links to main product categories
- Hover effects for better interactivity

#### Featured Products
- Product showcase with professional styling
- Badge system for new, sale, and featured items
- Add to cart functionality with animations

#### Services Section
- Detailed service offerings
- Professional icons and descriptions
- Focus on B2B services like delivery and fabrication

#### Newsletter Section
- Email subscription with professional styling
- Emphasis on exclusive deals and updates

### Footer
- **Company Information**: Logo and description
- **Quick Links**: Navigation shortcuts
- **Product Categories**: Direct category access
- **Customer Service**: Support and help links
- **Contact Information**: Address, phone, email, hours
- **Certifications**: Trust badges and certifications
- **Social Links**: Social media integration

## Component Styling

### Product Cards
- Clean, professional appearance
- Hover effects with subtle animations
- Badge system for product status
- Clear pricing and product information
- Prominent add-to-cart buttons

### Category Cards
- Large, clickable areas
- Icon-based visual representation
- Hover animations for interactivity
- Professional color scheme

### Buttons
- **Primary**: Steel blue background
- **Secondary**: Orange background
- **Success**: Green background (for add-to-cart)
- **Info**: Blue background (for categories)
- Consistent hover effects and transitions

### Forms
- Professional styling with orange accent colors
- Focus states with branded colors
- Consistent spacing and typography

## JavaScript Features

### Interactive Elements
- Smooth scrolling for anchor links
- Product card hover animations
- Category card icon scaling
- Search form enhancements
- Mobile menu functionality

### User Experience Enhancements
- Add to cart button animations with loading states
- Scroll-to-top button
- Image lazy loading
- Newsletter form handling
- Quantity controls for products

### Performance Features
- Intersection Observer for lazy loading
- Optimized animations and transitions
- Minimal JavaScript footprint

## Responsive Design

### Breakpoints
- **Mobile**: < 768px
- **Tablet**: 768px - 1024px
- **Desktop**: > 1024px

### Mobile Optimizations
- Collapsible navigation menu
- Touch-friendly button sizes
- Optimized typography scaling
- Simplified layouts for small screens

## Customization Options

### Theme Configuration
The theme provides configurable options through Shopware's theme system:
- Primary brand color
- Secondary brand color
- Success color
- Info color
- Warning color
- Danger color

### Template Overrides
Key templates that can be customized:
- `header.html.twig` - Header layout and branding
- `navigation.html.twig` - Main navigation structure
- `index.html.twig` - Homepage layout and content
- `footer.html.twig` - Footer content and links

### SCSS Variables
Customizable SCSS variables in `overrides.scss`:
- Color palette
- Typography settings
- Spacing and layout
- Animation timings
- Responsive breakpoints

## Best Practices

### Content Management
- Use high-quality product images
- Maintain consistent product descriptions
- Utilize the badge system for promotions
- Keep category descriptions concise and informative

### SEO Optimization
- Use descriptive alt text for images
- Maintain proper heading hierarchy
- Optimize meta descriptions for construction keywords
- Use structured data for products

### Performance
- Optimize images for web delivery
- Use lazy loading for below-the-fold content
- Minimize custom JavaScript additions
- Leverage browser caching

## Browser Support

- **Modern Browsers**: Chrome, Firefox, Safari, Edge (latest versions)
- **Mobile Browsers**: iOS Safari, Chrome Mobile, Samsung Internet
- **Fallbacks**: Graceful degradation for older browsers

## Maintenance

### Regular Updates
- Keep Shopware core updated
- Update theme assets when needed
- Test responsive design on new devices
- Monitor performance metrics

### Theme Compilation
After making changes, always run:
```bash
bin/console theme:compile
bin/console cache:clear
```

## Troubleshooting

### Common Issues
1. **SCSS Compilation Errors**: Check syntax and avoid unsupported functions
2. **Asset Loading**: Verify asset paths and compilation
3. **Responsive Issues**: Test on actual devices, not just browser tools
4. **JavaScript Errors**: Check browser console for conflicts

### Debug Mode
Enable debug mode in `.env` for development:
```
APP_DEBUG=1
```

## Future Enhancements

### Potential Additions
- Advanced product filtering for construction materials
- Project calculator tools
- Bulk ordering interface
- Customer-specific pricing displays
- Integration with construction project management tools

### Performance Improvements
- WebP image format support
- Critical CSS inlining
- Service worker implementation
- Advanced caching strategies

This theme provides a solid foundation for any building materials or metal supplies business looking to establish a professional online presence with Shopware 6.

