const n=`{% block sw_settings_payment_overview %} <sw-page class="sw-settings-payment-overview"> {% block sw_settings_payment_overview_smart_bar_actions %} <template #smart-bar-actions> {% block sw_settings_payment_overview_smart_bar_actions_add %} <mt-button v-tooltip="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('payment.creator'), showOnDisabledElements: true }" class="sw-settings-payment-overview__button-create" :disabled="!acl.can('payment.creator') || undefined" variant="primary" size="default" @click="$router.push({ name: 'sw.settings.payment.create' })" > {{ $tc('sw-settings-payment.list.buttonAddPaymentMethod') }} </mt-button> {% endblock %} </template> {% endblock %} {% block sw_settings_payment_overview_smart_bar_header %} <template #smart-bar-header> {% block sw_settings_payment_overview_smart_bar_header_title %} <h2 class="sw-settings-payment-overview__title"> {{ $tc('sw-settings-payment.general.mainMenuItemGeneral') }} </h2> {% endblock %} </template> {% endblock %} {% block sw_settings_payment_overview_language_switch %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_settings_payment_overview_content %} <template #content> {% block sw_settings_payment_overview_content_inner %} <sw-card-view class="sw-settings-payment-overview__content"> {% block sw_settings_payment_overview_sorting_modal_card %} <mt-card class="sw-settings-payment-overview__sorting_modal_card" position-identifier="sw-settings-payment-overview-sorting-modal-card" > <sw-button-process :disabled="isLoading || undefined" :is-loading="isLoading" :process-success="false" variant="primary" ghost @click="showSortingModal = true" > {{ $tc('sw-settings-payment.overview.openSortingModalButton') }} </sw-button-process> </mt-card> {% endblock %} {% block sw_settings_payment_overview_list %} <template v-for="card in paymentMethodCards" :key="card.id" > <template v-if="card.hasCustomCard"> {% block sw_settings_payment_overview_list_card_custom_location %} <sw-extension-component-section :key="\`extension-\${card.id}\`" :position-identifier="card.positionId" /> {% endblock %} </template> <template v-if="card.hasCustomCard && card.component"> {% block sw_settings_payment_overview_list_card_custom_card %} <component :is="card.component" :key="\`component-\${card.id}\`" :payment-methods="card.paymentMethods" @set-payment-active="togglePaymentMethodActive" /> {% endblock %} </template> <template v-if="!card.hasCustomCard"> {% block sw_settings_payment_overview_list_card_default %} <sw-payment-card :key="\`default-\${card.id}\`" :payment-method="card.paymentMethod" @set-payment-active="togglePaymentMethodActive" /> {% endblock %} </template> </template> {% endblock %} {% block sw_settings_payment_overview_empty_state %} <sw-empty-state v-if="isEmpty" :title="$tc('sw-empty-state.messageNoResultTitle')" > <template #default> {{ $tc('sw-empty-state.messageNoResultSublineBefore') }} <router-link class="sw-empty-state__description-link" :to="{ name: 'sw.profile.index.searchPreferences' }" > {{ $tc('sw-empty-state.messageNoResultSublineLink') }} </router-link> {{ $tc('sw-empty-state.messageNoResultSublineAfter') }} </template> </sw-empty-state> {% endblock %} </sw-card-view> {% endblock %} {% block sw_settings_payment_overview_sorting_modal %} <sw-settings-payment-sorting-modal v-if="showSortingModal" :payment-methods="paymentMethods" @modal-close="showSortingModal = false" @modal-save="loadPaymentMethods" /> {% endblock %} </template> {% endblock %} </sw-page> {% endblock %}`,{Mixin:r}=Shopware,{Criteria:i}=Shopware.Data,{cloneDeep:c}=Shopware.Utils.object,d=Shopware.Component.wrapComponentConfig({template:n,inject:["repositoryFactory","acl"],mixins:[r.getByName("notification")],data(){return{paymentMethods:[],isLoading:!1,showSortingModal:!1}},metaInfo(){return{title:this.$createTitle()}},computed:{customCards(){return Shopware.Store.get("paymentOverviewCard").cards??[]},paymentMethodRepository(){return this.repositoryFactory.create("payment_method")},paymentMethodCriteria(){const e=new i(1,500);return e.addAssociation("media"),e.addSorting(i.sort("position","ASC")),e},isEmpty(){return!this.isLoading&&this.paymentMethods.length===0},paymentMethodCards(){if(this.paymentMethods.length===0)return[];const e=[];let s=c(this.paymentMethods);return this.customCards.forEach(t=>{const a=s.filter(o=>t.paymentMethodHandlers.includes(o.formattedHandlerIdentifier));a.length!==0&&(e.push({id:a[0].id,hasCustomCard:!0,component:t.component,position:Math.min(...a.map(o=>o.position)),positionId:t.positionId,paymentMethods:a}),s=s.filter(o=>!t.paymentMethodHandlers.includes(o.formattedHandlerIdentifier)))}),e.push(...s.map(t=>({id:t.id,hasCustomCard:!1,paymentMethod:t,position:t.position,positionId:""}))),e.sort((t,a)=>t.position-a.position)}},created(){this.createdComponent()},methods:{createdComponent(){this.loadPaymentMethods()},loadPaymentMethods(){this.isLoading=!0,this.paymentMethodRepository.search(this.paymentMethodCriteria).then(e=>{this.paymentMethods=e}).finally(()=>{this.isLoading=!1})},onChangeLanguage(e){Shopware.Store.get("context").api.languageId=e,this.loadPaymentMethods()},togglePaymentMethodActive(e){const s=this.paymentMethods.find(t=>t.id===e.id);s&&(s.active=e.active,this.paymentMethodRepository.save(s).then(()=>{var t;this.loadPaymentMethods(),this.showActivationSuccessNotification(((t=s.translated)==null?void 0:t.name)??"",s.active)}).catch(()=>{var t;this.showActivationErrorNotification(((t=s.translated)==null?void 0:t.name)??"",s.active),this.$nextTick(()=>{s.active=!s.active})}))},showActivationSuccessNotification(e,s){const t=s?this.$t("sw-settings-payment.overview.notification.activationSuccess",{name:e},0):this.$t("sw-settings-payment.overview.notification.deactivationSuccess",{name:e},0);this.createNotificationSuccess({message:t})},showActivationErrorNotification(e,s){const t=s?this.$t("sw-settings-payment.overview.notification.activationError",{name:e},0):this.$t("sw-settings-payment.overview.notification.deactivationError",{name:e},0);this.createNotificationError({message:t})}}});export{d as default};
