<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @Storefront/storefront/page/error/error-domain-mapping.html.twig */
class __TwigTemplate_7212b653482711f26166f2d80f6ec1f4 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        // line 1
        yield "<!DOCTYPE html>
<html lang=\"en\">
    <head>
        <meta charset=\"UTF-8\">
        <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
        <meta name=\"robots\" content=\"noindex, nofollow\">
        ";
        // line 7
        if ((($tmp = ($context["debug"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 8
            yield "        <title>Shopware Domain Mapping Misconfiguration Help</title>
        ";
        } else {
            // line 10
            yield "        <title>Sales Channel Not Found</title>
        ";
        }
        // line 12
        yield "        <style>
            body {
                font-family: Arial, sans-serif;
                line-height: 1.6;
                color: #333;
                max-width: 1200px;
                margin: 0 auto;
                padding: 20px;
            }
            h1, h2 {
                color: #2c3e50;
            }
            .issue {
                background-color: #f8f9fa;
                border-left: 4px solid #007bff;
                padding: 10px;
                margin-bottom: 20px;
            }
            .solution {
                background-color: #e9ecef;
                border-left: 4px solid #28a745;
                padding: 10px;
                margin-top: 10px;
            }
            code {
                white-space: pre;
            }
        </style>
    </head>
    <body>

        ";
        // line 43
        if ((($tmp =  !($context["debug"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 44
            yield "        <h1>Sales Channel Not Found</h1>

        <p>Sorry, we couldn't find a Sales Channel for the current URL. Please check the URL and try again.</p>
        <p>For more information, enable the debug mode in the <code>.env</code> with <code>APP_DEBUG=1</code></p>
        ";
        }
        // line 49
        yield "
        ";
        // line 50
        if ((($tmp = ($context["debug"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 51
            yield "        <h1>Shopware Domain Mapping Misconfiguration Help</h1>

        <p>Dear Visitor, you accessed Shopware 6 with an unknown Domain. This page provides guidance on common misconfigurations and how to resolve them.</p>

        <h2>Common Misconfigurations</h2>

        <div class=\"issue\">
            <h3>1. Current URL not matching any Sales Channel Domains</h3>
            <p>Following URLs are known to Shopware: ";
            // line 59
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(($context["registeredDomains"] ?? null));
            foreach ($context['_seq'] as $context["_key"] => $context["domain"]) {
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["domain"], "html", null, true);
                yield ", ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['domain'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            yield "</p>
            <div class=\"solution\">
                <h4>Solution:</h4>
                <ol>
                    <li>Open the Administration</li>
                    <li>Click on the left bottom side on the desired sales channel</li>
                    <li>Make sure in the Domain Panel that the current access URL is added there: <code>";
            // line 65
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["domain"] ?? null), "html", null, true);
            yield "</code></li>
                </ol>
            </div>
        </div>

        <div class=\"issue\">
            <h3>2. Misconfigured Proxy Header forwarding / Trusted Proxies</h3>
            <p>Symptoms: Cannot resolve a Sales Channel, Assets are loading with http instead of https.</p>
            <div class=\"solution\">
                <h4>Solution:</h4>
                <p>Make sure the visible URL is the actual URL in your browser: <code>";
            // line 75
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["accessedUrl"] ?? null), "html", null, true);
            yield "</code>. If not, the proxy configuration could be wrong.</p>
                <p>
                    Shopware got following headers from IP <code>";
            // line 77
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["clientIp"] ?? null), "html", null, true);
            yield "</code>:<br>
                    <code>";
            // line 78
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($this->env->getFilter('json_encode')->getCallable()(($context["relevantHeaders"] ?? null), Twig\Extension\CoreExtension::constant("JSON_PRETTY_PRINT")), "html", null, true);
            yield "</code>
                    <br><br>

        The trusted_proxy configuration could look like this: <br>

        <code>
        # config/packages/framework.yaml
        framework:
            # You can use multiple with comma separated values or subnet notation (10.0.0.0/8)
            trusted_proxies: '";
            // line 87
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["clientIp"] ?? null), "html", null, true);
            yield "'
            # trust *all* \"X-Forwarded-*\" headers
            trusted_headers: [";
            // line 89
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(($context["trustedProxyRelevantHeaders"] ?? null));
            foreach ($context['_seq'] as $context["_key"] => $context["key"]) {
                yield " '";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["key"], "html", null, true);
                yield "', ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['key'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            yield "]
        </code><br>
        ";
            // line 91
            if (Twig\Extension\CoreExtension::testEmpty(($context["trustedProxyRelevantHeaders"] ?? null))) {
                // line 92
                yield "        <strong>We could not determine any proxy header, make sure your reverse proxy forwards headers like <code>X-Forwarded-For, X-Forwarded-Host, X-Forwarded-Proto</code></strong>
        ";
            }
            // line 94
            yield "                </p>

                <p>For further information about Trusted Proxies and configuration and handling of load balancer, <a href=\"https://symfony.com/doc/current/deployment/proxies.html\" target=\"_blank\">checkout the Symfony documentation</a></p>
            </div>
        </div>

        ";
        }
        // line 101
        yield "
    </body>
</html>
";
        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@Storefront/storefront/page/error/error-domain-mapping.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  202 => 101,  193 => 94,  189 => 92,  187 => 91,  173 => 89,  168 => 87,  156 => 78,  152 => 77,  147 => 75,  134 => 65,  117 => 59,  107 => 51,  105 => 50,  102 => 49,  95 => 44,  93 => 43,  60 => 12,  56 => 10,  52 => 8,  50 => 7,  42 => 1,);
    }

    public function getSourceContext(): Source
    {
        return new Source("", "@Storefront/storefront/page/error/error-domain-mapping.html.twig", "/home/ubuntu/shopware-project/vendor/shopware/storefront/Resources/views/storefront/page/error/error-domain-mapping.html.twig");
    }
}
