const u=`{% block sw_sales_channel_detail_base %} <div class="sw-sales-channel-detail-base"> {% block sw_sales_channel_detail_base_general %} <mt-card v-if="salesChannel" position-identifier="sw-sales-channel-detail-base-general" :is-loading="isLoading" :title="$tc('sw-sales-channel.detail.titleGeneralSettings')" > {% block sw_sales_channel_detail_base_general_input_product_comparison_template %} <mt-select v-if="isProductComparison" v-model="templateName" :disabled="!acl.can('sales_channel.editor') || undefined" :label="$tc('sw-sales-channel.detail.productComparison.templates.label')" :placeholder="$tc('sw-sales-channel.detail.productComparison.templates.placeholderSelectTemplate')" :options="templateSelectOptions" @update:model-value="(templateName) => $emit('template-selected', templateName)" /> {% endblock %} {% block sw_sales_channel_detail_product_comparison_template_modal %} <sw-modal v-if="showTemplateModal" :title="$tc('sw-sales-channel.detail.productComparison.templates.modal-title')" @modal-close="$emit('template-modal-close')" @template-modal-confirm="$emit('template-modal-confirm')" > {% block sw_sales_channel_detail_product_comparison_template_modal_notification %} <p>{{ $tc('sw-sales-channel.detail.productComparison.templates.modal-message') }}</p> <template #modal-footer> <mt-button size="small" variant="secondary" @click="$emit('template-modal-close')" > {{ $tc('global.default.cancel') }} </mt-button> <mt-button size="small" variant="primary" @click="$emit('template-modal-confirm')" > {{ $tc('sw-sales-channel.detail.productComparison.templates.modal-confirm') }} </mt-button> </template> {% endblock %} </sw-modal> {% endblock %} {% block sw_sales_channel_detail_base_general_input_name %} <mt-text-field v-model="salesChannel.name" validation="required" required :disabled="!acl.can('sales_channel.editor') || undefined" :placeholder="placeholder(salesChannel, 'name', $tc('sw-sales-channel.detail.placeholderName'))" :label="$tc('sw-sales-channel.detail.labelInputName')" :error="salesChannelNameError" class="sw-field--salesChannel-name" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_favorite %} <mt-switch :disabled="!acl.can('user_config:create') || !acl.can('user_config:update') || salesChannel._isNew" :label="$tc('sw-sales-channel.detail.favouriteLabel')" :model-value="isFavorite()" @update:model-value="(isFavorite) => { salesChannelFavoritesService.update(isFavorite, salesChannel.id) }" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_navigation_category_container %} <sw-container v-if="!isProductComparison" columns="1fr 200px" gap="0 30px" > {% block sw_sales_channel_detail_base_general_input_navigation_category %} <sw-category-tree-field v-if="!isProductComparison" id="navigationCategoryId" required :categories-collection="mainCategories" :placeholder="navigationCategoryPlaceholder" :single-select="true" :label="$tc('sw-sales-channel.detail.navigationCategoryId')" :disabled="!acl.can('sales_channel.editor') || undefined" :help-text="$tc('sw-sales-channel.detail.navigationCategoryHelpText')" :error="salesChannelNavigationCategoryIdError" class="sw-sales-channel-detail__select-navigation-category-id" @selection-add="onMainSelectionAdd" @selection-remove="onMainSelectionRemove" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_navigation_category_depth %} <mt-number-field v-model="salesChannel.navigationCategoryDepth" number-type="int" :min="1" :disabled="!acl.can('sales_channel.editor') || undefined" :label="$tc('sw-sales-channel.detail.navigationCategoryDepth')" /> {% endblock %} </sw-container> {% endblock %} {% block sw_sales_channel_detail_base_general_input_footer_category %} <sw-category-tree-field v-if="!isProductComparison" :categories-collection="footerCategories" :placeholder="footerCategoryPlaceholder" :single-select="true" :label="$tc('sw-sales-channel.detail.footerCategory')" :disabled="!acl.can('sales_channel.editor')" class="sw-sales-channel-detail__select-footer-category-id" @selection-add="onFooterSelectionAdd" @selection-remove="onFooterSelectionRemove" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_service_category %} <sw-category-tree-field v-if="!isProductComparison" :categories-collection="serviceCategories" :placeholder="serviceCategoryPlaceholder" :single-select="true" :label="$tc('sw-sales-channel.detail.serviceCategory')" :disabled="!acl.can('sales_channel.editor') || undefined" class="sw-sales-channel-detail__select-service-category-id" @selection-add="onServiceSelectionAdd" @selection-remove="onServiceSelectionRemove" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_customer_group %} <sw-entity-single-select v-if="!isProductComparison" v-model:value="salesChannel.customerGroupId" class="sw-sales-channel-detail__select-customer-group" required show-clearable-button :label="$tc('sw-sales-channel.detail.customerGroup')" entity="customer_group" :error="salesChannelCustomerGroupIdError" :disabled="!acl.can('sales_channel.editor')" /> {% endblock %} {% block sw_sales_channel_detail_base_disabled_countries_warning %} <mt-banner v-if="disabledCountries.length > 0" :variant="disabledCountryVariant" :title="$tc('global.default.' + disabledCountryVariant)" > <span v-html="buildDisabledPaymentAlert('sw-sales-channel.detail.warningDisabledCountries', disabledCountries)"></span> </mt-banner> {% endblock %} {% block sw_sales_channel_detail_base_general_input_countries %} <sw-sales-channel-defaults-select v-if="!isProductComparison" :sales-channel="salesChannel" property-name="countries" :property-label="$tc('sw-sales-channel.detail.labelInputCountries')" :help-text="$tc('sw-sales-channel.detail.countryMultiSelectHelpText')" default-property-name="countryId" :criteria="countryCriteria" :disabled="!acl.can('sales_channel.editor') || undefined" :default-property-label="$tc('sw-sales-channel.detail.labelInputDefaultCountry')" :disabled-tooltip-message="$tc('sw-sales-channel.detail.tooltipDisabledCountry')" should-show-active-state /> {% endblock %} <mt-banner v-if="unservedLanguages.length > 0" :variant="unservedLanguageVariant" :title="$tc('global.default.' + unservedLanguageVariant)" > <span v-html="buildUnservedLanguagesAlert('sw-sales-channel.detail.warningUnservedLanguage', unservedLanguages)"></span> </mt-banner> {% block sw_sales_channel_detail_base_general_input_languages %} <sw-sales-channel-defaults-select v-if="!isProductComparison" :sales-channel="salesChannel" :criteria="languageCriteria" property-name="languages" :property-label="$tc('sw-sales-channel.detail.labelInputLanguages')" default-property-name="languageId" :default-property-label="$tc('sw-sales-channel.detail.labelInputDefaultLanguage')" :disabled="!acl.can('sales_channel.editor') || undefined" property-name-in-domain="languageId" /> {% endblock %} <sw-sales-channel-measurement v-if="!isProductComparison" :sales-channel="salesChannel" :label-unit-system="$tc('sw-sales-channel.detail.measurementSystem.labelDefaultUnitSystem')" :label-length-unit="$tc('sw-sales-channel.detail.measurementSystem.labelDefaultLengthUnit')" :label-weight-unit="$tc('sw-sales-channel.detail.measurementSystem.labelDefaultWeightUnit')" /> </mt-card> {% endblock %} {% block sw_sales_channel_shipping_payment %} <mt-card v-if="salesChannel" position-identifier="sw-sales-channel-detail-base-shipping-payment" :is-loading="isLoading" :title="$tc('sw-sales-channel.detail.titleShippingPayment')" > {% block sw_sales_channel_detail_base_disabled_payments_methods_warning %} <mt-banner v-if="disabledPaymentMethods.length > 0" :variant="disabledPaymentMethodVariant" :title="$tc('global.default.' + disabledPaymentMethodVariant)" > <span v-html="buildDisabledPaymentAlert('sw-sales-channel.detail.warningDisabledPaymentMethod', disabledPaymentMethods, 'distinguishableName')"></span> </mt-banner> {% endblock %} {% block sw_sales_channel_detail_base_general_input_payments_methods %} <sw-sales-channel-defaults-select v-if="!isProductComparison" :sales-channel="salesChannel" property-name="paymentMethods" :criteria="paymentMethodCriteria" :property-label="$tc('sw-sales-channel.detail.labelInputPaymentMethods')" default-property-name="paymentMethodId" :disabled="!acl.can('sales_channel.editor') || undefined" :default-property-label="$tc('sw-sales-channel.detail.labelInputDefaultPaymentMethod')" :disabled-tooltip-message="$tc('sw-sales-channel.detail.tooltipDisabledPaymentMethod')" should-show-active-state /> {% endblock %} {% block sw_sales_channel_detail_base_disabled_shipping_methods_warning %} <mt-banner v-if="disabledShippingMethods.length > 0" :variant="disabledShippingMethodVariant" :title="$tc('global.default.' + disabledShippingMethodVariant)" > <span v-html="buildDisabledShippingAlert('sw-sales-channel.detail.warningDisabledShippingMethod', disabledShippingMethods)"></span> </mt-banner> {% endblock %} {% block sw_sales_channel_detail_base_general_input_shipping_methods %} <sw-sales-channel-defaults-select v-if="!isProductComparison" :sales-channel="salesChannel" property-name="shippingMethods" :property-label="$tc('sw-sales-channel.detail.labelInputShippingMethods')" default-property-name="shippingMethodId" :disabled="!acl.can('sales_channel.editor') || undefined" :default-property-label="$tc('sw-sales-channel.detail.labelInputDefaultShippingMethod')" :disabled-tooltip-message="$tc('sw-sales-channel.detail.tooltipDisabledShippingMethod')" should-show-active-state :criteria="shippingMethodCriteria" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_currencies %} <sw-sales-channel-defaults-select v-if="!isProductComparison" :sales-channel="salesChannel" property-name="currencies" :property-label="$tc('sw-sales-channel.detail.labelInputCurrencies')" default-property-name="currencyId" :disabled="!acl.can('sales_channel.editor') || undefined" :default-property-label="$tc('sw-sales-channel.detail.labelInputDefaultCurrency')" property-name-in-domain="currencyId" :criteria="currencyCriteria" /> {% endblock %} <sw-radio-field v-model:value="salesChannel.taxCalculationType" :label="$tc('sw-sales-channel.detail.labelTaxCalculation')" :help-text="helpTextTaxCalculation" block class="sw-sales-channel-detail__tax-calculation" identification="taxCalculation" :disabled="!acl.can('sales_channel.editor') || undefined" :description="$tc('sw-sales-channel.detail.descriptionTaxCalculation')" :options="taxCalculationTypeOptions" /> </mt-card> {% endblock %} {% block sw_sales_channel_detail_base_options_hreflang %} <sw-sales-channel-detail-hreflang v-if="salesChannel && isStorefront" :sales-channel="salesChannel" :disabled="!acl.can('sales_channel.editor') || undefined" :is-loading="isLoading" /> {% endblock %} {% block sw_sales_channel_detail_base_options_domains %} <sw-sales-channel-detail-domains v-if="salesChannel && isDomainAware" :sales-channel="salesChannel" :disable-edit="!acl.can('sales_channel.editor') || undefined" :is-loading="isLoading" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_storefront %} <mt-card v-if="salesChannel && isProductComparison" position-identifier="sw-sales-channel-detail-base-general-input-product-comparison-storefront" :is-loading="isLoading" :title="$tc('sw-sales-channel.detail.productComparison.storefront')" > {% block sw_sales_channel_detail_base_general_input_product_comparison_storefront_select %} <sw-entity-single-select v-model:value="productExport.storefrontSalesChannelId" class="sw-sales-channel-detail__product-comparison-storefront" :label="$tc('sw-sales-channel.detail.productComparison.storefront')" :criteria="storefrontSalesChannelCriteria" label-property="name" :disabled="!acl.can('sales_channel.editor') || undefined" value-property="id" entity="sales_channel" required show-clearable-button @update:value="onStorefrontSelectionChange" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_storefront_domain %} <sw-entity-single-select v-model:value="productExport.salesChannelDomainId" class="sw-sales-channel-detail__product-comparison-domain" :label="$tc('sw-sales-channel.detail.productComparison.storefrontDomain')" :criteria="storefrontSalesChannelDomainCriteria" label-property="url" value-property="id" entity="sales_channel_domain" required show-clearable-button :disabled="(!productExport.salesChannelDomainId && !productExport.storefrontSalesChannelId) || !acl.can('sales_channel.editor') || undefined" :error="productExportSalesChannelDomainIdError" @update:value="onStorefrontDomainSelectionChange" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_storefront_domain_currency %} <div v-if="productExport.salesChannelDomain" class="sw-sales-channel-detail-base__product-comparison-container" > <sw-entity-single-select v-model:value="productExport.currencyId" :label="$tc('sw-sales-channel.detail.productComparison.storefrontDomainCurrency.label')" :criteria="storefrontSalesChannelCurrencyCriteria" label-property="name" value-property="id" required entity="currency" :disabled="!acl.can('sales_channel.editor') || undefined" :error="productExportCurrencyIdError" show-clearable-button /> </div> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_storefront_domain_language %} <div v-if="productExport.salesChannelDomain" class="sw-sales-channel-detail-base__product-comparison-container" > <sw-entity-single-select v-model:value="productExport.salesChannelDomain.languageId" :label="$tc('sw-sales-channel.detail.productComparison.storefrontDomainLanguage.label')" label-property="name" value-property="id" entity="language" :disabled="true" show-clearable-button /> <sw-help-text class="sw-sales-channel-detail-base__product-comparison-helptext" :text="$tc('sw-sales-channel.detail.productComparison.storefrontDomainLanguage.help')" :disabled="!acl.can('sales_channel.editor')" tooltip-position="top" /> </div> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_storefront_sales_channel_customer_group %} <div class="sw-sales-channel-detail-base__product-comparison-container"> <sw-entity-single-select v-model:value="salesChannel.customerGroupId" :label="$tc('sw-sales-channel.detail.productComparison.storefrontSalesChannelCustomerGroup.label')" label-property="name" value-property="id" entity="customer_group" :disabled="true" show-clearable-button /> <sw-help-text class="sw-sales-channel-detail-base__product-comparison-helptext" :text="$tc('sw-sales-channel.detail.productComparison.storefrontSalesChannelCustomerGroup.help')" tooltip-position="top" /> </div> {% endblock %} </mt-card> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_settings %} <mt-card v-if="salesChannel && isProductComparison" position-identifier="sw-sales-channel-detail-base-general-input-product-comparison-settings" :is-loading="isLoading" :title="$tc('sw-sales-channel.detail.productComparison.settings')" > {% block sw_sales_channel_detail_base_general_input_product_comparison_filename %} <mt-text-field v-model="productExport.fileName" validation="required" required :disabled="!acl.can('sales_channel.editor') || undefined" :label="$tc('sw-sales-channel.detail.productComparison.fileName')" :placeholder="$tc('sw-sales-channel.detail.productComparison.placeholderFileName')" :error="productExportFileNameError || invalidFileNameError" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_encoding %} <mt-select v-model="productExport.encoding" :label="$tc('sw-sales-channel.detail.productComparison.encoding')" :placeholder="$tc('sw-sales-channel.detail.productComparison.placeholderSelectEncoding')" :options="getEncodingOptions" label-property="label" value-property="id" :disabled="!acl.can('sales_channel.editor') || undefined" required :error="productExportEncodingError" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_file_format %} <mt-select v-model="productExport.fileFormat" :label="$tc('sw-sales-channel.detail.productComparison.fileFormat')" :placeholder="$tc('sw-sales-channel.detail.productComparison.placeholderSelectFileFormat')" :options="getFileFormatOptions" label-property="label" value-property="id" required :disabled="!acl.can('sales_channel.editor') || undefined" :error="productExportFileFormatError" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_include_variants %} <mt-switch v-model="productExport.includeVariants" bordered :disabled="!acl.can('sales_channel.editor') || undefined" :label="$tc('sw-sales-channel.detail.productComparison.includeVariants')" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_interval %} <mt-select :model-value="productExport.interval" :label="$tc('sw-sales-channel.detail.productComparison.interval')" :options="getIntervalOptions" label-property="label" value-property="id" :disabled="!acl.can('sales_channel.editor') || undefined" @update:model-value="changeInterval" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_generate_by_cronjob %} <mt-switch v-model="productExport.generateByCronjob" bordered :label="$tc('sw-sales-channel.detail.productComparison.generateByCronjob')" :disabled="disableGenerateByCronjob || !acl.can('sales_channel.editor') || undefined" /> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_last_generation %} <div v-if="productExport.salesChannelDomainId"> <div v-if="productExport.generatedAt" class="sw-sales-channel-detail-base_general__last-generation-text" > {{ $tc('sw-sales-channel.detail.productComparison.lastGenerationLabel') }}<sw-time-ago :date="productExport.generatedAt" :date-time-format="{ month: '2-digit', day: '2-digit' }" /> </div> <div v-else class="sw-sales-channel-detail-base_general__last-generation-text" > {{ $tc('sw-sales-channel.detail.productComparison.lastGenerationLabel') }}{{ $tc('sw-sales-channel.detail.productComparison.notYetGenerated') }} </div> </div> {% endblock %} {% block sw_sales_channel_detail_base_general_input_product_comparison_product_stream %} <sw-entity-single-select v-model:value="productExport.productStreamId" class="sw-sales-channel-detail__product-comparison-product-stream" :label="$tc('sw-sales-channel.detail.productComparison.productStream')" label-property="name" value-property="id" required show-clearable-button :disabled="!acl.can('sales_channel.editor') || undefined" entity="product_stream" :error="productExportProductStreamIdError" /> {% endblock %} <mt-text-field v-if="salesChannel.productExports && salesChannel.productExports.length > 0" v-model="cliCommand" copyable :label="$tc('sw-sales-channel.detail.productComparison.cliCommand')" readonly :disabled="true" /> </mt-card> {% endblock %} {% block sw_sales_channel_detail_base_options_api %} <mt-card v-if="salesChannel" position-identifier="sw-sales-channel-detail-base-options-api" :is-loading="isLoading" :title="$tc('sw-sales-channel.detail.titleOptionsApiKey')" > {% block sw_sales_channel_detail_base_options_api_description %} <div class="sw-sales-channel-detail-base__description-text" v-html="$tc('sw-sales-channel.detail.textApiAccessDescription')" ></div> {% endblock %} {% block sw_sales_channel_detail_base_options_input_access_key %} <mt-text-field v-if="!isProductComparison" v-model="salesChannel.accessKey" :label="$tc('sw-sales-channel.detail.labelAccessKeyField')" :disabled="true" /> {% endblock %} {% block sw_sales_channel_detail_base_options_input_generate_key %} <div v-if="!isProductComparison" class="sw-sales-channel-detail__action-buttons" > <mt-button size="small" :disabled="!acl.can('sales_channel.editor') || undefined" class="sw-sales-channel-detail-base__button-generate-keys" variant="secondary" @click="onGenerateKeys" > {{ $tc('sw-sales-channel.detail.buttonCreateNewApiKeys') }} </mt-button> <mt-button size="small" class="sw-sales-channel-detail-base__button-copy-key" variant="secondary" @click="copyToClipboard" > {{ $tc('sw-sales-channel.detail.buttonCopyApiKeyButton') }} </mt-button> </div> {% endblock %} {% block sw_sales_channel_detail_base_product_comparison_access_key %} {% block sw_sales_channel_detail_base_product_comparison_input_access_key %} <mt-text-field v-if="isProductComparison" v-model="productExport.accessKey" :label="$tc('sw-sales-channel.detail.productComparison.accessKey')" :disabled="true" :copyable="true" /> {% endblock %} {% block sw_sales_channel_detail_base_product_comparison_input_access_url %} <mt-text-field v-if="isProductComparison && productExport.salesChannelDomainId" v-model="productComparisonAccessUrl" :label="$tc('sw-sales-channel.detail.productComparison.accessUrl')" :disabled="true" :copyable="true" /> {% endblock %} {% block sw_sales_channel_detail_base_product_comparison_input_generate_key %} <div class="sw-sales-channel-detail__action-button"> <mt-button v-if="isProductComparison" ghost :disabled="!acl.can('sales_channel.editor')" size="small" class="sw-sales-channel-detail-base__button-generate-keys" variant="secondary" @click="onGenerateProductExportKey" > {{ $tc('sw-sales-channel.detail.productComparison.buttonCreateNewAccessKey') }} </mt-button> </div> {% endblock %} {% endblock %} </mt-card> {% endblock %} {% block sw_sales_channel_detail_base_options_status %} <mt-card v-if="salesChannel" position-identifier="sw-sales-channel-detail-base-options-status" :title="$tc('sw-sales-channel.detail.titleStatus')" :is-loading="isLoading" > {% block sw_sales_channel_detail_base_options_status_description %} <div class="sw-sales-channel-detail-base__description-text"> {{ $tc('sw-sales-channel.detail.textActiveDescription') }} </div> {% endblock %} {% block sw_sales_channel_detail_base_status_input_active %} <mt-switch v-model="salesChannel.active" :label="$tc('sw-sales-channel.detail.labelInputActive')" :disabled="!acl.can('sales_channel.editor') || undefined" @update:model-value="onToggleActive" /> {% endblock %} {% block sw_sales_channel_detail_base_options_maintenance_header %} <h4 class="sw-sales-channel-detail-base__headline-text"> {{ $tc('sw-sales-channel.detail.maintenanceModeTitle') }} </h4> <div class="sw-sales-channel-detail-base__description-text"> {{ $tc('sw-sales-channel.detail.maintenanceModeDescription') }} </div> {% endblock %} {% block sw_sales_channel_detail_base_maintenance_input_active %} <mt-switch v-model="salesChannel.maintenance" name="sw-field--salesChannel-maintenance" :disabled="!acl.can('sales_channel.editor') || undefined" :label="$tc('sw-sales-channel.detail.labelMaintenanceActive')" /> {% endblock %} {% block sw_sales_channel_detail_base_maintenance_ipwhitelist %} <sw-multi-tag-ip-select v-model:value="maintenanceIpAllowlist" :is-loading="isLoading" :disabled="!acl.can('sales_channel.editor') || undefined" class="sw-order-user-card__tag-select" :label="$tc('sw-sales-channel.detail.ipAddressAllowlist')" :help-text="$tc('sw-sales-channel.detail.ipAddressAllowlistHelpText')" :known-ips="knownIps" :validate="validateMaintenanceIpCidr" error-code="SHOPWARE_INVALID_IP_CIDR" /> {% endblock %} {% block sw_sales_channel_detail_base_settings_link %} <div class="sw-sales-channel-detail-base__settings-link"> <router-link v-if="acl.can('sales_channel.editor')" :to="{ name: 'sw.settings.basic.information.index'}" class="sw-card__quick-link" > {{ $tc('sw-sales-channel.detail.basicinformationLink') }} <mt-icon name="regular-long-arrow-right" size="16px" /> </router-link> </div> {% endblock %} </mt-card> {% endblock %} {% block sw_sales_channel_detail_base_options_delete %} <mt-card v-if="salesChannel && acl.can('sales_channel.deleter')" position-identifier="sw-sales-channel-detail-base-options-delete" :title="$tc('sw-sales-channel.detail.deleteModalTitle')" :is-loading="isLoading" > <sw-container columns="1fr 175px" gap="0px 30px" class="sw-sales-channel-detail-base__delete-sales-channel" > <div class="sw-sales-channel-detail-base__description-text"> <strong>{{ $tc('global.default.warning') }}</strong> {{ $tc('sw-sales-channel.detail.textDeleteSalesChannelWarning') }} </div> {% block sw_sales_channel_detail_base_options_delete_button %} <div class="sw-sales-channel-detail-base__button-delete"> <mt-button variant="critical" size="small" @click="showDeleteModal = true" > {{ $tc('sw-sales-channel.detail.buttonDelete') }} </mt-button> </div> {% endblock %} </sw-container> {% block sw_sales_channel_detail_base_options_delete_modal %} <sw-modal v-if="showDeleteModal" ref="modal" class="sw-sales-channel-detail-base__delete-modal" variant="small" :title="$tc('sw-sales-channel.detail.deleteModalTitle')" @modal-close="onCloseDeleteModal" > {% block sw_sales_channel_detail_options_delete_modal_confirmtext %} <p class="sw-sales-channel-detail-base__delete-modal-confirm-text"> {{ $tc('sw-sales-channel.detail.textConfirmDelete') }} </p> <p class="sw-sales-channel-detail-base__delete-modal-name"> <strong>{{ placeholder(salesChannel, 'name') }}</strong> </p> <p>{{ $tc('sw-sales-channel.detail.textDeleteInfo') }}</p> {% endblock %} {% block sw_sales_channel_detail_options_delete_modal_footer %} <template #modal-footer> {% block sw_sales_channel_detail_options_delete_modal_abort %} <mt-button size="small" variant="secondary" @click="onCloseDeleteModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_sales_channel_detail_options_delete_modal_confirm %} <mt-button size="small" variant="critical" @click="onConfirmDelete" > {{ $tc('sw-sales-channel.detail.buttonConfirmDelete') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} </mt-card> {% endblock %} {% block sw_sales_channel_detail_custom_field_sets %} <mt-card v-if="salesChannel && customFieldSets.length > 0" position-identifier="sw-sales-channel-detail-base-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="salesChannel" :sets="customFieldSets" /> </mt-card> {% endblock %} </div> {% endblock %}`,{Component:_,Mixin:r,Context:c,Defaults:n}=Shopware,{Criteria:t}=Shopware.Data,m=Shopware.Utils.dom,b=Shopware.Classes.ShopwareError,o=Shopware.Utils,{mapPropertyErrors:d}=_.getComponentHelper(),g={template:u,inject:["salesChannelService","productExportService","repositoryFactory","knownIpsService","acl"],emits:["template-selected","template-modal-close","template-modal-confirm","invalid-file-name","valid-file-name","access-key-changed","domain-changed"],mixins:[r.getByName("notification"),r.getByName("placeholder")],props:{salesChannel:{required:!0},productExport:{type:Object,required:!0},storefrontSalesChannelCriteria:{type:t,required:!1},customFieldSets:{type:Array,required:!0},isLoading:{type:Boolean,default:!1},productComparisonAccessUrl:{type:String,default:""},templateOptions:{type:Array,default:()=>[]},showTemplateModal:{type:Boolean,default:!1},templateName:{type:String,default:null}},data(){return{showDeleteModal:!1,defaultSnippetSetId:"71a916e745114d72abafbfdc51cbd9d0",isLoadingDomains:!1,deleteDomain:null,storefrontDomains:[],selectedStorefrontSalesChannel:null,invalidFileName:!1,isFileNameChecking:!1,disableGenerateByCronjob:!1,knownIps:[],mainCategoriesCollection:null,footerCategoriesCollection:null,serviceCategoriesCollection:null,defaultMeasurementSystemId:null,defaultLengthUnitId:null,defaultWeightUnitId:null}},computed:{secretAccessKeyFieldType(){return this.showSecretAccessKey?"text":"password"},isStorefront(){var e;return((e=this.salesChannel)==null?void 0:e.typeId)===n.storefrontSalesChannelTypeId},isDomainAware(){return[n.storefrontSalesChannelTypeId,n.apiSalesChannelTypeId].includes(this.salesChannel.typeId)},salesChannelRepository(){return this.repositoryFactory.create("sales_channel")},isProductComparison(){return this.salesChannel&&this.salesChannel.typeId===n.productComparisonTypeId},isHeadlessSalesChannel(){var e;return((e=this.salesChannel)==null?void 0:e.typeId)===n.apiSalesChannelTypeId},storefrontSalesChannelDomainCriteria(){return new t(1,25).addFilter(t.equals("salesChannelId",this.productExport.storefrontSalesChannelId))},storefrontSalesChannelCurrencyCriteria(){const e=new t(1,25);return e.addAssociation("salesChannels"),e.addFilter(t.equals("salesChannels.id",this.productExport.storefrontSalesChannelId))},paymentMethodCriteria(){const e=new t(1,25);return e.addSorting(t.sort("name","ASC")),e},countryCriteria(){const e=new t(1,25);return e.addSorting(t.sort("position","ASC")),e.addSorting(t.sort("name","ASC")),e},languageCriteria(){const e=new t;return e.addFilter(t.equals("active",!0)),e},disabledCountries(){var e,a;return((a=(e=this.salesChannel)==null?void 0:e.countries)==null?void 0:a.filter(l=>l.active===!1))??[]},disabledCountryVariant(){return this.disabledCountries.find(e=>e.id===this.salesChannel.countryId)?"attention":"info"},disabledPaymentMethods(){var e,a;return((a=(e=this.salesChannel)==null?void 0:e.paymentMethods)==null?void 0:a.filter(l=>l.active===!1))??[]},disabledPaymentMethodVariant(){return this.disabledPaymentMethods.find(e=>e.id===this.salesChannel.paymentMethodId)?"attention":"info"},disabledShippingMethods(){var e,a;return((a=(e=this.salesChannel)==null?void 0:e.shippingMethods)==null?void 0:a.filter(l=>l.active===!1))??[]},disabledShippingMethodVariant(){return this.disabledShippingMethods.find(e=>e.id===this.salesChannel.shippingMethodId)?"attention":"info"},unservedLanguages(){var e;return((e=this.salesChannel.languages)==null?void 0:e.filter(a=>{var l;return(((l=this.salesChannel.domains)==null?void 0:l.filter(s=>s.languageId===a.id))||[]).length===0}))??[]},unservedLanguageVariant(){return this.unservedLanguages.find(e=>e.id===this.salesChannel.languageId)?"attention":"info"},storefrontDomainsLoaded(){return this.storefrontDomains.length>0},domainRepository(){return this.repositoryFactory.create(this.salesChannel.domains.entity,this.salesChannel.domains.source)},globalDomainRepository(){return this.repositoryFactory.create("sales_channel_domain")},productExportRepository(){return this.repositoryFactory.create("product_export")},mainNavigationCriteria(){return new t(1,10).addFilter(t.equalsAny("type",["page","folder"]))},getIntervalOptions(){return[{id:0,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.0")},{id:120,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.120")},{id:300,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.300")},{id:600,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.600")},{id:900,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.900")},{id:1800,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.1800")},{id:3600,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.3600")},{id:7200,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.7200")},{id:14400,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.14400")},{id:28800,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.28800")},{id:43200,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.43200")},{id:86400,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.86400")},{id:172800,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.172800")},{id:259200,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.259200")},{id:345600,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.345600")},{id:432e3,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.432000")},{id:518400,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.518400")},{id:604800,label:this.$tc("sw-sales-channel.detail.productComparison.intervalLabels.604800")}]},getFileFormatOptions(){return[{id:"csv",label:this.$tc("sw-sales-channel.detail.productComparison.fileFormatLabels.csv")},{id:"xml",label:this.$tc("sw-sales-channel.detail.productComparison.fileFormatLabels.xml")}]},getEncodingOptions(){return[{id:"ISO-8859-1",label:"ISO-8859-1"},{id:"UTF-8",label:"UTF-8"}]},invalidFileNameError(){return this.invalidFileName&&!this.isFileNameChecking?(this.$emit("invalid-file-name"),new b({code:"DUPLICATED_PRODUCT_EXPORT_FILE_NAME"})):(this.$emit("valid-file-name"),null)},helpTextTaxCalculation(){const e={name:"sw.settings.tax.index"};return this.$tc("sw-sales-channel.detail.helpTextTaxCalculation.label",{link:`<sw-internal-link
                           :router-link=${JSON.stringify(e)}
                           :inline="true">
                           ${this.$tc("sw-sales-channel.detail.helpTextTaxCalculation.linkText")}
                      </sw-internal-link>`},0)},taxCalculationTypeOptions(){return[{value:"horizontal",name:this.$tc("sw-sales-channel.detail.taxCalculation.horizontalName"),description:this.$tc("sw-sales-channel.detail.taxCalculation.horizontalDescription")},{value:"vertical",name:this.$tc("sw-sales-channel.detail.taxCalculation.verticalName"),description:this.$tc("sw-sales-channel.detail.taxCalculation.verticalDescription")}]},maintenanceIpAllowlist:{get(){return this.salesChannel.maintenanceIpWhitelist??[]},set(e){this.salesChannel.maintenanceIpWhitelist=e}},...d("salesChannel",["name","customerGroupId","navigationCategoryId"]),...d("productExport",["productStreamId","encoding","fileName","fileFormat","salesChannelDomainId","currencyId"]),categoryRepository(){return this.repositoryFactory.create("category")},mainCategoryCriteria(){const e=new t(1,25);return e.addFilter(t.equals("id",this.salesChannel.navigationCategoryId||null)),e},footerCategoryCriteria(){const e=new t(1,25);return e.addFilter(t.equals("id",this.salesChannel.footerCategoryId||null)),e},serviceCategoryCriteria(){const e=new t(1,25);return e.addFilter(t.equals("id",this.salesChannel.serviceCategoryId||null)),e},mainCategories(){return this.mainCategoriesCollection?this.mainCategoriesCollection:[]},footerCategories(){return this.footerCategoriesCollection?this.footerCategoriesCollection:[]},serviceCategories(){return this.serviceCategoriesCollection?this.serviceCategoriesCollection:[]},navigationCategoryPlaceholder(){return this.salesChannel.navigationCategoryId?"":this.$tc("sw-category.base.link.categoryPlaceholder")},footerCategoryPlaceholder(){return this.salesChannel.footerCategoryId?"":this.$tc("sw-category.base.link.categoryPlaceholder")},serviceCategoryPlaceholder(){return this.salesChannel.serviceCategoryId?"":this.$tc("sw-category.base.link.categoryPlaceholder")},salesChannelFavoritesService(){return Shopware.Service("salesChannelFavorites")},currencyCriteria(){const e=new t(1,25);return e.addSorting(t.sort("name","ASC")),e},shippingMethodCriteria(){const e=new t(1,25);return e.addSorting(t.sort("name","ASC")),e},dateFilter(){return Shopware.Filter.getByName("date")},cliCommand(){return this.salesChannel.productExports===void 0||this.salesChannel.productExports.length===0?"":`php bin/console product-export:generate ${this.salesChannel.productExports[0].storefrontSalesChannelId} ${this.salesChannel.productExports[0].id}`},templateSelectOptions(){return this.templateOptions.map(e=>({value:e.name,id:e.name,label:this.$tc(e.translationKey)}))}},watch:{"productExport.fileName"(){this.onChangeFileName()},salesChannel(){this.createCategoryCollections()}},created(){var e,a,l;this.knownIpsService.getKnownIps().then(s=>{this.knownIps=s}),this.createCategoryCollections(),this.defaultMeasurementSystemId=(e=this.salesChannel)==null?void 0:e.measurementSystemId,this.defaultLengthUnitId=(a=this.salesChannel)==null?void 0:a.lengthUnitId,this.defaultWeightUnitId=(l=this.salesChannel)==null?void 0:l.weightUnitId},methods:{onGenerateKeys(){this.salesChannelService.generateKey().then(e=>{this.salesChannel.accessKey=e.accessKey}).catch(()=>{this.createNotificationError({message:this.$tc("sw-sales-channel.detail.messageAPIError")})})},onGenerateProductExportKey(e=!0){this.productExportService.generateKey().then(a=>{this.productExport.accessKey=a.accessKey,this.$emit("access-key-changed"),e&&this.createNotificationInfo({message:this.$tc("sw-sales-channel.detail.productComparison.messageAccessKeyChanged")})}).catch(()=>{this.createNotificationError({message:this.$tc("sw-sales-channel.detail.messageAPIError")})})},onToggleActive(){if(this.salesChannel.active!==!0||this.isProductComparison||this.isHeadlessSalesChannel)return;const e=new t(1,25);e.addAssociation("themes"),this.salesChannelRepository.get(this.$route.params.id.toLowerCase(),c.api,e).then(a=>{a.extensions.themes!==void 0&&a.extensions.themes.length>=1||(this.salesChannel.active=!1,this.createNotificationError({message:this.$tc("sw-sales-channel.detail.messageActivateWithoutThemeError",{name:this.salesChannel.name||this.placeholder(this.salesChannel,"name")},0)}))})},onCloseDeleteModal(){this.showDeleteModal=!1},onConfirmDelete(){this.showDeleteModal=!1,this.$nextTick(()=>{this.deleteSalesChannel(this.salesChannel.id),this.$router.push({name:"sw.dashboard.index"})})},deleteSalesChannel(e){this.salesChannelRepository.delete(e,c.api).then(()=>{Shopware.Utils.EventBus.emit("sw-sales-channel-detail-base-sales-channel-change"),this.salesChannelFavoritesService.refresh()})},async copyToClipboard(){try{await m.copyStringToClipboard(this.salesChannel.accessKey),this.createNotificationSuccess({message:this.$tc("global.sw-field.notification.notificationCopySuccessMessage")})}catch{this.createNotificationError({title:this.$tc("global.default.error"),message:this.$tc("global.sw-field.notification.notificationCopyFailureMessage")})}},onStorefrontSelectionChange(e){this.salesChannelRepository.get(e).then(a=>{this.salesChannel.languageId=a.languageId,this.salesChannel.currencyId=a.currencyId,this.salesChannel.paymentMethodId=a.paymentMethodId,this.salesChannel.shippingMethodId=a.shippingMethodId,this.salesChannel.countryId=a.countryId,this.salesChannel.navigationCategoryId=a.navigationCategoryId,this.salesChannel.navigationCategoryVersionId=a.navigationCategoryVersionId,this.salesChannel.customerGroupId=a.customerGroupId})},onStorefrontDomainSelectionChange(e){this.globalDomainRepository.get(e).then(a=>{this.productExport.salesChannelDomain=a,this.productExport.currencyId=a.currencyId,this.$emit("domain-changed")})},loadStorefrontDomains(e){const a=new t(1,25);a.addFilter(t.equals("salesChannelId",e)),this.globalDomainRepository.search(a).then(l=>{this.storefrontDomains=l})},onChangeFileName(){this.isFileNameChecking=!0,this.onChangeFileNameDebounce()},onChangeFileNameDebounce:o.debounce(function(){if(!this.productExport)return;if(typeof this.productExport.fileName!="string"||this.productExport.fileName.trim()===""){this.invalidFileName=!1,this.isFileNameChecking=!1;return}const a=new t(1,1);a.addFilter(t.multi("AND",[t.equals("fileName",this.productExport.fileName),t.not("AND",[t.equals("id",this.productExport.id)])])),this.productExportRepository.search(a).then(({total:l})=>{this.invalidFileName=l>0,this.isFileNameChecking=!1}).catch(()=>{this.invalidFileName=!0,this.isFileNameChecking=!1})},500),changeInterval(e){this.productExport.interval=e,this.disableGenerateByCronjob=this.productExport.interval===0,this.productExport.generateByCronjob=!this.disableGenerateByCronjob},createCategoryCollections(){this.salesChannel&&(this.createCategoriesCollection(this.mainCategoryCriteria,"mainCategoriesCollection"),this.createCategoriesCollection(this.footerCategoryCriteria,"footerCategoriesCollection"),this.createCategoriesCollection(this.serviceCategoryCriteria,"serviceCategoriesCollection"))},async createCategoriesCollection(e,a){this[a]=await this.categoryRepository.search(e,Shopware.Context.api)},onMainSelectionAdd(e){this.salesChannel.navigationCategoryId=e.id},onMainSelectionRemove(){this.salesChannel.navigationCategoryId=null},onFooterSelectionAdd(e){this.salesChannel.footerCategoryId=e.id},onFooterSelectionRemove(){this.salesChannel.footerCategoryId=null},onServiceSelectionAdd(e){this.salesChannel.serviceCategoryId=e.id},onServiceSelectionRemove(){this.salesChannel.serviceCategoryId=null},buildDisabledPaymentAlert(e,a,l="name"){const s={name:"sw.settings.payment.overview"},i=this.$router.resolve(s),h={separatedList:a.map(p=>`<span>${p.translated[l].replaceAll("|","&vert;")}</span>`).join(", "),paymentSettingsLink:i.href};return this.$t(e,h,a.length)},buildDisabledShippingAlert(e,a,l="name"){const s={name:a.first().translated[l].replaceAll("|","&vert;"),addition:a.length>2?this.$t("sw-sales-channel.detail.warningDisabledAddition",{amount:a.length-1},1):a.last().translated[l].replaceAll("|","&vert;")};return this.$t(e,s,a.length)},buildUnservedLanguagesAlert(e,a,l="name"){const s={list:a.map(i=>i[l]).join(", ")};return this.$t(e,s,a.length)},isFavorite(){return this.salesChannelFavoritesService.isFavorite(this.salesChannel.id)},validateMaintenanceIpCidr(e){return o.string.isValidIp(e)||o.string.isValidCidr(e)}}};export{g as default};
