const m=`{% block sw_colorpicker %} <div class="sw-colorpicker"> {% block sw_colorpicker_contextual_field %} <sw-contextual-field v-bind="{ ...$attrs, ...inheritanceAttrs }" :name="formFieldName" :disabled="disabled" @inheritance-restore="$emit('inheritance-restore', $event)" @inheritance-remove="$emit('inheritance-remove', $event)" > {% block sw_colorpicker_input_prefix %} <template #sw-contextual-field-prefix> <div tabindex="0" role="button" class="sw-colorpicker__previewWrapper" @click="toggleColorPicker" > <div class="sw-colorpicker__previewColor" :class="{active:visible}" :style="{ background: previewColorValue }" ></div> <div class="sw-colorpicker__previewBackground" :class="{'is--invalid': !isColorValid}" ></div> </div> </template> {% endblock %} {% block sw_colorpicker_input_field %} <template #sw-field-input="{ disabled }"> <input v-model="colorValue" class="sw-colorpicker__input" :spellcheck="false" :disabled="disabled" :readonly="readonly" @click="onClickInput" > </template> {% endblock %} <template #label> <slot name="label"></slot> </template> </sw-contextual-field> {% endblock %} {% block sw_colorpicker_popover %} <sw-popover v-if="visible" class="sw-colorpicker__colorpicker-position" :z-index="zIndex" > {% block sw_colorpicker_colorpicker %} <div class="sw-colorpicker__colorpicker"> {% block sw_colorpicker_selection %} <div ref="colorPicker" class="sw-colorpicker__colorpicker-selection" :style="{ backgroundColor: selectorBackground }" @mousedown="setDragging" > {% block sw_colorpicker_selector %} <div class="sw-colorpicker__colorpicker-selector" :style="selectorStyles" ></div> {% endblock %} </div> {% endblock %} <div class="sw-colorpicker__row"> <div class="sw-colorpicker__sliders"> {% block sw_colorpicker_hue_slider %} <input v-model.number="hueValue" class="sw-colorpicker__colorpicker-slider-range" type="range" min="0" max="360" step="1" > {% endblock %} {% block sw_colorpicker_alpha_slider %} <input v-if="alpha" v-model.number="alphaValue" class="sw-colorpicker__alpha-slider" type="range" min="0" max="1" step="0.01" :style="{ backgroundImage: sliderBackground }" > {% endblock %} </div> {% block sw_colorpicker_preview %} <div class="sw-colorpicker__colorpicker-wrapper" :class="{ 'is--small': !alpha }" > <div class="sw-colorpicker__colorpicker-previewBackground" :class="{ 'is--invalid': !isColorValid }" ></div> <div class="sw-colorpicker__colorpicker-previewColor" :style="{ background: previewColorValue}" ></div> </div> {% endblock %} </div> {% block sw_colorpicker_inputs %} <div class="sw-colorpicker__row sw-colorpicker__input-row"> {% block sw_colorpicker_inputs_hex %} <div class="sw-colorpicker__row-column"> <input v-model.lazy="hexValue" class="sw-colorpicker__colorpicker-input is--hex" type="text" :spellcheck="false" > <span v-if="colorLabels" class="sw-colorpicker__row-column-label" >HEX</span> </div> {% endblock %} {% block sw_colorpicker_inputs_red %} <div class="sw-colorpicker__row-column"> <input v-model.number="redValue" class="sw-colorpicker__colorpicker-input" type="number" min="0" max="255" step="1" placeholder="0" > <span v-if="colorLabels" class="sw-colorpicker__row-column-label" >R</span> </div> {% endblock %} {% block sw_colorpicker_inputs_green %} <div class="sw-colorpicker__row-column"> <input v-model.number="greenValue" class="sw-colorpicker__colorpicker-input" type="number" min="0" max="255" step="1" placeholder="0" > <span v-if="colorLabels" class="sw-colorpicker__row-column-label" >G</span> </div> {% endblock %} {% block sw_colorpicker_inputs_blue %} <div class="sw-colorpicker__row-column"> <input v-model.number="blueValue" class="sw-colorpicker__colorpicker-input" type="number" min="0" max="255" step="1" placeholder="0" > <span v-if="colorLabels" class="sw-colorpicker__row-column-label" >B</span> </div> {% endblock %} {% block sw_colorpicker_inputs_alpha %} <div v-if="alpha" class="sw-colorpicker__row-column" > <input v-model.number="integerAlpha" class="sw-colorpicker__colorpicker-input" type="number" min="0" max="100" step="1" placeholder="0" > <span v-if="colorLabels" class="sw-colorpicker__row-column-label" >Alpha</span> </div> {% endblock %} </div> {% endblock %} </div> {% endblock %} </sw-popover> {% endblock %} </div> {% endblock %}`,{Mixin:v}=Shopware,b=Shopware.Utils.debounce,g={template:m,inject:["feature"],emits:["update:value","inheritance-restore","inheritance-remove"],mixins:[v.getByName("sw-form-field"),v.getByName("remove-api-error")],props:{value:{type:String,required:!1,default:""},colorOutput:{type:String,required:!1,default:"auto",validValues:["auto","hex","hsl","rgb"]},alpha:{type:Boolean,required:!1,default:!0},disabled:{type:Boolean,required:!1,default:!1},readonly:{type:Boolean,required:!1,default:!1},colorLabels:{type:Boolean,required:!1,default:!0},zIndex:{type:[Number,null],required:!1,default:null}},data(){return{localValue:this.value,visible:!1,isDragging:!1,userInput:null,luminanceValue:50,saturationValue:50,hueValue:0,alphaValue:1}},computed:{colorValue:{get(){return this.localValue},set(t){this.localValue=t,this.debounceEmitColorValue()}},integerAlpha:{get(){return Math.floor(this.alphaValue*100)},set(t){this.alphaValue=t/100}},sliderBackground(){return`linear-gradient(90deg, hsla(${this.hueValue}, ${this.saturationValue}%, ${this.luminanceValue}%, 0), hsl(${this.hueValue}, ${this.saturationValue}%, ${this.luminanceValue}%)), url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 20 20' width='100%25' height='100%25'%3E%3Crect width='10' height='10' x='00' y='00' fill='%23cdd5db' /%3E%3Crect width='10' height='10' x='10' y='10' fill='%23cdd5db' /%3E%3C/svg%3E")`},isColorValid(){return/^rgb/.test(this.colorValue)||/^hsl/.test(this.colorValue)||/^#/.test(this.colorValue)},previewColorValue(){return this.isColorValid?this.colorValue:"transparent"},selectorBackground(){return`hsl(${this.hueValue}, 100%, 50%)`},redValue:{get(){return this.convertHSLtoRGB(this.hueValue,this.saturationValue,this.luminanceValue,this.alphaValue).red},set(t){this.setSingleRGBValue(t,"red")}},greenValue:{get(){return this.convertHSLtoRGB(this.hueValue,this.saturationValue,this.luminanceValue,this.alphaValue).green},set(t){this.setSingleRGBValue(t,"green")}},blueValue:{get(){return this.convertHSLtoRGB(this.hueValue,this.saturationValue,this.luminanceValue,this.alphaValue).blue},set(t){this.setSingleRGBValue(t,"blue")}},rgbValue(){return this.convertHSLtoRGB(Math.abs(this.hueValue),Math.abs(this.saturationValue),Math.abs(this.luminanceValue),Math.abs(this.alphaValue)).string},hslValue(){const t=Math.abs(this.roundingFloat(this.hueValue)),e=Math.abs(this.roundingFloat(this.saturationValue)),s=Math.abs(this.roundingFloat(this.luminanceValue));if(this.alphaValue!==1){const l=Math.abs(this.roundingFloat(this.alphaValue));return`hsla(${t}, ${e}%, ${s}%, ${l})`}return`hsl(${t}, ${e}%, ${s}%)`},hexValue:{get(){return this.alphaValue<1?this.convertHSLtoHEX(this.hueValue,this.saturationValue,this.luminanceValue,this.alphaValue):this.convertHSLtoHEX(this.hueValue,this.saturationValue,this.luminanceValue)},set(t){const e=t;if(!/^#[0-9a-f]{3,8}/i.test(e))return;const l=this.convertHEXtoHSL(t);l!==!1&&this.setHslaValues(l.hue,l.saturation,l.luminance,l.alpha||this.alphaValue)}},convertedValue(){switch(this.colorOutput){case"auto":return this.alphaValue<1?this.rgbValue:this.hexValue;case"rgb":return this.rgbValue;case"hsl":return this.hslValue;case"hex":default:return this.hexValue}},selectorPositionX(){return`calc(${this.saturationValue}% - 9px)`},selectorPositionY(){return`calc(${Math.abs(this.luminanceValue-100)}% - 9px)`},selectorStyles(){return{backgroundColor:this.hslValue,top:this.selectorPositionY,left:this.selectorPositionX}}},watch:{value(){this.colorValue=this.value},hslValue(){this.colorValue=this.convertedValue},visible(t){if(!t)return;const e=this.colorValue;if(/^#/.test(e)){const s=this.convertHEXtoHSL(this.colorValue);this.setHslaValues(s.hue,s.saturation,s.luminance,s.alpha)}else if(/^rgb/.test(e)){const s=this.splitRGBValues(this.colorValue),l=this.convertRGBtoHSL(s.red,s.green,s.blue);this.setHslaValues(l.hue,l.saturation,l.luminance,s.alpha)}else if(/^hsl/.test(e)){const s=this.splitHSLValues(this.colorValue);this.setHslaValues(s.hue,s.saturation,s.luminance,s.alpha)}}},beforeUnmount(){this.componentBeforeDestroy()},methods:{componentBeforeDestroy(){window.removeEventListener("mousedown",this.outsideClick)},debounceEmitColorValue:b(function(){this.$emit("update:value",this.colorValue)},50),outsideClick(t){/^sw-colorpicker__previewColor.active/.test(t.target._prevClass)||t.target.closest(".sw-colorpicker__colorpicker")!==null||(this.visible=!1,this.removeOutsideClickEvent())},setOutsideClickEvent(){window.addEventListener("mousedown",this.outsideClick)},removeOutsideClickEvent(){window.removeEventListener("mousedown",this.outsideClick)},toggleColorPicker(){if(!this.disabled){if(this.visible=!this.visible,this.visible){this.setOutsideClickEvent();return}this.removeOutsideClickEvent()}},moveSelector(t){if(t.preventDefault(),!this.isDragging)return;const e=this.$refs.colorPicker.getBoundingClientRect(),s=t.clientX-e.left,l=t.clientY-e.top,i=s/e.width*100;let r;i>100?r=100:i<0?r=0:r=i;const c=(l/e.height-1)*-100;let u;c>100?u=100:c<0?u=0:u=c,this.saturationValue=this.roundingFloat(r),this.luminanceValue=this.roundingFloat(u)},setDragging(t){document.body.style.userSelect="none",this.isDragging=!0,this.moveSelector(t),window.addEventListener("mousemove",this.moveSelector,!1),window.addEventListener("mouseup",this.removeDragging,!1)},removeDragging(){document.body.style.userSelect=null,this.isDragging=!1,window.removeEventListener("mousemove",this.moveSelector),window.removeEventListener("mouseup",this.removeDragging)},setSingleRGBValue(t,e){if(["red","green","blue"].indexOf(e)===-1)return;let l=null;t>255?l=255:t<0?l=0:l=t;const i=this.convertRGBtoHSL(e==="red"?l:this.redValue,e==="green"?l:this.greenValue,e==="blue"?l:this.blueValue);this.setHslaValues(i.hue,i.saturation,i.luminance,this.alphaValue)},setHslaValues(t,e,s,l){this.hueValue=t,this.luminanceValue=s,this.saturationValue=e,this.alphaValue=l||1},splitRGBValues(t){const e=t.slice(t.indexOf("(")+1,t.length-1).split(", "),s=Number(e[0]),l=Number(e[1]),i=Number(e[2]),r={red:s,green:l,blue:i};return/a/.test(t)&&(r.alpha=Number(e[3])),r},splitHSLValues(t){const e=t.slice(t.indexOf("(")+1,t.length-1).split(", "),s=Number(e[0]),l=Number(e[1].slice(0,e[1].length-1)),i=Number(e[2].slice(0,e[2].length-1)),r=e[3]||e[3]===0?Number(e[3]):void 0,c={hue:s,saturation:l,luminance:i};return r!==void 0&&(c.alpha=r),c},convertHSLtoRGB(t,e,s,l){const i={hue:t,saturation:e,luminance:s,alpha:l};return this.convertHSL("rgb",i)},convertHSLtoHEX(t,e,s,l){const i={hue:t,saturation:e,luminance:s,alpha:l};return this.convertHSL("hex",i)},convertHSL(t,e){if(!["hex","rgb"].includes(t))return{};let{hue:l,saturation:i,luminance:r,alpha:c}=e;i/=100,r/=100;const u=(1-Math.abs(2*r-1))*i,d=u*(1-Math.abs(l/60%2-1)),n=r-u/2;let a=0,o=0,h=0;if(l>=0&&l<60?(a=u,o=d,h=0):l>=60&&l<120?(a=d,o=u,h=0):l>=120&&l<180?(a=0,o=u,h=d):l>=180&&l<240?(a=0,o=d,h=u):l>=240&&l<300?(a=d,o=0,h=u):l>=300&&l<361&&(a=u,o=0,h=d),a=Math.round((a+n)*255),o=Math.round((o+n)*255),h=Math.round((h+n)*255),t==="hex")return a=a.toString(16),o=o.toString(16),h=h.toString(16),a.length===1&&(a=`0${a}`),o.length===1&&(o=`0${o}`),h.length===1&&(h=`0${h}`),c===void 0?`#${a}${o}${h}`:(c=Math.round(c*255).toString(16),c.length===1&&(c=`0${c}`),`#${a}${o}${h}${c}`);const p={string:`rgb(${a}, ${o}, ${h})`,red:a,green:o,blue:h};return c!==1&&(p.string=`rgba(${a}, ${o}, ${h}, ${c})`,p.alpha=c),p},convertRGBtoHSL(t,e,s){let l=t,i=e,r=s;/^-/.test(l)&&(l=Math.abs(l)),/^-/.test(r)&&(r=Math.abs(r)),/^-/.test(i)&&(i=Math.abs(i)),l/=255,i/=255,r/=255;const c=Math.min(l,i,r),u=Math.max(l,i,r),d=u-c;let n=0,a=0,o=0;return d===0?n=0:u===l?n=(i-r)/d%6:u===i?n=(r-l)/d+2:n=(l-i)/d+4,n=this.roundingFloat(n*60),n<0&&(n+=360),o=(u+c)/2,a=d===0?0:d/(1-Math.abs(2*o-1)),a=this.roundingFloat(+(a*100),1),o=this.roundingFloat(+(o*100),1),{string:`hsl(${n},${a}%,${o}%)`,hue:n,saturation:a,luminance:o}},convertHEXtoHSL(t){const e=t;let s=0,l=0,i=0,r;if(e.length!==5&&e.length!==9&&e.length!==4&&e.length!==7)return!1;e.length===5?(s=`0x${e[1]}${e[1]}`,l=`0x${e[2]}${e[2]}`,i=`0x${e[3]}${e[3]}`,r=`0x${e[4]}${e[4]}`):e.length===9?(s=`0x${e[1]}${e[2]}`,l=`0x${e[3]}${e[4]}`,i=`0x${e[5]}${e[6]}`,r=`0x${e[7]}${e[8]}`):e.length===4?(s=`0x${e[1]}${e[1]}`,l=`0x${e[2]}${e[2]}`,i=`0x${e[3]}${e[3]}`):e.length===7&&(s=`0x${e[1]}${e[2]}`,l=`0x${e[3]}${e[4]}`,i=`0x${e[5]}${e[6]}`),s/=255,l/=255,i/=255;const c=Math.min(s,l,i),u=Math.max(s,l,i),d=u-c;let n=0,a=0,o=0;d===0?n=0:u===s?n=(l-i)/d%6:u===l?n=(i-s)/d+2:n=(s-l)/d+4,n=this.roundingFloat(n*60),n<0&&(n+=360),o=(u+c)/2,a=d===0?0:d/(1-Math.abs(2*o-1)),a=this.roundingFloat(+(a*100),1),o=this.roundingFloat(+(o*100),1);const h={string:`hsl(${n}, ${a}%, ${o}%)`,hue:n,saturation:a,luminance:o};return r!==1&&(h.string=`hsla(${n}, ${a}%, ${o}, ${r}%)`,r=this.roundingFloat(r/255),h.alpha=r),h},onClickInput(){this.readonly&&this.toggleColorPicker()},roundingFloat(t,e=2){return Number(Number(t).toFixed(e))}}};export{g as default};
