const i=`{% block sw_settings_search_searchable_content %} <mt-card class="sw-settings-search-searchable-content" position-identifier="sw-settings-search-searchable-content" :title="$tc('sw-settings-search.generalTab.labelSearchableContent')" > {% block sw_settings_search_searchable_content_title %} <span class="sw-field sw-settings-search__searchable-content-title"> {{ $tc('sw-settings-search.generalTab.textDescriptionSearchableContent') }} </span> {% endblock %} {% block sw_settings_search_searchable_actions %} <sw-container class="sw-field" columns="repeat(auto-fit, minmax(100px, 1fr))" align="center" gap="0px 30px" > <div class="sw-settings-search__searchable-content-button-group"> {% block sw_settings_search_searchable_add_item %} <mt-button v-if="defaultTab !== tabNames.generalTab" class="sw-settings-search__searchable-content-add-button" ghost size="small" :disabled="!acl.can('product_search_config.creator')" variant="secondary" @click="onAddNewConfig" > {{ $tc('sw-settings-search.generalTab.buttonAddContent') }} </mt-button> {% endblock %} {% block sw_settings_search_searchable_reset_default %} <mt-button v-if="defaultTab !== tabNames.customTab" class="sw-settings-search__searchable-content-reset-button" size="small" :disabled="isEnabledReset || !acl.can('product_search_config.editor')" variant="secondary" @click="onResetToDefault" > {{ $tc('sw-settings-search.generalTab.buttonResetDefault') }} </mt-button> {% endblock %} </div> {% block sw_settings_search_searchable_show_example %} {% block sw_settings_search_searchable_show_example_link %} <div class="sw-settings-search__searchable-content-link-text"> {% block sw_settings_search_searchable_show_example_link_element %} <a class="sw-settings-search__searchable-content-show-example-link" role="button" tabindex="0" @click="onShowExampleModal" > {{ $tc('sw-settings-search.generalTab.linkExample') }} <mt-icon name="regular-long-arrow-right" size="16px" /> </a> {% endblock %} <router-link :to="{ name: 'sw.settings.search.index.liveSearch' }" class="sw-settings-search__searchable-content-rebuild-link" > {{ $tc('sw-settings-search.liveSearchTab.linkRebuildSearchIndex') }} <mt-icon name="regular-long-arrow-right" size="16px" /> </router-link> </div> {% endblock %} {% block sw_settings_search_searchable_show_example_modal %} <sw-settings-search-example-modal v-if="showExampleModal" @modal-close="onCloseExampleModal" /> {% endblock %} {% endblock %} </sw-container> {% endblock %} {% block sw_settings_search_searchable_content_tabs %} <sw-tabs :default-item="defaultTab" position-identifier="sw-settings-search-searchable-content" > <template #default="{ active }"> {% block sw_settings_search_searchable_content_general_tab_title %} <sw-tabs-item v-bind="$props" class="sw-settings-search__searchable-content-tab-title" :name="tabNames.generalTab" :active-tab="active" @click="onChangeTab(tabNames.generalTab)" > {{ $tc('sw-settings-search.generalTab.labelGeneralTab') }} </sw-tabs-item> {% endblock %} <sw-tabs-item v-bind="$props" class="sw-settings-search__searchable-content-tab-title" :name="tabNames.customTab" :active-tab="active" @click="onChangeTab(tabNames.customTab)" > {{ $tc('sw-settings-search.generalTab.labelCustomFieldsTab') }} </sw-tabs-item> </template> <template #content="{ active }"> {% block sw_settings_search_searchable_content_general_tab_item %} <sw-settings-search-searchable-content-general v-if="active === tabNames.generalTab" :is-empty="isListEmpty" :is-loading="isLoading" :columns="getProductSearchFieldColumns" :repository="productSearchFieldRepository" :search-configs="searchConfigFields" :field-configs="fieldConfigs" @data-load="loadData" @config-save="saveConfig" /> {% endblock %} <sw-settings-search-searchable-content-customfields v-if="active === tabNames.customTab" :is-empty="isListEmpty" :is-loading="isLoading" :columns="getProductSearchFieldColumns" :repository="productSearchFieldRepository" :search-configs="searchConfigFields" @data-load="loadData" @config-add="onAddNewConfig" @config-save="saveConfig" @config-delete="deleteConfig" /> </template> </sw-tabs> {% endblock %} </mt-card> {% endblock %}`,{Context:n,Mixin:l}=Shopware,{Criteria:t}=Shopware.Data,r={template:i,inject:["repositoryFactory","acl"],emits:["edit-change"],mixins:[l.getByName("notification")],props:{searchConfigId:{type:String,required:!0},productSearchConfigs:{type:Object,required:!1,default(){return null}}},data(){return{showExampleModal:!1,defaultTab:"general",tabNames:{generalTab:"general",customTab:"customfields"},isLoading:!1,isEnabledReset:!0,searchConfigFields:[],fieldConfigs:[{label:this.$tc("sw-settings-search.generalTab.configFields.name"),value:"name",defaultConfigs:{searchable:!0,ranking:700,tokenize:!0}},{label:this.$tc("sw-settings-search.generalTab.configFields.description"),value:"description",defaultConfigs:{searchable:!1,ranking:0,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.productNumber"),value:"productNumber",defaultConfigs:{searchable:!0,ranking:1e3,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.manufacturerNumber"),value:"manufacturerNumber",defaultConfigs:{searchable:!0,ranking:500,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.ean"),value:"ean",defaultConfigs:{searchable:!0,ranking:500,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.customSearchKeywords"),value:"customSearchKeywords",defaultConfigs:{searchable:!0,ranking:800,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.manufacturerName"),value:"manufacturer.name",defaultConfigs:{searchable:!0,ranking:500,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.manufacturerCustomFields"),value:"manufacturer.customFields",defaultConfigs:{searchable:!1,ranking:0,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.categoriesName"),value:"categories.name",defaultConfigs:{searchable:!1,ranking:0,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.categoriesCustomFields"),value:"categories.customFields",defaultConfigs:{searchable:!1,ranking:0,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.tagsName"),value:"tags.name",defaultConfigs:{searchable:!1,ranking:0,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.metaTitle"),value:"metaTitle",defaultConfigs:{searchable:!1,ranking:0,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.metaDescription"),value:"metaDescription",defaultConfigs:{searchable:!1,ranking:0,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.propertiesValue"),value:"properties.name",defaultConfigs:{searchable:!1,ranking:0,tokenize:!1}},{label:this.$tc("sw-settings-search.generalTab.configFields.variantValue"),value:"options.name",defaultConfigs:{searchable:!1,ranking:0,tokenize:!1}}]}},computed:{productSearchFieldRepository(){return this.repositoryFactory.create("product_search_config_field")},productSearchFieldCriteria(){const e=new t(1,25);return e.addFilter(t.equals("searchConfigId",this.searchConfigId||null)),e.addSorting(t.sort("field","ESC")),this.defaultTab===this.tabNames.generalTab?e.addFilter(t.equals("customFieldId",null)):e.addFilter(t.not("AND",[t.equals("customFieldId",null)])),e},isListEmpty(){return!this.searchConfigFields||!this.searchConfigFields.length},getProductSearchFieldColumns(){return[{property:"field",label:"sw-settings-search.generalTab.list.columnContent",inlineEdit:"string",sortable:!0,width:"250px"},{property:"searchable",label:"sw-settings-search.generalTab.list.columnSearchable",align:"center",inlineEdit:"string",sortable:!0},{property:"ranking",inlineEdit:"number",label:"sw-settings-search.generalTab.list.columnRankingPoints",align:"center",sortable:!0},{property:"tokenize",inlineEdit:"string",label:"sw-settings-search.generalTab.list.columnSplitKeywords",align:"center",sortable:!0}]},storefrontEsEnable(){return n.app.storefrontEsEnable??!1}},watch:{searchConfigId(){this.loadData()},productSearchConfigs(){this.loadData()}},methods:{onShowExampleModal(){this.showExampleModal=!0},onCloseExampleModal(){this.showExampleModal=!1},onAddNewConfig(){const e=this.createNewConfigItem();this.searchConfigFields.unshift(e),this.$emit("edit-change",!0)},createNewConfigItem(){const e=this.productSearchFieldRepository.create();return e.searchConfigId=this.searchConfigId,e.searchable=!1,e.ranking=0,e.field="",e.tokenize=!1,e},getConfigFieldDefault(e){const a=this.fieldConfigs.find(s=>s.value===e);return a?{...a.defaultConfigs}:{ranking:0,searchable:!1,tokenize:!1}},onResetToDefault(){const e=this.defaultTab===this.tabNames.generalTab;this.searchConfigFields.forEach(a=>(a.ranking=e?this.getConfigFieldDefault(a.field).ranking:0,a.searchable=e?this.getConfigFieldDefault(a.field).searchable:!1,a.tokenize=e?this.getConfigFieldDefault(a.field).tokenize:!1,a)),this.saveConfig()},onChangeTab(e){this.defaultTab=e,this.loadData()},loadData(){this.getProductSearchFieldsList()},getProductSearchFieldsList(){this.isLoading=!0;const e=this.productSearchFieldCriteria;this.productSearchFieldRepository.search(e).then(a=>{this.total=a.total,this.isEnabledReset=!a.total,this.searchConfigFields=a}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-search.notification.loadError")})}).finally(()=>{this.isLoading=!1})},saveConfig(){this.isLoading=!0,this.productSearchFieldRepository.saveAll(this.searchConfigFields).then(()=>{this.createNotificationSuccess({message:this.$tc("sw-settings-search.notification.saveSuccess")}),this.$emit("edit-change",!1)}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-search.notification.saveError")})}).finally(()=>{this.isLoading=!1,this.loadData()})},deleteConfig(e){e&&(this.isLoading=!0,this.productSearchFieldRepository.delete(e).then(()=>{this.createNotificationSuccess({message:this.$tc("sw-settings-search.notification.saveSuccess")})}).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-search.notification.saveError")})}).finally(()=>{this.isLoading=!1,this.loadData()}))}}};export{r as default};
