<?php declare(strict_types=1);
/*
 * (c) shopware AG <info@shopware.com>
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Swag\PayPal\Pos\DataAbstractionLayer\Entity;

use Shopware\Core\Framework\DataAbstractionLayer\Entity;
use Shopware\Core\Framework\DataAbstractionLayer\EntityIdTrait;
use Shopware\Core\Framework\Log\Package;

#[Package('checkout')]
class PosSalesChannelRunLogEntity extends Entity
{
    use EntityIdTrait;

    protected string $runId;

    protected ?PosSalesChannelRunEntity $posSalesChannelRun = null;

    protected int $level;

    protected string $message;

    protected ?string $productId = null;

    protected ?string $productVersionId = null;

    public function getRunId(): string
    {
        return $this->runId;
    }

    public function setRunId(string $runId): void
    {
        $this->runId = $runId;
    }

    public function getPosSalesChannelRun(): ?PosSalesChannelRunEntity
    {
        return $this->posSalesChannelRun;
    }

    public function setPosSalesChannelRun(?PosSalesChannelRunEntity $posSalesChannelRun): void
    {
        $this->posSalesChannelRun = $posSalesChannelRun;
    }

    public function getLevel(): int
    {
        return $this->level;
    }

    public function setLevel(int $level): void
    {
        $this->level = $level;
    }

    public function getMessage(): string
    {
        return $this->message;
    }

    public function setMessage(string $message): void
    {
        $this->message = $message;
    }

    public function getProductId(): ?string
    {
        return $this->productId;
    }

    public function setProductId(?string $productId): void
    {
        $this->productId = $productId;
    }

    public function getProductVersionId(): ?string
    {
        return $this->productVersionId;
    }

    public function setProductVersionId(?string $productVersionId): void
    {
        $this->productVersionId = $productVersionId;
    }
}
