<?php declare(strict_types=1);
/*
 * (c) shopware AG <info@shopware.com>
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Swag\PayPal\Util;

use Shopware\Core\Framework\Log\Package;

/**
 * @url https://developer.paypal.com/reference/locale-codes/
 */
#[Package('checkout')]
final class SupportedLocales
{
    public const LOCALES = [
        'AL' => [
            0 => 'en_US',
        ],
        'DZ' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'AD' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'AO' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'AI' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'AG' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'AR' => [
            0 => 'es_XC',
            1 => 'en_US',
        ],
        'AM' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'AW' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'AU' => [
            0 => 'en_AU',
        ],
        'AT' => [
            0 => 'de_DE',
            1 => 'en_US',
        ],
        'AZ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'BS' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'BH' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'BB' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'BY' => [
            0 => 'en_US',
        ],
        'BE' => [
            0 => 'en_US',
            1 => 'nl_NL',
            2 => 'fr_FR',
        ],
        'BZ' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'BJ' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'BM' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'BT' => [
            0 => 'en_US',
        ],
        'BO' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'BA' => [
            0 => 'en_US',
        ],
        'BW' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'BR' => [
            0 => 'pt_BR',
            1 => 'en_US',
        ],
        'VG' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'BN' => [
            0 => 'en_US',
        ],
        'BG' => [
            0 => 'en_US',
        ],
        'BF' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'BI' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'KH' => [
            0 => 'en_US',
        ],
        'CM' => [
            0 => 'fr_XC',
            1 => 'en_US',
        ],
        'CA' => [
            0 => 'en_US',
            1 => 'fr_CA',
        ],
        'CV' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'KY' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'TD' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'CL' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'CN' => [
            0 => 'zh_CN',
        ],
        'C2' => [
            0 => 'zh_XC',
            1 => 'en_US',
        ],
        'CO' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'KM' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'CG' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'CD' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'CK' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'CR' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'CI' => [
            0 => 'fr_XC',
            1 => 'en_US',
        ],
        'HR' => [
            0 => 'en_US',
        ],
        'CY' => [
            0 => 'en_US',
        ],
        'CZ' => [
            0 => 'cs_CZ',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'DK' => [
            0 => 'da_DK',
            1 => 'en_US',
        ],
        'DJ' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'DM' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'DO' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'EC' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'EG' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'SV' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'ER' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'EE' => [
            0 => 'en_US',
            1 => 'ru_RU',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'ET' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'FK' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'FO' => [
            0 => 'da_DK',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'FJ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'FI' => [
            0 => 'fi_FI',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'FR' => [
            0 => 'fr_FR',
            1 => 'en_US',
        ],
        'GF' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'PF' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'GA' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'GM' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'GE' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'DE' => [
            0 => 'de_DE',
            1 => 'en_US',
        ],
        'GI' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'GR' => [
            0 => 'el_GR',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'GL' => [
            0 => 'da_DK',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'GD' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'GP' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'GT' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'GN' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'GW' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'GY' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'HN' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'HK' => [
            0 => 'en_GB',
            1 => 'zh_HK',
        ],
        'HU' => [
            0 => 'hu_HU',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'IS' => [
            0 => 'en_US',
        ],
        'IN' => [
            0 => 'en_IN',
        ],
        'ID' => [
            0 => 'id_ID',
            1 => 'en_US',
        ],
        'IE' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'IL' => [
            0 => 'he_IL',
            1 => 'en_US',
        ],
        'IT' => [
            0 => 'it_IT',
            1 => 'en_US',
        ],
        'JM' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'JP' => [
            0 => 'ja_JP',
            1 => 'en_US',
        ],
        'JO' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'KZ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'KE' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'KI' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'KW' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'KG' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'LA' => [
            0 => 'en_US',
        ],
        'LV' => [
            0 => 'en_US',
            1 => 'ru_RU',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'LS' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'LI' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'LT' => [
            0 => 'en_US',
            1 => 'ru_RU',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'LU' => [
            0 => 'en_US',
            1 => 'de_DE',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'MK' => [
            0 => 'en_US',
        ],
        'MG' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'MW' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'MY' => [
            0 => 'en_US',
        ],
        'MV' => [
            0 => 'en_US',
        ],
        'ML' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'MT' => [
            0 => 'en_US',
        ],
        'MH' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'MQ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'MR' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'MU' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'YT' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'MX' => [
            0 => 'es_XC',
            1 => 'en_US',
        ],
        'FM' => [
            0 => 'en_US',
        ],
        'MD' => [
            0 => 'en_US',
        ],
        'MC' => [
            0 => 'fr_XC',
            1 => 'en_US',
        ],
        'MN' => [
            0 => 'en_US',
        ],
        'ME' => [
            0 => 'en_US',
        ],
        'MS' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'MA' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'MZ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'NA' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'NR' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'NP' => [
            0 => 'en_US',
        ],
        'NL' => [
            0 => 'nl_NL',
            1 => 'en_US',
        ],
        'NC' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'NZ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'NI' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'NE' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'NG' => [
            0 => 'en_US',
        ],
        'NU' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'NF' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'NO' => [
            0 => 'no_NO',
            1 => 'en_US',
        ],
        'OM' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'PW' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'PA' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'PG' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'PY' => [
            0 => 'es_XC',
            1 => 'en_US',
        ],
        'PE' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'PH' => [
            0 => 'en_US',
        ],
        'PN' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'PL' => [
            0 => 'pl_PL',
            1 => 'en_US',
        ],
        'PT' => [
            0 => 'pt_PT',
            1 => 'en_US',
        ],
        'QA' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
            4 => 'ar_EG',
        ],
        'RE' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'RO' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'RU' => [
            0 => 'ru_RU',
            1 => 'en_US',
        ],
        'RW' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'WS' => [
            0 => 'en_US',
        ],
        'SM' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'ST' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SA' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'SN' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'RS' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SC' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SL' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SG' => [
            0 => 'en_GB',
        ],
        'SK' => [
            0 => 'sk_SK',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'SI' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SB' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SO' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'ZA' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'KR' => [
            0 => 'ko_KR',
            1 => 'en_US',
        ],
        'ES' => [
            0 => 'es_ES',
            1 => 'en_US',
        ],
        'LK' => [
            0 => 'en_US',
        ],
        'SH' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'KN' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'LC' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'PM' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'VC' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SR' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SJ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SZ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'SE' => [
            0 => 'sv_SE',
            1 => 'en_US',
        ],
        'CH' => [
            0 => 'de_DE',
            1 => 'fr_FR',
            2 => 'en_US',
        ],
        'TW' => [
            0 => 'zh_TW',
            1 => 'en_US',
        ],
        'TJ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'TZ' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'TH' => [
            0 => 'th_TH',
            1 => 'en_GB',
        ],
        'TG' => [
            0 => 'fr_XC',
            1 => 'en_US',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'TO' => [
            0 => 'en_US',
        ],
        'TT' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'TN' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'TM' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'TC' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'TV' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'UG' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'UA' => [
            0 => 'en_US',
            1 => 'ru_RU',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'AE' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
            4 => 'ar_EG',
        ],
        'GB' => [
            0 => 'en_GB',
        ],
        'US' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'UY' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'VU' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'VA' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'VE' => [
            0 => 'es_XC',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'zh_XC',
        ],
        'VN' => [
            0 => 'en_US',
        ],
        'WF' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'YE' => [
            0 => 'ar_EG',
            1 => 'en_US',
            2 => 'fr_XC',
            3 => 'es_XC',
            4 => 'zh_XC',
        ],
        'ZM' => [
            0 => 'en_US',
            1 => 'fr_XC',
            2 => 'es_XC',
            3 => 'zh_XC',
        ],
        'ZW' => [
            0 => 'en_US',
        ],
    ];
}
