const r=`{% block sw_settings_listing_index %} <sw-page class="sw-settings-listing-index"> {% block sw_settings_listing_search_bar %} <template #search-bar> <sw-search-bar /> </template> {% endblock %} <template #language-switch> <sw-language-switch @on-change="onChangeLanguage" /> </template> {% block sw_settings_listing_smart_bar_header %} <template #smart-bar-header> {% block sw_settings_listing_smart_bar_header_title %} <h2> {% block sw_settings_listing_smart_bar_header_title_text %} {{ $tc('sw-settings.index.title') }} <mt-icon name="regular-chevron-right-xs" size="12px" /> {{ $tc('sw-settings-listing.general.textHeadline') }} {% endblock %} {% block sw_settings_listing_smart_bar_header_amount %}{% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_settings_listing_smart_bar_actions %} <template #smart-bar-actions> {% block sw_settings_listing_actions_save %} <sw-button-process class="sw-settings-listing__save-action" :is-loading="isLoading" :process-success="isSaveSuccessful" :disabled="isLoading" variant="primary" @update:process-success="saveFinish" @click="onSave" > {{ $tc('sw-settings-listing.general.buttonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_settings_listing_content %} <template #content> {% block sw_settings_listing_content_card_view %} <sw-card-view> <template v-if="isLoading"> <sw-skeleton /> <sw-skeleton /> </template> {# v-show is used here as underlying components influence the loading state and v-if would destroy this behaviour #} <div v-show="!isLoading"> {% block sw_settings_listing_content_card_view_default_sales_channel %} <mt-card class="sw-settings-listing__sales-channel-card" position-identifier="sw-settings-listing-sales-channel" :title="$tc('sw-settings-listing.index.defaultSalesChannel.title')" > <sw-settings-listing-default-sales-channel ref="defaultSalesChannelCard" :is-loading="isLoading" /> </mt-card> {% endblock %} {% block sw_settings_listing_content_card_view_system_config %} <sw-system-config ref="systemConfig" sales-channel-switchable domain="core.listing" @loading-changed="onLoadingChanged" > <template #afterElements="{ config, index, isNotDefaultSalesChannel, inheritance }"> {% block sw_settings_listing_content_card_view_system_config_default_sorting_select %} <sw-inherit-wrapper v-if="config && index === 0" v-model:value="config['core.listing.defaultSorting']" :label="$tc('sw-settings-listing.general.labelDefaultSorting')" :has-parent="isNotDefaultSalesChannel" :inherited-value="inheritance['core.listing.defaultSorting']" required > <template #content="{ isInherited, currentValue, updateCurrentValue }"> <sw-single-select class="sw-settings-listing-index__default-sorting-select" :placeholder="$tc('sw-settings-listing.general.placeholderDefaultSorting')" :disabled="isInherited" :value="currentValue" :options="productSortingOptions" :error="hasDefaultSortingError ? salesChannelDefaultSortingError : null" label-property="label" value-property="id" @update:value="updateCurrentValue" /> </template> </sw-inherit-wrapper> {% endblock %} {% block sw_settings_listing_content_card_view_system_config_default_search_result_sorting_select %} <sw-inherit-wrapper v-if="config && index === 0" v-model:value="config['core.listing.defaultSearchResultSorting']" :label="$tc('sw-settings-listing.general.labelDefaultSearchResultSorting')" :has-parent="isNotDefaultSalesChannel" :inherited-value="inheritance['core.listing.defaultSearchResultSorting']" required > <template #content="{ isInherited, currentValue, updateCurrentValue }"> <sw-single-select class="sw-settings-listing-index__default-search-result-sorting-select" :placeholder="$tc('sw-settings-listing.general.placeholderDefaultSearchResultSorting')" :disabled="isInherited" :value="currentValue" :options="searchResultSortingOptions" :error="hasDefaultSortingError ? salesChannelDefaultSortingError : null" label-property="label" value-property="id" @update:value="updateCurrentValue" /> </template> </sw-inherit-wrapper> {% endblock %} </template> </sw-system-config> {% endblock %} {% block sw_settings_listing_content_card_view_options_card %} <mt-card class="sw-settings-listing-index__sorting-options-card" position-identifier="sw-settings-listing-sorting-options" :title="$tc('sw-settings-listing.index.productSorting.title')" :is-loading="isProductSortingOptionsCardLoading" > {% block sw_settings_listing_content_card_view_options_card_toolbar %} <template #toolbar> {% block sw_settings_listing_content_card_view_options_card_toolbar_container %} <sw-container columns="1fr auto" gap="0 10px" align="start" > {% block sw_settings_listing_content_card_view_options_card_toolbar_search_field %} <sw-simple-search-field v-model:value="productSortingOptionsSearchTerm" variant="form" size="small" class="sw-settings-listing-index__sorting-options-search-field" @search-term-change="onSearchProductSortingOptions" /> {% endblock %} {% block sw_settings_listing_content_card_view_options_card_toolbar_add_product_option %} <mt-button ghost size="small" variant="secondary" @click="onAddNewProductSortingOption" > {{ $tc('sw-settings-listing.index.productSorting.addButton') }} </mt-button> {% endblock %} </sw-container> {% endblock %} </template> {% endblock %} {% block sw_settings_listing_content_card_view_options_card_grid %} <sw-data-grid v-if="productSortingOptions.length > 0" :compact-mode="false" :columns="productSortingOptionColumns" :data-source="productSortingOptions" allow-inline-edit plain-appearance :show-selection="false" :is-record-editable="item => !item.locked" @inline-edit-save="onSaveProductSortingOptionInlineEdit" > {% block sw_settings_listing_content_card_view_options_card_grid_column_criteria %} <template #column-criteria="{item}"> {% block sw_settings_listing_content_card_view_options_card_grid_column_criteria_text %} <span class="is--truncate" :title="formatProductSortingOptionField(item.fields)" > {{ formatProductSortingOptionField(item.fields) }} </span> {% endblock %} </template> {% endblock %} {% block sw_settings_listing_content_card_view_options_card_grid_column_actions %} <template #actions="{item}"> {% block sw_settings_listing_content_card_view_options_card_grid_column_actions_edit %} <sw-context-menu-item :disabled="item.locked" @click="onEditProductSortingOption(item.id)" > {{ $tc('global.default.edit') }} </sw-context-menu-item> {% endblock %} {% block sw_settings_listing_content_card_view_options_card_grid_column_actions_delete %} <sw-context-menu-item variant="danger" :disabled="item.locked || isItemDefaultSorting(item.id)" @click="toBeDeletedProductSortingOption = item" > {{ $tc('global.default.delete') }} </sw-context-menu-item> {% endblock %} </template> {% endblock %} {% block sw_settings_listing_content_card_view_options_card_grid_pagination %} <template #pagination> <sw-pagination :page="sortingOptionsGridPage" :total="sortingOptionsGridTotal" :limit="sortingOptionsGridLimit" :steps="[10]" @page-change="onPageChange" /> </template> {% endblock %} </sw-data-grid> {% endblock %} {% block sw_settings_listing_content_card_view_options_card_empty_state %} <sw-empty-state v-else class="sw-settings-listing-index__sorting-options-empty-state" :title="$tc('sw-settings-listing.index.productSorting.emptyState.title')" :subline="$tc('sw-settings-listing.index.productSorting.emptyState.subline')" :absolute="false" > {% block sw_settings_listing_content_card_view_options_card_empty_state_icon %} <template #icon> <img :src="assetFilter('administration/administration/static/img/empty-states/settings-empty-state.svg')" :alt="$tc('sw-settings-listing.index.productSorting.emptyState.title')" > </template> {% endblock %} </sw-empty-state> {% endblock %} </mt-card> {% endblock %} </div> </sw-card-view> {% endblock %} {% block sw_settings_listing_content_card_view_options_delete_modal %} <sw-settings-listing-delete-modal v-if="toBeDeletedProductSortingOption" :title="$tc('sw-settings-listing.index.deleteModal.title')" :description="$t('sw-settings-listing.index.deleteModal.description', { 'sortingOptionName': toBeDeletedProductSortingOption.label })" @cancel="toBeDeletedProductSortingOption = null" @delete="onDeleteProductSorting(toBeDeletedProductSortingOption)" /> {% endblock %} </template> {% endblock %} </sw-page> {% endblock %}`,{Criteria:n}=Shopware.Data,{ShopwareError:a}=Shopware.Classes,l={template:r,inject:["repositoryFactory","systemConfigApiService"],mixins:["notification","sw-inline-snippet"],data(){return{isLoading:!1,isSaveSuccessful:!1,productSortingOptions:[],searchResultSortingOptions:[],sortingOptionsGridLimit:10,sortingOptionsGridPage:1,modalVisible:!1,toBeDeletedProductSortingOption:null,productSortingOptionsSearchTerm:null,isProductSortingOptionsCardLoading:!1,isDefaultSalesChannelLoading:!1,customFields:[],hasDefaultSortingError:!1}},computed:{productSortingOptionRepository(){return this.repositoryFactory.create("product_sorting")},customFieldRepository(){return this.repositoryFactory.create("custom_field")},salesChannelRepository(){return this.repositoryFactory.create("sales_channel")},systemConfigRepository(){return this.repositoryFactory.create("system_config")},productSortingsOptionsCriteria(){const t=new n(this.sortingOptionsGridPage,this.sortingOptionsGridLimit);return t.addSorting(n.sort("priority","DESC")),t.addFilter(n.equals("locked",!1)),t},searchResultSortingOptionCriteria(){const t=new n(this.sortingOptionsGridPage,this.sortingOptionsGridLimit);return t.addSorting(n.sort("priority","DESC")),t},productSortingOptionsSearchCriteria(){const t=new n(1,25);return t.addSorting(n.sort("priority","DESC")),t.addFilter(n.equals("locked",!1)),t.addFilter(n.contains("label",this.productSortingOptionsSearchTerm)),t},sortingOptionsGridTotal(){return this.productSortingOptions.total},customFieldCriteria(){return new n(1,25)},productSortingOptionColumns(){return[{property:"label",routerLink:"sw.settings.listing.edit",label:this.$tc("sw-settings-listing.index.productSorting.grid.header.name")},{property:"criteria",label:this.$tc("sw-settings-listing.index.productSorting.grid.header.criteria"),multiLine:!0},{property:"priority",inlineEdit:"number",label:this.$tc("sw-settings-listing.index.productSorting.grid.header.priority")}]},assetFilter(){return Shopware.Filter.getByName("asset")},salesChannelDefaultSortingError(){const t=this.$refs.systemConfig.isNotDefaultSalesChannel?"PARENT_MUST_NOT_BE_EMPTY":"c1051bb4-d103-4f74-8988-acbcafc7fdc3";return new a({code:t})}},created(){this.createdComponent()},methods:{saveFinish(){this.isSaveSuccessful=!1},createdComponent(){this.fetchProductSortingOptions(),this.fetchSearchResultSortingOptions(),this.fetchCustomFields()},fetchProductSortingOptions(){this.isProductSortingOptionsCardLoading=!0,this.productSortingOptionRepository.search(this.productSortingsOptionsCriteria).then(t=>{this.productSortingOptions=t,this.isProductSortingOptionsCardLoading=!1})},fetchSearchResultSortingOptions(){this.isProductSortingOptionsCardLoading=!0,this.productSortingOptionRepository.search(this.searchResultSortingOptionCriteria).then(t=>{this.searchResultSortingOptions=t,this.isProductSortingOptionsCardLoading=!1})},fetchCustomFields(){this.customFieldRepository.search(this.customFieldCriteria).then(t=>{this.customFields=t})},async onSave(){return this.isSaveSuccessful=!1,this.isLoading=!0,this.hasDefaultSortingError=!1,new Promise((i,e)=>{this.$refs.systemConfig.actualConfigData.null["core.listing.defaultSorting"]||(this.hasDefaultSortingError=!0,e()),i()}).then(async()=>{const i=this.$refs.systemConfig.saveAll();this.setDefaultSortingActive();const e=this.saveProductSortingOptions(),s=this.saveSearchResultSortingOptions(),o=this.$refs.defaultSalesChannelCard.saveSalesChannelVisibilityConfig();return Promise.all([i,e,s,o])}).then(()=>{this.isSaveSuccessful=!0,this.createNotificationSuccess({message:this.$tc("sw-settings-listing.general.messageSaveSuccess")})}).catch(i=>{var s,o;const e={message:((o=(s=i==null?void 0:i.response.data)==null?void 0:s.errors[0])==null?void 0:o.detail)||"Unknown error"};this.createNotificationError({message:this.$tc("sw-settings-listing.general.messageSaveError",e)})}).finally(()=>{this.isLoading=!1})},saveProductSortingOptions(){return this.productSortingOptionRepository.saveAll(this.productSortingOptions)},saveSearchResultSortingOptions(){return this.productSortingOptionRepository.saveAll(this.searchResultSortingOptions)},onDeleteProductSorting(t){const i=new n;i.addFilter(n.equals("configurationKey","core.listing.defaultSorting")),i.addFilter(n.equals("configurationValue",t.id)),this.systemConfigRepository.search(i).then(e=>{const s={};e.forEach(o=>{s[o.salesChannelId]={"core.listing.defaultSorting":null}}),this.systemConfigApiService.batchSave(s)}),Object.keys(this.$refs.systemConfig.actualConfigData).forEach(e=>{const s=this.$refs.systemConfig.actualConfigData[e];s&&s["core.listing.defaultSorting"]===t.id&&(s["core.listing.defaultSorting"]=null)}),this.toBeDeletedProductSortingOption=null,this.productSortingOptionRepository.delete(t.id).catch(()=>{this.createNotificationError({message:this.$tc("sw-settings-listing.index.productSorting.messageDeleteError")})}).finally(()=>{this.fetchProductSortingOptions(),this.checkForPagination()})},checkForPagination(){if(this.sortingOptionsGridPage!==1){const t=this.productSortingOptions.total-1;this.sortingOptionsGridPage*this.sortingOptionsGridLimit>=t&&this.onPageChange({page:this.sortingOptionsGridPage-1,limit:this.sortingOptionsGridLimit})}},onPageChange({page:t=1,limit:i=10}){this.sortingOptionsGridPage=t,this.sortingOptionsGridLimit=i,this.fetchProductSortingOptions()},onEditProductSortingOption(t){this.$router.push({name:"sw.settings.listing.edit",params:{id:t}})},formatProductSortingOptionField(t){return Array.isArray(t)?t.map(e=>this.isItemACustomField(e.field)?this.getCustomFieldLabelByCriteriaName(e.field):this.$tc(`sw-settings-listing.general.productSortingCriteriaGrid.options.label.${e.field}`)).join(", "):""},getCustomFieldLabelByCriteriaName(t){const i=this.stripCustomFieldPath(t),e=this.getCustomFieldByName(i),s=this.getInlineSnippet(e.config.label);return s===null?i:s},getCustomFieldByName(t){return this.customFields.find(i=>i.name===t)},onAddNewProductSortingOption(){this.$router.push({name:"sw.settings.listing.create"})},onSearchProductSortingOptions(){if(!this.productSortingOptionsSearchTerm){this.fetchProductSortingOptions();return}this.productSortingOptionRepository.search(this.productSortingOptionsSearchCriteria).then(i=>{this.productSortingOptions=i})},onSaveProductSortingOptionInlineEdit(t){const i=this.productSortingOptions.findIndex(e=>e.id===t.id);this.productSortingOptions[i]=t,this.onSave().then(()=>{this.fetchProductSortingOptions()})},isItemACustomField(t){const i=this.stripCustomFieldPath(t);return this.customFields.some(e=>e.name===i)},getCustomFieldById(t){return this.customFields.find(e=>e.id===t).name},stripCustomFieldPath(t){return t.replace(/customFields\./,"")},isProductSortingEditable(t){return!t.locked},onChangeLanguage(){this.fetchProductSortingOptions()},setDefaultSortingActive(){const t=this.$refs.systemConfig.actualConfigData.null["core.listing.defaultSorting"];t&&Object.entries(this.productSortingOptions).forEach(([,i])=>{i.id===t&&(i.active=!0)})},isItemDefaultSorting(t){return!this.$refs.systemConfig.actualConfigData.null?null:t===this.$refs.systemConfig.actualConfigData.null["core.listing.defaultSorting"]},onLoadingChanged(t){this.isLoading=t}}};export{l as default};
