const e=`{% block sw_category_detail_base %} <div class="sw-category-detail-base"> {% block sw_category_detail_information %} <mt-card position-identifier="sw-category-detail-base" :title="$tc('sw-category.base.general.headlineInformationCard')" :is-loading="isLoading" > <sw-container columns="repeat(auto-fit, minmax(150px, 1fr))" gap="0px 30px" > {% block sw_category_detail_information_name %} <mt-text-field v-model="category.name" required name="categoryName" validation="required" :disabled="!acl.can('category.editor')" :label="$tc('sw-category.base.general.categoryNameLabel')" :placeholder="placeholder(category, 'name')" :error="categoryNameError" /> {% endblock %} {% block sw_category_detail_information_active %} <mt-switch v-model="category.active" :disabled="!acl.can('category.editor')" name="categoryActive" class="sw-category-detail-base__active" :label="$tc('sw-category.base.general.isCategoryActiveLabel')" bordered /> {% endblock %} </sw-container> {% block sw_category_detail_information_tags %} <sw-entity-tag-select v-if="category && !isLoading" v-model:entity-collection="category.tags" class="sw-category-detail-base__tags" :label="$tc('sw-category.base.general.labelCategoryTags')" :placeholder="$tc('sw-category.base.general.labelCategoryTagsPlaceholder')" :disabled="!acl.can('category.editor')" /> {% endblock %} {% block sw_category_detail_information_type %} <div class="sw-category-detail-base__type-container"> {% block sw_category_detail_information_type_select %} <sw-single-select v-model:value="category.type" class="sw-category-detail-base__type-selection" :help-text="categoryTypeHelpText" :label="$tc('sw-category.base.general.types.title')" :disabled="!acl.can('category.editor')" :error="categoryTypeError" :options="categoryTypes" show-clearable-button /> {% endblock %} </div> {% endblock %} </mt-card> {% endblock %} {% block sw_category_detail_entry_point %} <sw-category-entry-point-card v-if="(category.type === 'folder' || category.type === 'page') && !isCategoryColumn" v-bind="{ category, isLoading }" /> {% endblock %} {% block sw_category_detail_link %} <sw-category-link-settings v-if="category.type === 'link'" v-bind="{ category, isLoading }" /> {% endblock %} <template v-if="category.type !== 'link'"> {% block sw_category_detail_menu %} <sw-category-detail-menu v-bind="{ category, isLoading }" /> {% endblock %} </template> {% block sw_category_detail_attribute_sets %} <mt-card v-if="customFieldSetsArray.length > 0" position-identifier="sw-category-detail-attribute-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="isLoading" > <sw-custom-field-set-renderer :entity="category" :sets="customFieldSetsArray" /> </mt-card> {% endblock %} </div> {% endblock %}`,{mapPropertyErrors:t}=Shopware.Component.getComponentHelper(),a={template:e,inject:["repositoryFactory","acl"],mixins:[Shopware.Mixin.getByName("placeholder")],props:{isLoading:{type:Boolean,required:!0}},computed:{customFieldSetsArray(){return Shopware.Store.get("swCategoryDetail").customFieldSets??[]},...t("category",["name","type"]),categoryTypes(){return[{value:"page",label:this.$tc("sw-category.base.general.types.page")},{value:"folder",label:this.$tc("sw-category.base.general.types.folder")},{value:"link",label:this.typeLinkLabel,disabled:this.isSalesChannelEntryPoint}]},typeLinkLabel(){return this.isSalesChannelEntryPoint?this.$tc("sw-category.base.general.types.linkUnavailable"):this.$tc("sw-category.base.general.types.link")},categoryTypeHelpText(){return["page","folder","link"].includes(this.category.type)?this.$tc(`sw-category.base.general.types.helpText.${this.category.type}`):null},isSalesChannelEntryPoint(){return this.category.navigationSalesChannels.length>0||this.category.serviceSalesChannels.length>0||this.category.footerSalesChannels.length>0},category(){return Shopware.Store.get("swCategoryDetail").category},isCategoryColumn(){return Shopware.Store.get("swCategoryDetail").isCategoryColumn}}};export{a as default};
