const n=`{% block sw_settings_list %} {% block sw_settings_language_index %} <sw-page class="sw-settings-language-list"> {% block sw_settings_language_list_search_bar %} <template #search-bar> <sw-search-bar initial-search-type="language" :placeholder="$tc('sw-settings-language.general.placeholderSearchBar')" :initial-search="term" @search="onSearch" /> </template> {% endblock %} {% block sw_settings_language_list_smart_bar_header %} <template #smart-bar-header> {% block sw_settings_language_list_smart_bar_header_title %} <h2> {% block sw_settings_language_list_smart_bar_header_title_text %} {{ $tc('sw-settings.index.title') }} <mt-icon name="regular-chevron-right-xs" size="12px" /> {{ $tc('sw-settings-language.list.textHeadline') }} {% endblock %} {% block sw_settings_language_list_smart_bar_header_amount %} <span v-if="!isLoading" class="sw-page__smart-bar-amount" > ({{ total }}) </span> {% endblock %} </h2> {% endblock %} </template> {% endblock %} {% block sw_settings_language_list_smart_bar_actions %} <template #smart-bar-actions> {% block sw_settings_language_list_smart_bar_actions_add %} <mt-button v-tooltip.bottom="{ message: $tc('sw-privileges.tooltip.warning'), disabled: allowCreate, showOnDisabledElements: true }" class="sw-settings-language-list__button-create" variant="primary" :disabled="!allowCreate || undefined" size="default" @click="$router.push({ name: 'sw.settings.language.create' })" > {{ $tc('sw-settings-language.list.buttonAddLanguage') }} </mt-button> {% endblock %} </template> {% endblock %} {% block sw_settings_language_list_content %} <template #content> <sw-entity-listing key="language-listing" class="sw-settings-language-list-grid" detail-route="sw.settings.language.detail" :is-loading="isLoading" :repository="languageRepository" :columns="getColumns" :items="languages" :sort-by="sortBy" :sort-direction="sortDirection" :disable-data-fetching="true" :allow-view="allowView || undefined" :allow-edit="allowEdit || undefined" :allow-inline-edit="allowInlineEdit || undefined" :allow-delete="allowDelete || undefined" @column-sort="onSortColumn" @page-change="onPageChange" > {% block sw_settings_language_list_content_list_content %} {% block sw_settings_language_list_content_list_columns %} {% block sw_settings_language_list_content_list_column_name %} <template #column-name="{ item, column, compact, isInlineEdit }"> <mt-text-field v-if="isInlineEdit" v-model="item.name" :size="compact ? 'small' : 'default'" /> <router-link v-else :title="$tc('sw-settings-language.list.contextMenuEdit')" :to="{ name: 'sw.settings.language.detail', params: { id: item.id } }" > {{ item.name }} </router-link> </template> {% endblock %} <template #column-active="{ item, isInlineEdit }"> <template v-if="isInlineEdit && !isDefault(item.id)"> <mt-checkbox v-model:checked="item.active" /> </template> <template v-else> <mt-icon v-if="item.active" name="regular-checkmark-xs" size="16px" class="is--active" /> <mt-icon v-else name="regular-times-s" size="16px" class="is--inactive" /> </template> </template> {% block sw_settings_language_list_content_list_column_locale %} <template #column-locale="{ item, column, compact, isInlineEdit }"> {{ item.locale.translated.name }}, {{ item.locale.translated.territory }} </template> {% endblock %} {% block sw_settings_language_list_content_list_column_id %} <template #column-id="{ item, column, compact, isInlineEdit }"> <mt-icon v-if="isDefault(item.id)" name="regular-checkmark-xs" size="16px" class="is--active" /> <div v-else></div> </template> {% endblock %} {% block sw_settings_language_list_content_list_column_parent %} <template #column-parent="{ item, column, compact, isInlineEdit }"> {{ getParentName(item) }} </template> {% endblock %} {% endblock %} {% block sw_settings_language_list_content_list_delete %} {% block sw_settings_language_list_content_list_delete_action %} <template #delete-action="{ item, showDelete }"> <sw-context-menu-item v-tooltip.bottom="tooltipDelete(item.id)" class="sw-settings-language-list__delete-action" variant="danger" :disabled="isDefault(item.id) || !allowDelete || undefined" @click="showDelete(item.id)" > {{ $tc('global.default.delete') }} </sw-context-menu-item> </template> {% endblock %} {% block sw_settings_language_list_content_list_delete_confirm_action %} <template #delete-confirm-text="{ item }"> {{ $tc('sw-settings-language.list.textDeleteConfirm', { name: item.name }, 1 ) }} </template> {% endblock %} {% endblock %} {% endblock %} </sw-entity-listing> </template> {% endblock %} {% block sw_settings_language_list_grid_sidebar %} <template #sidebar> <sw-sidebar :propagate-width="true"> {% block sw_settings_language_list_grid_sidebar_filter %} <sw-sidebar-item icon="regular-filter" :title="$tc('sw-settings-language.list.titleSidebarFilter')" > <sw-collapse expand-on-loading> {% block sw_settings_language_list_grid_sidebar_filter_header %} <template #header="{ expanded }"> <div class="sw-settings-language-list__collapse-header"> {% block sw_settings_language_list_grid_sidebar_filter_header_title %} <h4 class="sw-settings-language-list__collapse-title"> {{ $tc('sw-settings-language.list.titleSidebarQuickFilter') }} </h4> {% endblock %} {% block sw_settings_language_list_grid_sidebar_filter_header_icon %} {% block sw_settings_language_list_grid_sidebar_filter_header_icon_expanded %} <mt-icon v-if="expanded" class="sw-media-collapse__button" name="regular-chevron-down-xxs" size="12px" /> {% endblock %} {% block sw_settings_language_list_grid_sidebar_filter_header_icon_not_expanded %} <mt-icon v-else class="sw-media-collapse__button" name="regular-chevron-right-xxs" size="12px" /> {% endblock %} {% endblock %} </div> </template> {% endblock %} {% block sw_settings_language_list_grid_sidebar_filter_content %} <template #content> {% block sw_settings_language_list_grid_sidebar_filter_content_root_languages %} <mt-switch v-model="filterRootLanguages" class="sw-settings-language-list__filterField" :label="$tc('sw-settings-language.list.textFilterRootLanguages')" /> {% endblock %} {% block sw_settings_language_list_grid_sidebar_filter_content_inherited_languages %} <mt-switch v-model="filterInheritedLanguages" class="sw-settings-language-list__filterField" :label="$tc('sw-settings-language.list.textFilterInheritedLanguages')" /> {% endblock %} </template> {% endblock %} </sw-collapse> </sw-sidebar-item> {% endblock %} </sw-sidebar> </template> {% endblock %} </sw-page> {% endblock %} {% endblock %}`,{Mixin:s}=Shopware,{Criteria:t}=Shopware.Data,o={template:n,inject:["repositoryFactory","acl","feature"],mixins:[s.getByName("listing"),s.getByName("notification")],data(){return{languages:null,parentLanguages:null,total:0,filterRootLanguages:!1,filterInheritedLanguages:!1,isLoading:!0,sortBy:"name",sortDirection:"DESC"}},metaInfo(){return{title:this.$createTitle()}},computed:{listingCriteria(){const e=new t(this.page,this.limit);return e.addAssociation("locale"),e.addAssociation("translationCode"),this.sortBy&&e.addSorting(t.sort(this.sortBy,this.sortDirection)),this.filterRootLanguages&&e.addFilter(t.equals("parentId",null)),this.filterInheritedLanguages&&e.addFilter(t.not("AND",[t.equals("parentId",null)])),e},languageRepository(){return this.repositoryFactory.create("language")},getColumns(){return[{property:"name",label:"sw-settings-language.list.columnName",dataIndex:"name",inlineEdit:!0,allowResize:!0},{property:"id",label:"sw-settings-language.list.columnDefault",align:"center",allowResize:!0},{property:"active",dataIndex:"active",label:"sw-settings-language.list.columnActive",inlineEdit:"boolean",allowResize:!0,align:"center"},{property:"locale",dataIndex:"locale.id",label:"sw-settings-language.list.columnLocaleName",allowResize:!0},{property:"translationCode.code",label:"sw-settings-language.list.columnIsoCode",allowResize:!0},{property:"parent",dataIndex:"parent.id",label:"sw-settings-language.list.columnInherit",allowResize:!0}]},allowCreate(){return this.acl.can("language.creator")},allowView(){return this.acl.can("language.viewer")},allowEdit(){return this.acl.can("language.editor")},allowInlineEdit(){return this.acl.can("language.editor")},allowDelete(){return this.acl.can("language.deleter")}},methods:{getList(){return this.isLoading=!0,this.languageRepository.search(this.listingCriteria).then(e=>{this.total=e.total||this.total;const l=new t(1,this.limit),i={};return e.forEach(a=>{a.parentId&&(i[a.parentId]=!0)}),l.setIds(Object.keys(i)),this.languageRepository.search(l).then(a=>{this.languages=e,this.parentLanguages=a,this.isLoading=!1})})},getParentName(e){return e.parentId===null?"-":this.parentLanguages.get(e.parentId).name},isDefault(e){return Shopware.Context.api.systemLanguageId?Shopware.Context.api.systemLanguageId.includes(e):!1},tooltipDelete(e){return!this.acl.can("language.deleter")&&!this.isDefault(e)?{message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.acl.can("language.deleter"),showOnDisabledElements:!0}:{message:"",disabled:!0}}}};export{o as default};
