<?php

use Symfony\Component\Translation\MessageCatalogue;

$catalogue = new MessageCatalogue('en-GB', array (
  'storefront' => 
  array (
    'global.default.cancel' => 'Cancel',
    'global.default.edit' => 'Edit',
    'global.default.save' => 'Save',
    'global.default.delete' => 'Delete',
    'global.default.close' => 'Close',
    'global.default.remove' => 'Remove',
    'global.default.rename' => 'Rename',
    'global.default.activate' => 'Activate',
    'global.default.deactivate' => 'Deactivate',
    'global.default.confirm' => 'Confirm',
    'global.default.noteRequiredFields' => 'Fields marked with asterisks (*) are required.',
    'general.homeLink' => 'Home',
    'general.menuLink' => 'Menu',
    'general.star' => '*',
    'general.grossTaxInformation' => 'Prices incl. VAT plus shipping costs',
    'general.netTaxInformation' => 'Prices excl. VAT plus shipping costs',
    'general.deliveryShippingFree' => 'Free shipping',
    'general.deliveryNotAvailable' => 'These options are currently not available.',
    'general.deliveryShipping' => 'This product will be released on',
    'general.deliveryPartialStock' => 'Only %inStock% of %quantity% in stock',
    'general.deliveryPartialStockAddon' => '- Estimated delivery time (product out of stock): %shippingTime% workdays',
    'general.deliveryInStock' => 'Ready to ship, estimated delivery time: 1-3 workdays',
    'general.deliveryShippingTime' => 'Estimated delivery time: %shippingTime% workdays',
    'general.deliveryShippingDelay' => 'Estimated delivery time: 5 workdays',
    'general.offcanvasCloseMenu' => 'Close menu',
    'general.noscriptNotice' => 'To be able to use the full range of Shopware 6, we recommend activating Javascript in your browser.',
    'general.toCategory' => 'Show all',
    'general.readMore' => 'Read more',
    'general.mainMenu' => 'Show all categories',
    'general.closeMenu' => 'Close menu',
    'general.back' => 'Back',
    'general.expand' => 'Expand',
    'general.collapse' => 'Collapse',
    'general.categories' => 'Categories',
    'general.showCategory' => 'Show %category%',
    'general.required' => '*',
    'general.requiredFields' => 'Fields marked with asterisks (*) are required.',
    'general.privacyTitle' => 'Privacy',
    'general.privacyNoticeText' => 'By selecting continue you confirm that you have read our <a data-ajax-modal="true" data-url="%privacyUrl%" href="%privacyUrl%" title="Data protection information">data protection information</a> and accepted our <a data-ajax-modal="true" data-url="%tosUrl%" href="%tosUrl%" title="general terms and conditions">general terms and conditions</a>.',
    'general.privacyNoticeTextModal' => 'By selecting continue you confirm that you have read our %privacyModalTagOpen%data protection information%privacyModalTagClose% and accepted our %tosModalTagOpen%general terms and conditions%tosModalTagClose%.',
    'general.privacyNoticeTextPage' => 'By selecting continue you confirm that you have read our <a href="%privacyUrl%">data protection information</a> and accepted our <a href="%tosUrl%">general terms and conditions</a>.',
    'general.privacyLink' => 'Privacy policy',
    'general.imprintLink' => 'Imprint',
    'general.404ErrorPageHeader' => 'Page not found',
    'general.404ErrorDescription' => 'We are sorry, the page you\'re looking for could not be found. It may no longer exist or may have been moved.',
    'general.404ErrorReturn' => 'Back to shop',
    'general.maintenanceModeHeader' => 'Maintenance mode',
    'general.maintenanceModeDescription' => 'We are currently updating this site. Please check back later.',
    'general.stagingModeDescription' => 'The Shop is in staging mode.',
    'general.sortingLabel' => 'Sorting',
    'general.next' => 'Next',
    'general.previous' => 'Previous',
    'general.formSubmit' => 'Submit',
    'general.listPricePreviously' => 'previously %price%',
    'general.skipToContentLink' => 'Skip to main content',
    'general.skipToNavigation' => 'Skip to main navigation',
    'general.skipToSearch' => 'Skip to search',
    'general.skipThisElement' => 'Skip this element',
    'general.scrollUpBtn' => 'Go back to the top of the page',
    'general.pagination.first' => 'First page',
    'general.pagination.prev' => 'Previous page',
    'general.pagination.next' => 'Next page',
    'general.pagination.last' => 'Last page',
    'general.pagination.page' => 'Page',
    'general.pagination.title' => 'Pagination',
    'header.logoLink' => 'Go to homepage',
    'header.searchButton' => 'Search',
    'header.searchPlaceholder' => 'Enter search term...',
    'header.searchAllResults' => 'Show all search results',
    'header.searchResults' => '{1} 1 Result|[0,Inf[ %count% Results',
    'header.searchDropdownTitle' => 'The dropdown search',
    'header.searchCloseButton' => 'Close the dropdown search',
    'header.supportInfo' => '<strong>Questions regarding your order?</strong><br /><strong><a href="tel:+4912345-123456789">12345-123456789</a></strong> <small>Daily from 7:30 am to 10:00 pm</small>',
    'header.indexLinkService' => 'Service/help',
    'header.searchNoResult' => 'No results found.',
    'header.wishlist' => 'Wishlist',
    'header.wishlistAriaLiveTemplate' => 'You have %counter% wishlist items',
    'header.navigationAriaLabel' => 'Main navigation',
    'header.topBarAriaLabel' => 'Shop settings',
    'header.languageTrigger' => 'Change language (%lang% is the current language)',
    'header.languageList' => 'Available languages',
    'header.currencyTrigger' => 'Change currency (%currency% is the current currency)',
    'header.currencyList' => 'Available currencies',
    'error.VIOLATION::IS_BLANK_ERROR' => 'Input should not be empty.',
    'error.VIOLATION::TOO_LOW_ERROR' => 'Input should not be empty.',
    'error.VIOLATION::STRICT_CHECK_FAILED_ERROR' => 'Input is invalid',
    'error.VIOLATION::TOO_LONG_ERROR' => 'Input must be {{ limit }} characters or fewer',
    'error.VIOLATION::CUSTOMER_EMAIL_NOT_UNIQUE' => 'This email address has already been registered.',
    'error.VIOLATION::CUSTOMER_PASSWORD_NOT_CORRECT' => 'Password incorrect.',
    'error.VIOLATION::VAT_ID_FORMAT_NOT_CORRECT' => 'The VAT Reg.No. you have entered does not have the correct format.',
    'error.VIOLATION::ZIP_CODE_INVALID' => 'The postal code you have entered does not have the correct format.',
    'error.VIOLATION::INVALID_FORMAT_ERROR' => 'The input does not have the correct format.',
    'error.VIOLATION::INVALID_EMAIL_FORMAT_ERROR' => 'Invalid email address. Email addresses must use the format "user@example.com".',
    'error.VIOLATION::NOT_EQUAL_ERROR' => 'Confirmation field does not match.',
    'error.VIOLATION::FIRST_NAME_IS_BLANK_ERROR' => 'Please fill in your first name.',
    'error.VIOLATION::LAST_NAME_IS_BLANK_ERROR' => 'Please fill in your last name.',
    'error.VIOLATION::STREET_IS_BLANK_ERROR' => 'Please fill in your street of residence.',
    'error.VIOLATION::CITY_IS_BLANK_ERROR' => 'Please fill in your city of residence.',
    'error.VIOLATION::COUNTRY_IS_BLANK_ERROR' => 'Please fill in your country of residence.',
    'error.VIOLATION::ADDITIONAL_ADDR1_IS_BLANK_ERROR' => 'Please fill in additional address information.',
    'error.VIOLATION::ADDITIONAL_ADDR2_IS_BLANK_ERROR' => 'Please fill in additional address information.',
    'error.VIOLATION::PHONE_NUMBER_IS_BLANK_ERROR' => 'Please fill in your phone number.',
    'error.VIOLATION::PHONE_NUMBER_IS_TOO_LONG' => 'Input too long. Please enter a valid phone number.',
    'error.VIOLATION::FIRST_NAME_IS_TOO_LONG' => 'Input too long. Please enter only your first name or a short form of it.',
    'error.VIOLATION::LAST_NAME_IS_TOO_LONG' => 'Input too long. Please enter a shorter form of your last name.',
    'error.VIOLATION::TITLE_IS_TOO_LONG' => 'Input too long. Please enter only your main title or use abbreviations.',
    'error.VIOLATION::ZIPCODE_IS_TOO_LONG' => 'Input too long. Please enter a valid zip code.',
    'error.VIOLATION::PASSWORD_IS_TOO_LONG' => 'The chosen password is too long.',
    'error.message-default' => 'Unfortunately, something went wrong.',
    'error.message-404' => 'The requested page cannot be found.',
    'error.addToCartError' => 'An error occurred while trying to add items to the shopping cart.',
    'error.FRAMEWORK__INVALID_UUID' => 'The selected payment method does not exist.',
    'error.CHECKOUT__UNKNOWN_PAYMENT_METHOD' => 'The selected payment method does not exist.',
    'error.productNotFound' => 'Product "%number%" not found.',
    'error.VIOLATION::TOO_SHORT_ERROR' => 'Input is too short.',
    'error.product-not-found' => 'The product could not be found.',
    'error.message-403-ajax' => 'Your session has expired. Please reload the page and try again.',
    'error.message-403' => 'Your session has expired. Please return to the last page and try again.',
    'error.product-out-of-stock' => '%name% is not available at the moment.',
    'error.auto-promotion-not-found' => 'Promotion "%name%" is no longer valid!',
    'error.rateLimitExceeded' => 'Too many requests. Please wait %seconds% seconds before trying again.',
    'error.captcha.basic-captcha-invalid' => 'Incorrect input. Please try again.',
    'error.CHECKOUT__ORDER_ORDER_ALREADY_PAID' => 'The order with the order number "%orderNumber%" was already paid and cannot be edited afterwards.',
    'error.CHECKOUT__ORDER_ORDER_CANCELLED' => 'The order with the order number "%orderNumber%" was canceled and cannot be edited afterwards.',
    'error.CHECKOUT__ORDER_ORDER_NOT_FOUND' => 'This order could not be found.',
    'error.CHECKOUT__CART_HASH_MISMATCH' => 'Products or prices in your shopping cart may have changed. Please check your shopping cart before placing your order.',
    'error.CHECKOUT__CART_INVALID_LINE_ITEM_QUANTITY' => 'The quantity (%quantity%) is incorrect.',
    'account.externalPaymentCanceled' => 'We have received your order, but the payment was aborted. Please change your payment method or try again.',
    'account.externalPaymentExpired' => 'We have received your order, but the payment process has expired. Please try again.',
    'account.externalPaymentFailure' => 'We have received your order, but we were not able to process your payment, please change the payment method or try again.',
    'account.confirmationIsAlreadyDone' => 'Either the email address has already been confirmed or the URL is invalid.',
    'account.doubleOptInMailConfirmationSuccessfully' => 'Thank you for confirming your email address! You can now complete your order.',
    'account.doubleOptInRegistrationSuccessfully' => 'Thank you for signing up! Your account has been successfully unlocked.',
    'account.myAccount' => 'Your account',
    'account.registerTitle' => 'Sign up',
    'account.registerMetaTitle' => 'Sign up',
    'account.loginHeader' => 'I\'m a customer already!',
    'account.loginFormDescription' => 'Log in with email address and password',
    'account.loginMailLabel' => 'Your email address',
    'account.loginMailPlaceholder' => 'Enter email address...',
    'account.loginPasswordLabel' => 'Your password',
    'account.loginPasswordPlaceholder' => 'Enter password...',
    'account.loginPasswordRecover' => 'I have forgotten my password.',
    'account.loginRegistrationHeader' => 'Log in or create account',
    'account.loginSubmit' => 'Log in',
    'account.loginBadCredentials' => 'Could not find an account that matches the given credentials.',
    'account.loginThrottled' => 'Too many login attempts. Please wait %seconds% seconds before trying to log in again.',
    'account.registerAdvantagesHeader' => 'Login advantages:',
    'account.registerAdvantage1' => 'Express shopping',
    'account.registerAdvantage2' => 'Save your data and settings',
    'account.registerAdvantage3' => 'Order overview and shipping information',
    'account.registerAdvantage4' => 'Manage your newsletter subscription',
    'account.registerPersonalHeader' => 'I\'m a new customer!',
    'account.registerPersonalLegend' => 'Personal information',
    'account.registerAddressBillingHeader' => 'Your address',
    'account.registerAddressShippingHeader' => 'Alternative shipping address',
    'account.personalTypeLabel' => 'Account type',
    'account.personalTypePlaceholder' => 'Select...',
    'account.personalTypePrivate' => 'Private',
    'account.personalTypeBusiness' => 'Commercial',
    'account.personalSalutationLabel' => 'Salutation',
    'account.personalSalutationPlaceholder' => 'Select salutation...',
    'account.personalTitleLabel' => 'Title',
    'account.personalTitlePlaceholder' => 'Enter title...',
    'account.personalFirstNameLabel' => 'First name',
    'account.personalFirstNamePlaceholder' => 'Enter first name...',
    'account.personalLastNameLabel' => 'Last name',
    'account.personalLastNamePlaceholder' => 'Enter last name...',
    'account.personalMailLabel' => 'Email address',
    'account.personalMailPlaceholder' => 'Enter email address...',
    'account.personalMailConfirmationLabel' => 'Email address confirmation',
    'account.personalMailConfirmationPlaceholder' => 'Enter your email address once again...',
    'account.personalMailConfirmationInvalidMessage' => 'Email addresses do not match.',
    'account.personalPasswordLabel' => 'Password',
    'account.personalPasswordPlaceholder' => 'Enter password...',
    'account.personalPasswordConfirmationLabel' => 'Password confirmation',
    'account.personalPasswordConfirmationPlaceholder' => 'Enter your new password once again...',
    'account.personalPasswordConfirmationInvalidMessage' => 'The passwords you have entered do not match.',
    'account.personalPasswordDescription' => 'Passwords must have a minimum length of %minLength% characters.',
    'account.personalBirthdayLabel' => 'Date of birth',
    'account.personalBirthdaySelectDay' => 'Day',
    'account.personalBirthdaySelectMonth' => 'Month',
    'account.personalBirthdaySelectYear' => 'Year',
    'account.personalPhoneLabel' => 'Phone',
    'account.personalPhonePlaceholder' => 'Enter phone number...',
    'account.registerDifferentShipping' => 'Shipping and billing address do not match.',
    'account.registerSubmit' => 'Continue',
    'account.greetings' => 'Hello, ',
    'account.overviewLink' => 'Overview',
    'account.profileLink' => 'Your profile',
    'account.addressLink' => 'Addresses',
    'account.paymentSuccess' => 'Payment method has been changed.',
    'account.paymentLink' => 'Payment methods',
    'account.ordersLink' => 'Orders',
    'account.profileTitle' => 'Your profile',
    'account.profileMetaTitle' => 'Your profile',
    'account.profileText' => 'Check your personal data.',
    'account.addressTitle' => 'Addresses',
    'account.addressMetaTitle' => 'Addresses',
    'account.paymentTitle' => 'Payment methods',
    'account.paymentMetaTitle' => 'Payment methods',
    'account.paymentText' => 'View all available payment methods and select a default payment method.',
    'account.ordersTitle' => 'Orders',
    'account.ordersMetaTitle' => 'Orders',
    'account.logout' => 'Log out',
    'account.guestAbort' => 'Close guest session',
    'account.logoutSucceeded' => 'Successfully logged out.',
    'account.overviewInfo' => 'Directly access your profile information, the default payment method and given addresses.',
    'account.overviewProfileHeader' => 'Personal data',
    'account.overviewTitle' => 'Overview',
    'account.overviewMetaTitle' => 'Overview',
    'account.overviewPaymentHeader' => 'Default payment method',
    'account.overviewBillingHeader' => 'Default billing address',
    'account.overviewShippingHeader' => 'Default shipping address',
    'account.overviewAddressEqual' => 'Equal to billing address',
    'account.overviewChangePayment' => 'Change payment method',
    'account.overviewChangeProfile' => 'Edit profile',
    'account.overviewChangeBilling' => 'Change billing address',
    'account.overviewChangeShipping' => 'Change shipping address',
    'account.overviewNewestOrderHeader' => 'Last order',
    'account.overviewCustomerGroupRequest' => 'Access to customer group "%group%" requested.',
    'account.overviewNotAbleToShip' => 'We can not deliver to the country that is stored in your delivery address.',
    'account.paymentChangeSubmit' => 'Change',
    'account.profilePersonalTitle' => 'Personal data',
    'account.profileMailTitle' => 'Email address',
    'account.profileCurrentMail' => 'Your email address',
    'account.profileCurrentMailPlaceholder' => 'Enter email address...',
    'account.profilePasswordTitle' => 'Password',
    'account.profileUpdateSuccess' => 'Profile has been updated.',
    'account.profileChangeEmail' => 'Change email address',
    'account.profileChangePassword' => 'Change password',
    'account.profileConfirmPassword' => 'Please enter your current password to confirm your changes.',
    'account.profileCredentialsTitle' => 'Login data',
    'account.orRegister' => 'or',
    'account.orRegisterLink' => 'Sign up',
    'account.emailChangeSuccess' => 'Your email address has been updated.',
    'account.emailChangeNoSuccess' => 'Email address could not be changed.',
    'account.passwordChangeSuccess' => 'Your password has been updated.',
    'account.passwordChangeNoSuccess' => 'Password could not be changed.',
    'account.passwordNotIdentical' => 'The passwords you have entered do not match.',
    'account.passwordPoliciesUpdated' => 'The password policies have changed. Please request a new one.',
    'account.passwordHashNotFound' => 'The password reset link seems to be invalid.',
    'account.passwordHashExpired' => 'The password reset link is no longer valid. Please request a new one.',
    'account.recoveryMailSend' => ' If the provided email address is registered, a confirmation email including a password reset link has been sent.',
    'account.profilePasswordCreateNew' => 'New password',
    'account.profilePasswordCreateNewPlaceholder' => 'Enter new password...',
    'account.profilePasswordCurrent' => 'Current password',
    'account.profilePasswordCurrentPlaceholder' => 'Enter current password...',
    'account.profileRecoverPasswordTitle' => 'Password recovery',
    'account.profileRecoverPasswordInfo' => 'We will send you a confirmation email. Click the link in that email in order to change your password.',
    'account.profileRecoverPasswordSubmit' => 'Request email',
    'account.profileSaveChanges' => 'Save changes',
    'account.profileDeleteText' => '<a href="%target%" data-bs-toggle="modal" data-bs-target="%target%">Click here</a> to delete all your personal data.',
    'account.profileDeleteAlert' => 'After deleting your customer account personal data, newsletter entries and reviews won\'t be accessible to you anymore. Note that records of all orders will be kept nonetheless in order to fulfill legal regulations.',
    'account.profileDeleteConfirm' => 'Do you really want to delete your customer account?',
    'account.profileDeleteModalTitle' => 'Customer account',
    'account.profileDeleteButton' => 'Delete account',
    'account.profileDeleteSuccessAlert' => 'Your customer account was deleted.',
    'account.addressWelcome' => 'Addresses',
    'account.addressText' => 'View your current default addresses or add new ones.',
    'account.addressListHeader' => 'Available addresses',
    'account.addressesTitleDefaultShippingAddress' => 'Default shipping address',
    'account.addressesTitleDefaultBillingAddress' => 'Default billing address',
    'account.addressTitleChangeShippingAddress' => 'Change shipping address',
    'account.addressTitleChangeBillingAddress' => 'Change billing address',
    'account.addressesSetAsDefaultShippingAction' => 'Use as default shipping address',
    'account.addressesSetAsDefaultBillingAction' => 'Use as default billing address',
    'account.addressesTitleCurrentShippingAddress' => 'Current shipping address',
    'account.addressesTitleCurrentBillingAddress' => 'Current billing address',
    'account.addressesTitleShippingAddress' => 'Shipping address',
    'account.addressesTitleBillingAddress' => 'Billing address',
    'account.addressesChangeAddress' => 'Change Address',
    'account.addressesContentItemActionEdit' => 'Edit address',
    'account.addressesContentItemActionDelete' => 'Delete address',
    'account.addressNotFound' => 'No address was found',
    'account.noAvailableAddresses' => 'No available addresses',
    'account.availableAddresses' => 'Available addresses',
    'account.selectAddress' => 'Select address',
    'account.addressOptionsBtn' => 'Address options',
    'account.addressCreateBtn' => 'Add new address',
    'account.addressEditBtn' => 'Edit address',
    'account.addressCreateWelcome' => 'New address',
    'account.addressCreateMetaTitle' => 'New address',
    'account.addressEditWelcome' => 'Edit address',
    'account.addressEditMetaTitle' => 'Edit address',
    'account.addressSaveChange' => 'Save address',
    'account.addressDeleted' => 'Address has been deleted.',
    'account.addressNotDeleted' => 'Address could not be deleted.',
    'account.addressDefaultChanged' => 'Default address has been changed.',
    'account.addressDefaultNotChanged' => 'Default address could not be changed.',
    'account.addressSaved' => 'Address has been saved.',
    'account.inactiveAccountAlert' => 'Your customer account has not been activated yet. We have sent a confirmation email containing an activation link. Please check your inbox and click the link to complete the sign-up!',
    'account.doubleOptinAccountAlert' => 'Your customer account has not been activated yet. We have sent a confirmation email containing an activation link. Please check your inbox and click the link to complete the sign-up!',
    'account.optInGuestAlert' => 'Thank you for your interest! You will receive a confirmation email shortly. Click on the link in it to confirm your email address.',
    'account.optInRegistrationAlert' => 'Thank you for signing up! You will receive a confirmation email shortly. Click on the link in it to complete the sign-up.',
    'account.optInSuccessAlert' => 'We just sent you a confirmation email.',
    'account.ordersWelcome' => 'Your recent orders:',
    'account.ordersInfoEmpty' => 'You have not ordered yet.',
    'account.orderHeadline' => 'Order date:',
    'account.orderStatus' => 'Status:',
    'account.orderStatusActionRequired' => 'Action required',
    'account.orderStatusActionCompletePayment' => 'Complete payment',
    'account.orderShippingStatus' => 'Shipping status',
    'account.orderPaymentStatus' => 'Payment status',
    'account.orderPaymentMethod' => 'Payment method',
    'account.orderShippingMethod' => 'Shipping method',
    'account.orderItemColumnDate' => 'Date',
    'account.orderContextMenuChangePayment' => 'Change payment method',
    'account.orderContextMenuReorder' => 'Repeat order',
    'account.orderContextMenuCancel' => 'Cancel order',
    'account.completePayment' => 'Complete payment',
    'account.completePaymentMetaTitle' => 'Complete payment',
    'account.editOrder' => 'Edit order',
    'account.orderActions' => 'Actions',
    'account.editOrderUpdateButton' => 'Complete payment',
    'account.editOrderBackToAccountButton' => 'Back to overview',
    'account.editOrderBackToOrderButton' => 'Back to order',
    'account.editOrderCancelOrderButton' => 'Cancel order',
    'account.editOrderCancelOrderModalHeader' => 'Cancel order',
    'account.editOrderCancelOrderModalBodyText' => 'Beware, if you decide to ultimately cancel your order, the associated payment method and all applied promotions will be lost!',
    'account.editOrderCancelOrderModalBodyQuestion' => 'Are you sure you want to cancel your order after all?',
    'account.editOrderCancelOrderModalFooterButton' => 'Cancel order',
    'account.editOrderCancelOrderModalFooterButtonBack' => 'Back',
    'account.editOrderPaymentNotChangeable' => 'This order is already being processed or has an active discount tied to the payment method, therefore you can not edit it anymore.',
    'account.editOrderPaymentNotChangeableWithRefunds' => 'This order is already being processed or has an active discount tied to the payment method, therefore you can not edit it anymore. Please cancel your order and reorder.',
    'account.orderNumber' => 'Order number:',
    'account.orderItemColumnNumber' => 'Order number:',
    'account.orderItemColumnPaymentMethod' => 'Payment method',
    'account.orderItemColumnShippingMethod' => 'Shipping method',
    'account.orderItemColumnActions' => 'Actions',
    'account.orderItemColumnName' => 'Product',
    'account.orderItemColumnQuantity' => 'Quantity',
    'account.orderItemColumnPrice' => 'Unit price',
    'account.orderItemColumnTotal' => 'Subtotal',
    'account.orderItemDate' => 'Order date:',
    'account.orderItemNumber' => 'Order number:',
    'account.orderItemPaymentMethod' => 'Payment method:',
    'account.orderItemShippingMethod' => 'Shipping method:',
    'account.orderItemTracking' => 'Package tracking:',
    'account.orderItemShippingcosts' => 'Shipping costs:',
    'account.orderItemNetTotal' => 'Total (net):',
    'account.orderItemTotal' => 'Total (gross):',
    'account.orderItemComment' => 'Our comment',
    'account.orderItemCustomerComment' => 'Your comment',
    'account.orderItemInfoContent' => 'Content:',
    'account.orderItemInfoCurrentPrice' => 'Current unit price',
    'account.orderItemInfoNotAvailable' => 'Product no longer available for a follow-up order',
    'account.orderActionView' => 'Show details',
    'account.orderActionHide' => 'Hide details',
    'account.orderInfoNoDispatch' => 'No stated',
    'account.orderLinkRepeat' => 'Repeat order',
    'account.documentItemColumnTitle' => 'Document',
    'account.documentItemColumnDate' => 'Creation date',
    'account.documentItemViewFileButton' => 'View file',
    'account.downloadFileButton' => 'Download',
    'account.downloadItemColumnTitle' => 'File',
    'account.downloadItemColumnDate' => 'Date',
    'account.newsletterTitle' => 'Newsletter subscription',
    'account.newsletterSettings' => 'Yes, I would like to subscribe to the free %shopname% newsletter. (I may unsubscribe at any time.)',
    'account.passwordResetTitle' => 'Did you forget your password?',
    'account.passwordResetInfo' => 'If you have forgotten your password, you may enter a new one here. The moment you hit save, your old password will be invalidated.',
    'account.passwordOptInInfo' => 'Confirmation email sent. Click on the included link to change your password.',
    'account.colonCharacter' => ':',
    'account.orderGuestLoginTitle' => 'Authentication',
    'account.orderGuestLoginDescription' => 'To view your order, please enter your mail address and the postal code given with your billing address.',
    'account.orderGuestLoginWrongCredentials' => 'The given data could not be associated with an order.',
    'account.orderLineItemsListAriaLabel' => 'Order line items',
    'account.orderItemAriaLabel' => 'Order number %order_number%',
    'account.orderDocumentsAriaLabel' => 'Documents of this order',
    'account.orderSummaryAriaLabel' => 'Summary of this order',
    'account.orderInfoAriaLabel' => 'Information about this order',
    'account.orderTrackingNotAvailable' => 'Not available',
    'account.addressDefault' => 'Default',
    'account.addressModalTitle' => 'Addresses',
    'account.addressModalFooterClose' => 'Close',
    'account.addressNewShipping' => 'Add new shipping address',
    'account.addressNewBilling' => 'Add new billing address',
    'account.addressSaveAndUse' => 'Save and use',
    'account.addressSuccessfulChange' => 'Address successful changed',
    'account.addressSearchPlaceholder' => 'Search addresses...',
    'address.streetLabel' => 'Street address',
    'address.streetPlaceholder' => 'Enter street address...',
    'address.additionalField1Label' => 'Additional address line 1',
    'address.additionalField1Placeholder' => 'Enter additional address line...',
    'address.additionalField2Label' => 'Additional address line 2',
    'address.additionalField2Placeholder' => 'Enter additional address line...',
    'address.zipcodeLabel' => 'Postal code',
    'address.zipcodePlaceholder' => 'Enter postal code...',
    'address.cityLabel' => 'City',
    'address.cityPlaceholder' => 'Enter city...',
    'address.countryLabel' => 'Country',
    'address.countryPlaceholder' => 'Select country...',
    'address.countryPostfixNoShipping' => '(Delivery not possible)',
    'address.countryNoShippingAlert' => 'A delivery to this country is not possible.',
    'address.countryStateLabel' => 'State',
    'address.countryStatePlaceholder' => 'Select state...',
    'address.phoneNumberLabel' => 'Phone number',
    'address.phoneNumberPlaceholder' => 'Enter phone number...',
    'address.companyNameLabel' => 'Company',
    'address.companyNamePlaceholder' => 'Enter company...',
    'address.companyDepartmentLabel' => 'Department',
    'address.companyDepartmentPlaceholder' => 'Enter department...',
    'address.companyVatLabel' => 'VAT Registration Number',
    'address.companyVatPlaceholder' => 'VAT Reg.No.',
    'checkout.itemCounter' => '{1} 1 item|[0,Inf[ %count% items',
    'checkout.addressHeader' => 'Shipping information',
    'checkout.addressLoginToggle' => 'You already have an account? Click here to login.',
    'checkout.addressRegisterCardTitle' => 'Your personal details',
    'checkout.registerMetaTitle' => 'Shipping information',
    'checkout.registerGuestmodeLabel' => 'Do not create a customer account.',
    'checkout.registerCustomermodeLabel' => 'Create a customer account.',
    'checkout.cartTitle' => 'Shopping cart',
    'checkout.cartMetaTitle' => 'Shopping cart',
    'checkout.cartHeader' => 'Shopping cart',
    'checkout.cartUpdateSuccess' => 'Shopping cart updated.',
    'checkout.cartScreenReaderUpdate' => '{1}Shopping cart contains one item. The cart total value is %total%.|[0,Inf[Shopping cart contains %count% items. The cart total value is %total%.',
    'checkout.continueShopping' => 'Continue shopping',
    'checkout.emptyCart' => 'Your shopping cart is empty.',
    'checkout.proceedToCart' => 'Display shopping cart',
    'checkout.proceedToCheckout' => 'Go to checkout',
    'checkout.quantityTimes' => 'x',
    'checkout.priceUnitName' => 'Content:',
    'checkout.removeLineItem' => 'Remove %lineItemLabel% from shopping cart',
    'checkout.subtotalAmount' => 'Subtotal',
    'checkout.summaryHeader' => 'Summary',
    'checkout.lineItemContainerHeadline' => 'Product bundle contains',
    'checkout.lineItemContainerChangeLink' => 'change',
    'checkout.lineItemShowMore' => 'more',
    'checkout.lineItemShowLess' => 'less',
    'checkout.lineItemUnitPriceDescriptor' => 'unit',
    'checkout.lineItemLabelDescriptor' => 'Product information',
    'checkout.cartEmpty' => 'Your shopping cart is empty.',
    'checkout.cartHeaderInfo' => 'Product',
    'checkout.cartHeaderQuantity' => 'Quantity',
    'checkout.cartHeaderUnitPrice' => 'Unit price',
    'checkout.cartHeaderTotalPrice' => 'Subtotal',
    'checkout.cartHeaderTaxIncludeVat' => 'incl. VAT',
    'checkout.cartHeaderTaxExcludeVat' => 'excl. VAT',
    'checkout.cartItemInfoId' => 'Product number:',
    'checkout.addPromotionLabel' => 'Promo code',
    'checkout.addPromotionPlaceholder' => 'Enter promo code...',
    'checkout.addProductLabel' => 'Product number',
    'checkout.addProductPlaceholder' => 'Enter product number...',
    'checkout.summaryPositionPrice' => 'Total',
    'checkout.summaryShipping' => 'Shipping costs',
    'checkout.summaryTotalPrice' => 'Grand total',
    'checkout.summaryTotalPriceRounded' => 'Rounded total',
    'checkout.summaryNetPrice' => 'Net total',
    'checkout.summaryTax' => 'plus %rate%% VAT:',
    'checkout.summaryTaxLabeled' => 'plus %rate%% %label%:',
    'checkout.summaryOffCanvasLabel' => 'Shopping cart summary',
    'checkout.proceedLink' => 'Go to checkout',
    'checkout.addressEqualText' => 'Same as shipping address',
    'checkout.billingAddressHeader' => 'Billing address',
    'checkout.shippingAddressHeader' => 'Shipping address',
    'checkout.confirmHeader' => 'Complete order',
    'checkout.confirmMetaTitle' => 'Complete order',
    'checkout.confirmPaymentMethod' => 'Payment method',
    'checkout.confirmPaymentMethodNotAvailable' => 'Payment method not available',
    'checkout.confirmChangePayment' => 'Change payment method',
    'checkout.confirmChoosePayment' => 'Choose payment method',
    'checkout.confirmShippingMethod' => 'Shipping method',
    'checkout.confirmShippingMethodNotAvailable' => 'Shipping method not available',
    'checkout.confirmChangeShipping' => 'Change shipping method',
    'checkout.confirmChooseShipping' => 'Choose shipping method',
    'checkout.confirmCurrentPaymentShipping' => 'Current selection:',
    'checkout.confirmSelectionNone' => 'None selected',
    'checkout.confirmChangePaymentShippingSave' => 'Save',
    'checkout.confirmChangePaymentShippingCancel' => 'Cancel',
    'checkout.confirmSubmit' => 'Submit order',
    'checkout.confirmTermsHeader' => 'Terms and conditions and cancellation policy',
    'checkout.confirmRevocationNotice' => 'Please note our <a data-ajax-modal="true" data-url="%url%" href="%url%" title="Cancellation policy">cancellation policy</a>.',
    'checkout.confirmRevocationNoticeModal' => 'Please note our %revocationModalTagOpen%cancellation policy%revocationModalTagClose%.',
    'checkout.confirmRevocationNoticePage' => 'Please note our <a href="%url%">cancellation policy</a>.',
    'checkout.confirmTermsText' => 'I have read and accepted the <a class="checkout-confirm-terms-modal" data-ajax-modal="true" data-url="%url%" href="%url%">general terms and conditions</a>.',
    'checkout.confirmTermsTextModal' => 'I have read and accepted the %tosModalTagOpen%general terms and conditions%tosModalTagClose%.',
    'checkout.confirmTermsTextPage' => 'I have read and accepted the <a href="%url%">general terms and conditions</a>.',
    'checkout.confirmTermsReminderText' => 'You have already accepted the <a data-ajax-modal="true" data-url="%url%" href="%url%" title="general terms and conditions">general terms and conditions</a>.',
    'checkout.confirmTermsReminderTextModal' => 'You have already accepted the %tosModalTagOpen%general terms and conditions%tosModalTagClose%.',
    'checkout.confirmRevocationTerms' => 'I want immediate access to the digital content and I acknowledge that thereby I waive my right to cancel.',
    'checkout.confirmRevocationReminder' => 'You have already declared that you waive the right of withdrawal.',
    'checkout.finishInfoPayment' => 'Payment method:',
    'checkout.finishInfoShipping' => 'Shipping method:',
    'checkout.finishHeader' => 'Thank you for your order with %shop%!',
    'checkout.finishMetaTitle' => 'Order finished',
    'checkout.finishUpdateHeader' => 'Thank you for updating your order!',
    'checkout.finishPaymentHeader' => 'Your order\'s payment method has been changed to %paymentName%!',
    'checkout.finishInfoHeader' => 'Information',
    'checkout.finishInfoOrdernumber' => 'Your order number: #',
    'checkout.finishInfoConfirmationMail' => 'Order confirmation email has been sent.',
    'checkout.finishButtonBackToShop' => 'Back to shop',
    'checkout.finishChangePayment' => 'Change payment method',
    'checkout.finishPaymentFailed' => 'Unfortunately, the payment process went wrong. Please change your payment method to finish your order. <a href="%editOrderUrl%">Change payment method</a>',
    'checkout.codeAddedSuccessful' => 'Promo code added successfully.',
    'checkout.addToCartSuccess' => '{1} 1 product added to your shopping cart.|[0,Inf[ %count% products added to your shopping cart.',
    'checkout.shippingCosts' => 'Open shipping details',
    'checkout.shippingCountry' => 'Shipping country',
    'checkout.paymentMethod' => 'Payment method',
    'checkout.shippingMethod' => 'Shipping method',
    'checkout.notAvailableSuffix' => '(not available)',
    'checkout.product-stock-reached' => 'The product "%name%" is only available %quantity% times',
    'checkout.product-out-of-stock' => 'The product "%name%" is not available any more',
    'checkout.purchase-steps-quantity' => 'The product "%name%" is not available in this quantity. The quantity was changed to %quantity%',
    'checkout.min-order-quantity' => 'The quantity of product "%name%" did not meet the minimum order quantity threshold. The quantity has automatically been increased to %quantity%.',
    'checkout.shipping-method-blocked' => 'The shipping method "%name%" is blocked for your current shopping cart.',
    'checkout.shipping-method-changed' => '"%oldShippingMethodName%" shipping is not available for your current cart, the shipping was changed to "%newShippingMethodName%".',
    'checkout.payment-method-blocked' => 'The payment method "%name%" is blocked for your current shopping cart.',
    'checkout.payment-method-changed' => '"%oldPaymentMethodName%" payment is not available for your current cart, the payment was changed to "%newPaymentMethodName%".',
    'checkout.lineItemDeliveryDate' => 'Delivery period: %earliest% - %latest%',
    'checkout.promotion-discount-deleted' => 'Discount "%name%" has been removed',
    'checkout.promotion-discount-added' => 'Discount "%name%" has been added',
    'checkout.promotion-not-found' => 'Promo code "%code%" could not be found.',
    'checkout.auto-promotion-not-found' => 'Promotion "%name%" no longer valid!',
    'checkout.promotion-not-eligible' => 'Promotion code valid - however, not all conditions were met and the discount was not applied. Once all conditions are met, the discount will be applied automatically.',
    'checkout.promotion-excluded' => 'One or more discounts have been removed from the shopping cart, due to conflicts with other discounts. Once the conditions are met again, the discounts will be applied automatically.',
    'checkout.promotions-on-cart-price-zero-error' => 'Promotions "%promotions%" were excluded for cart because the price of the cart is zero',
    'checkout.shipping-address-blocked' => 'Shipping to the selected shipping address is currently not possible.',
    'checkout.billing-address-blocked' => 'Billing to the selected address is not possible.',
    'checkout.shipping-address-invalid' => 'The selected shipping address is not valid or incomplete. Please check your entries.',
    'checkout.billing-address-invalid' => 'The selected billing address is not valid or incomplete. Please check your entries.',
    'checkout.customerCommentHeader' => 'Additional information',
    'checkout.customerCommentLabel' => 'Would you like to tell us anything about your order?',
    'checkout.customerCommentPlaceholder' => 'Comment here...',
    'checkout.cart-merged-hint' => 'The current shopping cart might contain additional products that have been added and saved during a previous visit.',
    'checkout.collapseTriggerMore' => 'Show more',
    'checkout.collapseTriggerLess' => 'Show less',
    'checkout.product-not-found' => 'The product could not be found.',
    'checkout.salutation-missing' => 'A salutation is missing from your profile, please choose one during checkout.',
    'checkout.salutation-missing-profile' => 'There\'s no salutation configured in your profile, please set one <a href="%url%">here</a>.',
    'checkout.salutation-missing-billing-address' => 'There\'s no salutation configured for your active billing address, please set one <a href="%url%">here</a>.',
    'checkout.salutation-missing-shipping-address' => 'There\'s no salutation configured for your active shipping address, please set one <a href="%url%">here</a>.',
    'checkout.country-region-missing-billing-address' => 'There\'s no country region configured for your active billing address, please set one <a href="%url%">here</a>.',
    'checkout.country-region-missing-shipping-address' => 'There\'s no country region configured for your active shipping address, please set one <a href="%url%">here</a>.',
    'checkout.checkout-gateway-error' => '%reason%',
    'listing.filterTitleText' => 'Filter products',
    'listing.showResults' => 'Show results',
    'listing.boxUnitLabel' => 'Content:',
    'listing.boxLabelTopseller' => 'Tip',
    'listing.boxLabelNew' => 'New',
    'listing.boxLabelDiscount' => 'Discount',
    'listing.listingTextSite' => 'Page',
    'listing.listingTextFrom' => 'From',
    'listing.boxAddProduct' => 'Add to shopping cart',
    'listing.boxProductDetails' => 'Details',
    'listing.emptyResultMessage' => 'No products found.',
    'listing.filterPanelResetAll' => 'Reset all',
    'listing.filterResetAllAriaLabel' => 'Reset all filters',
    'listing.filterRemoveAriaLabel' => 'Remove filter',
    'listing.filterPanelAriaLive' => 'Showing %count% products.',
    'listing.filterPanelAriaLivePaginated' => 'Showing %count% out of %total% products.',
    'listing.filterFreeShippingDisplayName' => 'Free shipping',
    'listing.filterFreeShippingAltText' => 'Add filter: Free shipping',
    'listing.filterFreeShippingAltTextActive' => 'Remove filter: Free shipping',
    'listing.filterPriceDisplayName' => 'Price',
    'listing.filterManufacturerDisplayName' => 'Manufacturer',
    'listing.filterRatingDisplayName' => 'Rating min.',
    'listing.filterRatingActiveLabelStart' => 'min.',
    'listing.filterRatingActiveLabelEndSingular' => 'star',
    'listing.filterRatingActiveLabelEnd' => 'stars',
    'listing.filterRatingAndMore' => 'min. %points%/%maxPoints%',
    'listing.filterRatingMinAltText' => 'Add filter: Minimum rating of %points% out of %maxPoints% stars',
    'listing.filterRatingAriaLabelCount' => '%stars% stars selected',
    'listing.filterRatingAriaLabelCountSingular' => '1 star selected',
    'listing.filterRangeMinLabel' => 'Minimum',
    'listing.filterRangeMaxLabel' => 'Maximum',
    'listing.filterRangeActiveMinLabel' => '%displayName% from',
    'listing.filterRangeActiveMaxLabel' => '%displayName% to',
    'listing.filterRangeErrorMessage' => 'The minimum value cannot be higher than the maximum value.',
    'listing.filterRangeLowerBoundErrorMessage' => 'The minimum and maximum value must be greater or equal to %lowerBound%.',
    'listing.filterSubmitText' => 'Filter',
    'listing.filterByAriaLabel' => 'Filter by %name%',
    'listing.filterCountAriaLabel' => '%count% selected',
    'listing.filterByManufacturerAriaLabel' => 'Filter by manufacturer',
    'listing.filterByPriceAriaLabel' => 'Filter by price',
    'listing.filterByRatingAriaLabel' => 'Filter by minimum rating',
    'listing.filterClose' => 'Close filters',
    'listing.defaultProductSortingLabel' => 'Name, ascending',
    'listing.disabledFilterTooltip' => 'This filter does not display any further results in combination with the selected filters.',
    'listing.beforeListPrice' => '',
    'listing.afterListPrice' => '',
    'listing.cheapestPriceLabel' => 'Variants from',
    'listing.regularPriceLabel' => 'Regular price:',
    'listing.listPriceLabel' => 'Sale price:',
    'listing.addToWishlist' => 'Add to wishlist',
    'listing.removeFromWishlist' => 'Remove from wishlist',
    'newsletter.headline' => 'Subscribe to newsletter',
    'newsletter.info' => 'Subscribe to our regular newsletter now and stay tuned on the latest products and special offers. You will be able to unsubscribe from it at any time, using this website or the link included in each newsletter.',
    'newsletter.subscribeOption' => 'Subscribe to newsletter',
    'newsletter.unsubscribeOption' => 'Unsubscribe from newsletter',
    'newsletter.formSubmit' => 'Subscribe',
    'newsletter.subscriptionPersistedSuccess' => 'You have just subscribed to our newsletter.
 To complete the sign-up process, search your inbox for our confirmation email and click on the link provided with it.',
    'newsletter.subscriptionPersistedInfo' => 'If you do not receive a confirmation email in the next few minutes, you may already be subscribed to the newsletter. Check your inbox and spam folder. Then try to subscribe again and contact our support if this does not work either.',
    'newsletter.subscriptionRevokeSuccess' => 'You have successfully unsubscribed from the newsletter.',
    'newsletter.subscriptionConfirmationSuccess' => 'You have successfully subscribed to the newsletter.',
    'newsletter.subscriptionConfirmationFailed' => 'Newsletter subscription did not work properly, please contact our support team.',
    'newsletter.subscriptionCompleted' => 'Thank you! We have signed up your address.',
    'newsletter.labelActionSelect' => 'Action',
    'newsletter.labelMail' => 'Email address',
    'newsletter.labelFirstName' => 'First name',
    'newsletter.labelLastName' => 'Last name',
    'newsletter.placeholderMail' => 'Enter email address...',
    'newsletter.placeholderFirstName' => 'John',
    'newsletter.placeholderLastName' => 'Doe',
    'contact.headline' => 'Contact',
    'contact.info' => 'We look forward to hearing from you.',
    'contact.subjectLabel' => 'Subject',
    'contact.subjectPlaceholder' => 'Enter subject...',
    'contact.commentLabel' => 'Comment',
    'contact.commentPlaceholder' => 'Enter comment...',
    'contact.privacyNoticeText' => 'By selecting continue you confirm that you have read and agree to our <a data-ajax-modal="true" data-url="%privacyUrl%" data-prev-url="%prevUrl%" href="%privacyUrl%" title="Data protection information">data protection information</a>.',
    'contact.privacyNoticeTextModal' => 'By selecting continue you confirm that you have read and agree to our %privacyModalTagOpen%data protection information%privacyModalTagClose%.',
    'contact.privacyNoticeTextPage' => 'By selecting continue you confirm that you have read and agree to our <a href="%privacyUrl%" title="Data protection information">data protection information</a>.',
    'contact.formSubmit' => 'Submit',
    'contact.success' => 'We have received your contact request and will process it as soon as possible.',
    'search.headline' => '{0} 0 products found for "%searchTerm%" | {1} One product found for "%searchTerm%" | [0,Inf[ %count% products found for "%searchTerm%"',
    'search.metaTitle' => 'Search results',
    'detail.ordernumberLabel' => 'Product number:',
    'detail.productNumberLabel' => 'Product number:',
    'detail.addProduct' => 'Add to shopping cart',
    'detail.tabsDescription' => 'Description',
    'detail.tabsPreviewMore' => 'More',
    'detail.descriptionTitle' => 'Product information',
    'detail.priceUnitName' => 'Content:',
    'detail.priceDataInfoUntil' => 'To',
    'detail.priceDataInfoFrom' => 'From',
    'detail.listPricePercentage' => '(%price%% saved)',
    'detail.dataColumnQuantity' => 'Quantity',
    'detail.dataColumnPrice' => 'Unit price',
    'detail.dataColumnReferencePrice' => 'Base price',
    'detail.deliveryTimeAvailable' => 'Available, delivery time: %name%',
    'detail.deliveryTimeRestock' => '{1} Available in 1 day, delivery time %name%|[0,Inf[ Available in %restockTime% days, delivery time %name%',
    'detail.soldOut' => 'No longer available',
    'detail.tabsReview' => 'Reviews',
    'detail.reviewTitle' => '%count% of %total% reviews',
    'detail.reviewVerifiedItemTooltip' => 'Verified buyer',
    'detail.reviewCommentLabel' => 'Our feedback: ',
    'detail.reviewLinkText' => '{1} Review|[0,Inf[ Reviews',
    'detail.reviewFormRatingLabel' => 'Your rating',
    'detail.reviewFormTitleLabel' => 'Title',
    'detail.reviewFormTitlePlaceholder' => 'Enter title...',
    'detail.review1PointRatingText' => 'Unsatisfactory',
    'detail.review2PointRatingText' => 'Acceptable',
    'detail.review3PointRatingText' => 'Good',
    'detail.review4PointRatingText' => 'Very good',
    'detail.review5PointRatingText' => 'Excellent',
    'detail.reviewFormContentLabel' => 'Your review',
    'detail.reviewFormContentPlaceholder' => 'Enter your review...',
    'detail.reviewFormSubmitText' => 'Submit',
    'detail.reviewFormCancelText' => 'Cancel',
    'detail.reviewFormErrorAlert' => 'An error occurred. Please make sure you filled in all fields correctly.',
    'detail.reviewFormSuccessAlert' => 'Thank you for submitting your review. We will examine the review and eventually unlock it, please be patient.',
    'detail.reviewFormSuccessUpdateAlert' => 'Thank you for editing your review. Changes will be visible as soon as we have unlocked them.',
    'detail.reviewTeaserTitle' => 'Leave a review!',
    'detail.reviewTeaserText' => 'Share your experiences with other customers.',
    'detail.reviewTeaserButton' => 'Write review',
    'detail.reviewTeaserButtonHide' => 'Show reviews',
    'detail.reviewExistsTeaserTitle' => 'You have already reviewed this product!',
    'detail.reviewExistsTeaserText' => ' Would you like to edit your review?',
    'detail.reviewExistsTeaserButton' => 'Edit review',
    'detail.reviewLanguageFilterLabel' => 'Display reviews in current language only.',
    'detail.reviewSortLabel' => 'Sort by',
    'detail.reviewSortTopRatedLabel' => 'Top rated',
    'detail.reviewSortNewLabel' => 'Most recent',
    'detail.reviewCountAfter' => '{1} review|[0,Inf[ reviews',
    'detail.reviewCountBefore' => 'of',
    'detail.reviewListEmpty' => 'No reviews found. Share your insights with others.',
    'detail.reviewLoginHeader' => 'Login',
    'detail.reviewLoginDescription' => 'Reviews can only be submitted while being logged in. Please enter your login details below.',
    'detail.reviewRegisterLink' => 'New customer?',
    'detail.reviewLoginSignupLink' => 'Click here to sign up.',
    'detail.reviewLoginCancelButton' => 'Cancel',
    'detail.reviewAvgRate' => 'out of',
    'detail.reviewAvgRateElements' => 'stars',
    'detail.reviewAvgRatingAltText' => 'Average rating of %points% out of %maxPoints% stars',
    'detail.reviewRatingAltText' => 'Review with rating of %points% out of %maxPoints% stars',
    'detail.reviewNotPublicYetAlert' => 'Your review has not been approved yet',
    'detail.unavailable' => 'Unavailable',
    'detail.unavailableTooltip' => 'This option is currently unavailable.',
    'detail.reviewTitleMinLengthHint' => 'Please enter at least 5 characters.',
    'detail.reviewTextMinLengthHint' => 'Please enter at least 40 characters.',
    'spatial.ar.scanQrCode' => 'Scan QR-Code',
    'spatial.ar.pointToQrCode' => 'Point the camera of your mobile device at the QR code to display the product in Augmented Reality.',
    'spatial.ar.moveTheDeviceToStart' => 'Move the device to start',
    'spatial.ar.tapToPlaceTheObject' => 'Tap to place the object',
    'spatial.ar.openAugmentedRealityView' => 'Open Augmented Reality view',
    'spatial.ar.augmentedRealityView' => 'Augmented Reality view',
    'spatial.ar.openArView' => 'Open AR view',
    'spatial.ar.launchingArView' => 'Starting AR view...',
    'spatial.ar.openArViewDescription' => 'Open Augmented Reality view',
    'spatial.ar.whyDoISeeThis' => 'Why do I see this message?',
    'spatial.ar.errors.desktopNotSupported.reason' => 'Augmented Reality is not supported on desktop devices.',
    'spatial.ar.errors.desktopNotSupported.solution' => 'Please use a mobile device to start AR.',
    'spatial.ar.errors.notSafariOnIOS.reason' => 'Augmented Reality is only supported in Safari on iOS.',
    'spatial.ar.errors.notSafariOnIOS.solution' => 'Please use Safari on iOS to start AR.',
    'spatial.ar.errors.IOSVersionMismatch.reason' => 'Augmented Reality is not supported on iOS versions below 12.0.',
    'spatial.ar.errors.IOSVersionMismatch.solution' => 'Please use a newer iOS version to start AR.',
    'spatial.ar.errors.unknownIOSError.reason' => 'An unknown error occurred while starting AR on iOS.',
    'spatial.ar.errors.unknownIOSError.solution' => 'Please try again or contact our support.',
    'spatial.ar.errors.unknownARError.reason' => 'An unknown error occurred while starting AR.',
    'spatial.ar.errors.unknownARError.solution' => 'Please try again or contact our support.',
    'wishlist.cartTitle' => 'Your wishlist',
    'wishlist.headline' => 'Your wishlist',
    'wishlist.itemDeleteSuccess' => 'You have successfully removed the product from your wishlist.',
    'wishlist.itemAddedSuccess' => 'You have successfully added the product to your wishlist.',
    'wishlist.duplicateItemError' => 'Product has already been added to your wishlist.',
    'wishlist.currentlyNotAvailable' => 'Currently not available',
    'wishlist.manufacturerDisplayName' => 'Manufacturer',
    'wishlist.deliveryTimeAvailable' => 'Available, delivery time: %name%',
    'wishlist.noLongerAvailableTooltip' => 'The product is no longer available.',
    'wishlist.wishlistMergeHint' => 'Your wishlist might contain products that have been added and saved during a previous visit.',
    'wishlist.wishlistEmptyHeader' => 'Your wishlist is empty',
    'wishlist.wishlistEmptyDescription' => 'Keep an eye on products you like by adding them to your wishlist.',
    'wishlist.deliveryTimeRestock' => '{1} Available in 1 day, delivery time %name%|[0,Inf[ Available in %restockTime% days, delivery time %name%',
    'wishlist.deliveryShipping' => 'This product will be released on',
    'wishlist.remove' => 'Remove %product_name% from wishlist',
    'footer.serviceHotlineHeadline' => 'Service hotline',
    'footer.shopServiceHeadline' => 'Shop service',
    'footer.informationHeadline' => 'Information',
    'footer.newsletterHeadline' => 'Newsletter',
    'footer.serviceHotline' => 'Support and counselling via: <a href="tel:+49180000000">0180 - 000000</a> Mon-Fri, 9 am - 5 pm',
    'footer.serviceContactText' => 'Or via our <a data-ajax-modal="true" data-url="%url%" href="%url%" title="Contact form">contact form</a>.',
    'footer.serviceContactTextPage' => 'Or via our <a href="%url%" title="Contact form">contact form</a>.',
    'footer.newsletterInput' => 'Email address',
    'footer.newsletter' => 'Subscribe to our regular newsletter now to stay tuned on the latest products and special offers.',
    'footer.includeVatText' => '%star%All prices incl. VAT plus <a data-ajax-modal="true" href="%url%" data-url="%url%">shipping costs</a> and possible delivery charges, if not stated otherwise.',
    'footer.includeVatTextPage' => 'All prices incl. VAT plus <a href="%url%">shipping costs</a> and possible delivery charges, if not stated otherwise.',
    'footer.excludeVatText' => '%star%All prices excl. VAT plus <a data-ajax-modal="true" href="%url%" data-url="%url%">shipping costs</a> and possible delivery charges, if not stated otherwise.',
    'footer.excludeVatTextPage' => 'All prices excl. VAT plus <a href="%url%">shipping costs</a> and possible delivery charges, if not stated otherwise.',
    'footer.copyrightInfo' => 'Realised with Shopware',
    'captcha.googleReCaptcha.dataProtectionInformation' => 'This site is protected by reCAPTCHA and the Google <a href="https://policies.google.com/privacy">Privacy Policy</a> and <a href="https://policies.google.com/terms">Terms of Service</a> apply.',
    'captcha.basicCaptchaLabel' => 'To continue, enter the characters shown above*',
    'captcha.basicCaptchaRefreshButton' => 'Refresh captcha challenge',
    'captcha.basicCaptchaChallengeAltText' => 'Captcha challenge',
    'cookie.messageText' => 'This website uses cookies to ensure the best experience possible. <a data-ajax-modal="true" data-url="%url%" href="%url%" title="More information">More information...</a>',
    'cookie.messageTextPage' => 'This website uses cookies to ensure the best experience possible. <a href="%url%" title="More information">More information...</a>',
    'cookie.deny' => 'Only technically required',
    'cookie.configure' => 'Configure',
    'cookie.configuration' => 'Settings',
    'cookie.save' => 'Save',
    'cookie.acceptAll' => 'Accept all cookies',
    'cookie.headline' => 'Cookie preferences',
    'cookie.close' => 'Close cookie preferences',
    'cookie.groupRequired' => 'Technically required',
    'cookie.groupRequiredDescription' => 'Cookies required for this shop to function:',
    'cookie.groupRequiredSession' => 'Session',
    'cookie.groupRequiredTimezone' => 'Timezone',
    'cookie.groupRequiredCaptcha' => 'CAPTCHA integration',
    'cookie.groupStatistical' => 'Statistics',
    'cookie.groupStatisticalDescription' => 'Cookies used for statistics and shop performance metrics.',
    'cookie.groupStatisticalGoogleAnalytics' => 'Google Analytics',
    'cookie.groupComfortFeatures' => 'Comfort features',
    'cookie.groupComfortFeaturesWishlist' => 'Wishlist',
    'cookie.groupComfortFeaturesYoutubeVideo' => 'YouTube video',
    'cookie.groupMarketing' => 'Marketing',
    'cookie.groupMarketingDescription' => 'Allows Google to collect personal data for online advertising and marketing.',
    'cookie.groupMarketingAdConsent' => 'Google Advertising',
    'cookie.wishlist.description' => 'In order to use the wishlist functionality you need to accept the "wishlist cookie" or log in to your account.',
    'cookie.wishlist.title' => 'Missing cookie',
    'cookie.wishlist.accept' => 'Accept cookie',
    'cookie.wishlist.login' => 'Log In',
    'ellipsis.expandLabel' => 'show more',
    'ellipsis.shrinkLabel' => 'show less',
    'component.product.feature.label.manufacturerNumber' => 'Manufacturer number:',
    'component.product.feature.label.ean' => 'GTIN/EAN:',
    'component.product.feature.label.weight' => 'Weight:',
    'component.product.feature.label.width' => 'Width:',
    'component.product.feature.label.height' => 'Height:',
    'component.product.feature.label.length' => 'Length:',
    'component.product.feature.label.releaseDate' => 'Release date:',
    'component.product.feature.label.description' => 'Description:',
    'component.product.feature.label.referencePrice' => 'Content:',
    'component.product.feature.customField.true' => 'Yes',
    'component.product.feature.customField.false' => 'No',
    'component.product.quantitySelect.legend' => 'Product Quantity: Enter the desired amount or use the buttons to increase or decrease the quantity.',
    'component.product.quantitySelect.areaLiveText' => 'Quantity of %product% set to %quantity%.',
    'component.product.quantitySelect.label' => 'Quantity',
    'component.product.quantitySelect.labelWithProduct' => 'Quantity of %product%',
    'component.product.quantitySelect.increase' => 'Increase quantity',
    'component.product.quantitySelect.increaseOfProduct' => 'Increase quantity of %product%',
    'component.product.quantitySelect.decrease' => 'Decrease quantity',
    'component.product.quantitySelect.decreaseOfProduct' => 'Decrease quantity of %product%',
    'component.product.configurator.legend' => '<span class="%hidden_cls%">Select&nbsp;</span>%group_name%',
    'component.cms.vimeo.privacyNoticeText' => 'By viewing the video you agree that your data will be transferred to %platform% and that you have read the <a data-ajax-modal="true" data-url="%url%" href="%url%" title="Privacy policy">Privacy policy</a>.',
    'component.cms.vimeo.acceptButtonLabel' => 'Accept',
    'component.cms.vimeo.watchUrlLabel' => 'Watch on Vimeo',
    'component.cms.imageGallery.ariaLabel' => 'Image gallery containing %total% items',
    'component.cms.imageGallery.touchMove' => 'Touch and drag',
    'component.cms.imageGallery.clickMove' => 'Click and move',
    'component.cms.imageGallery.sliderDotLabel' => 'Show image %index% of %total%',
    'component.cms.imageGallery.skipImageGallery' => 'Skip image gallery',
    'component.cms.imageGallery.zoomIn' => 'Zoom in',
    'component.cms.imageGallery.zoomOut' => 'Zoom out',
    'component.cms.imageGallery.zoomReset' => 'Reset zoom',
    'component.cms.productGallery.ariaLabel' => 'Product gallery containing %total% items',
    'component.cms.productGallery.skipProductGallery' => 'Skip product gallery',
    'component.cms.defaultMedia.preview_camera_large.title' => 'Camera',
    'component.cms.defaultMedia.preview_camera_large.alt' => 'Vintage kodak photo camera with leather sheath and strap',
    'component.cms.defaultMedia.preview_camera_small.title' => 'Camera',
    'component.cms.defaultMedia.preview_camera_small.alt' => 'Vintage kodak photo camera with leather sheath and strap',
    'component.cms.defaultMedia.preview_glasses_large.title' => 'Sunglasses',
    'component.cms.defaultMedia.preview_glasses_large.alt' => 'Gold frame sunglasses on reflective marble surface',
    'component.cms.defaultMedia.preview_glasses_small.title' => 'Sunglasses',
    'component.cms.defaultMedia.preview_glasses_small.alt' => 'Gold frame sunglasses on reflective marble surface',
    'component.cms.defaultMedia.preview_mountain_large.title' => 'Snow-covered mountains',
    'component.cms.defaultMedia.preview_mountain_large.alt' => 'Rocky mountain ridge with snow-covered tops',
    'component.cms.defaultMedia.preview_mountain_small.title' => 'Snow-covered mountains',
    'component.cms.defaultMedia.preview_mountain_small.alt' => 'Rocky mountain ridge with snow-covered tops',
    'component.cms.defaultMedia.preview_plant_large.title' => 'Plant',
    'component.cms.defaultMedia.preview_plant_large.alt' => 'Succulent in a white pot in front of light blue background',
    'component.cms.defaultMedia.preview_plant_small.title' => 'Plant',
    'component.cms.defaultMedia.preview_plant_small.alt' => 'Succulent in a white pot in front of light blue background',
    'theme.compilation.async.success' => 'Compilation for sales channel %salesChannelName% completed',
  ),
));

$catalogueEn = new MessageCatalogue('en', array (
  'validators' => 
  array (
    'This value should be false.' => 'This value should be false.',
    'This value should be true.' => 'This value should be true.',
    'This value should be of type {{ type }}.' => 'This value should be of type {{ type }}.',
    'This value should be blank.' => 'This value should be blank.',
    'The value you selected is not a valid choice.' => 'The value you selected is not a valid choice.',
    'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.' => 'You must select at least {{ limit }} choice.|You must select at least {{ limit }} choices.',
    'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.' => 'You must select at most {{ limit }} choice.|You must select at most {{ limit }} choices.',
    'One or more of the given values is invalid.' => 'One or more of the given values is invalid.',
    'This field was not expected.' => 'This field was not expected.',
    'This field is missing.' => 'This field is missing.',
    'This value is not a valid date.' => 'This value is not a valid date.',
    'This value is not a valid datetime.' => 'This value is not a valid datetime.',
    'This value is not a valid email address.' => 'This value is not a valid email address.',
    'The file could not be found.' => 'The file could not be found.',
    'The file is not readable.' => 'The file is not readable.',
    'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large ({{ size }} {{ suffix }}). Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.' => 'The mime type of the file is invalid ({{ type }}). Allowed mime types are {{ types }}.',
    'This value should be {{ limit }} or less.' => 'This value should be {{ limit }} or less.',
    'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.' => 'This value is too long. It should have {{ limit }} character or less.|This value is too long. It should have {{ limit }} characters or less.',
    'This value should be {{ limit }} or more.' => 'This value should be {{ limit }} or more.',
    'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.' => 'This value is too short. It should have {{ limit }} character or more.|This value is too short. It should have {{ limit }} characters or more.',
    'This value should not be blank.' => 'This value should not be blank.',
    'This value should not be null.' => 'This value should not be null.',
    'This value should be null.' => 'This value should be null.',
    'This value is not valid.' => 'This value is not valid.',
    'This value is not a valid time.' => 'This value is not a valid time.',
    'This value is not a valid URL.' => 'This value is not a valid URL.',
    'The two values should be equal.' => 'The two values should be equal.',
    'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.' => 'The file is too large. Allowed maximum size is {{ limit }} {{ suffix }}.',
    'The file is too large.' => 'The file is too large.',
    'The file could not be uploaded.' => 'The file could not be uploaded.',
    'This value should be a valid number.' => 'This value should be a valid number.',
    'This file is not a valid image.' => 'This file is not a valid image.',
    'This is not a valid IP address.' => 'This value is not a valid IP address.',
    'This value is not a valid language.' => 'This value is not a valid language.',
    'This value is not a valid locale.' => 'This value is not a valid locale.',
    'This value is not a valid country.' => 'This value is not a valid country.',
    'This value is already used.' => 'This value is already used.',
    'The size of the image could not be detected.' => 'The size of the image could not be detected.',
    'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.' => 'The image width is too big ({{ width }}px). Allowed maximum width is {{ max_width }}px.',
    'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.' => 'The image width is too small ({{ width }}px). Minimum width expected is {{ min_width }}px.',
    'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.' => 'The image height is too big ({{ height }}px). Allowed maximum height is {{ max_height }}px.',
    'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.' => 'The image height is too small ({{ height }}px). Minimum height expected is {{ min_height }}px.',
    'This value should be the user\'s current password.' => 'This value should be the user\'s current password.',
    'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.' => 'This value should have exactly {{ limit }} character.|This value should have exactly {{ limit }} characters.',
    'The file was only partially uploaded.' => 'The file was only partially uploaded.',
    'No file was uploaded.' => 'No file was uploaded.',
    'No temporary folder was configured in php.ini.' => 'No temporary folder was configured in php.ini, or the configured folder does not exist.',
    'Cannot write temporary file to disk.' => 'Cannot write temporary file to disk.',
    'A PHP extension caused the upload to fail.' => 'A PHP extension caused the upload to fail.',
    'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.' => 'This collection should contain {{ limit }} element or more.|This collection should contain {{ limit }} elements or more.',
    'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.' => 'This collection should contain {{ limit }} element or less.|This collection should contain {{ limit }} elements or less.',
    'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.' => 'This collection should contain exactly {{ limit }} element.|This collection should contain exactly {{ limit }} elements.',
    'Invalid card number.' => 'Invalid card number.',
    'Unsupported card type or invalid card number.' => 'Unsupported card type or invalid card number.',
    'This is not a valid International Bank Account Number (IBAN).' => 'This value is not a valid International Bank Account Number (IBAN).',
    'This value is not a valid ISBN-10.' => 'This value is not a valid ISBN-10.',
    'This value is not a valid ISBN-13.' => 'This value is not a valid ISBN-13.',
    'This value is neither a valid ISBN-10 nor a valid ISBN-13.' => 'This value is neither a valid ISBN-10 nor a valid ISBN-13.',
    'This value is not a valid ISSN.' => 'This value is not a valid ISSN.',
    'This value is not a valid currency.' => 'This value is not a valid currency.',
    'This value should be equal to {{ compared_value }}.' => 'This value should be equal to {{ compared_value }}.',
    'This value should be greater than {{ compared_value }}.' => 'This value should be greater than {{ compared_value }}.',
    'This value should be greater than or equal to {{ compared_value }}.' => 'This value should be greater than or equal to {{ compared_value }}.',
    'This value should be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should be identical to {{ compared_value_type }} {{ compared_value }}.',
    'This value should be less than {{ compared_value }}.' => 'This value should be less than {{ compared_value }}.',
    'This value should be less than or equal to {{ compared_value }}.' => 'This value should be less than or equal to {{ compared_value }}.',
    'This value should not be equal to {{ compared_value }}.' => 'This value should not be equal to {{ compared_value }}.',
    'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.' => 'This value should not be identical to {{ compared_value_type }} {{ compared_value }}.',
    'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.' => 'The image ratio is too big ({{ ratio }}). Allowed maximum ratio is {{ max_ratio }}.',
    'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.' => 'The image ratio is too small ({{ ratio }}). Minimum ratio expected is {{ min_ratio }}.',
    'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.' => 'The image is square ({{ width }}x{{ height }}px). Square images are not allowed.',
    'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.' => 'The image is landscape oriented ({{ width }}x{{ height }}px). Landscape oriented images are not allowed.',
    'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.' => 'The image is portrait oriented ({{ width }}x{{ height }}px). Portrait oriented images are not allowed.',
    'An empty file is not allowed.' => 'An empty file is not allowed.',
    'The host could not be resolved.' => 'The host could not be resolved.',
    'This value does not match the expected {{ charset }} charset.' => 'This value does not match the expected {{ charset }} charset.',
    'This is not a valid Business Identifier Code (BIC).' => 'This value is not a valid Business Identifier Code (BIC).',
    'Error' => 'Error',
    'This is not a valid UUID.' => 'This value is not a valid UUID.',
    'This value should be a multiple of {{ compared_value }}.' => 'This value should be a multiple of {{ compared_value }}.',
    'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.' => 'This Business Identifier Code (BIC) is not associated with IBAN {{ iban }}.',
    'This value should be valid JSON.' => 'This value should be valid JSON.',
    'This collection should contain only unique elements.' => 'This collection should contain only unique elements.',
    'This value should be positive.' => 'This value should be positive.',
    'This value should be either positive or zero.' => 'This value should be either positive or zero.',
    'This value should be negative.' => 'This value should be negative.',
    'This value should be either negative or zero.' => 'This value should be either negative or zero.',
    'This value is not a valid timezone.' => 'This value is not a valid timezone.',
    'This password has been leaked in a data breach, it must not be used. Please use another password.' => 'This password has been leaked in a data breach, it must not be used. Please use another password.',
    'This value should be between {{ min }} and {{ max }}.' => 'This value should be between {{ min }} and {{ max }}.',
    'This value is not a valid hostname.' => 'This value is not a valid hostname.',
    'The number of elements in this collection should be a multiple of {{ compared_value }}.' => 'The number of elements in this collection should be a multiple of {{ compared_value }}.',
    'This value should satisfy at least one of the following constraints:' => 'This value should satisfy at least one of the following constraints:',
    'Each element of this collection should satisfy its own set of constraints.' => 'Each element of this collection should satisfy its own set of constraints.',
    'This value is not a valid International Securities Identification Number (ISIN).' => 'This value is not a valid International Securities Identification Number (ISIN).',
    'This value should be a valid expression.' => 'This value should be a valid expression.',
    'This value is not a valid CSS color.' => 'This value is not a valid CSS color.',
    'This value is not a valid CIDR notation.' => 'This value is not a valid CIDR notation.',
    'The value of the netmask should be between {{ min }} and {{ max }}.' => 'The value of the netmask should be between {{ min }} and {{ max }}.',
    'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.' => 'The filename is too long. It should have {{ filename_max_length }} character or less.|The filename is too long. It should have {{ filename_max_length }} characters or less.',
    'The password strength is too low. Please use a stronger password.' => 'The password strength is too low. Please use a stronger password.',
    'This value contains characters that are not allowed by the current restriction-level.' => 'This value contains characters that are not allowed by the current restriction-level.',
    'Using invisible characters is not allowed.' => 'Using invisible characters is not allowed.',
    'Mixing numbers from different scripts is not allowed.' => 'Mixing numbers from different scripts is not allowed.',
    'Using hidden overlay characters is not allowed.' => 'Using hidden overlay characters is not allowed.',
    'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.' => 'The extension of the file is invalid ({{ extension }}). Allowed extensions are {{ extensions }}.',
    'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.' => 'The detected character encoding is invalid ({{ detected }}). Allowed encodings are {{ encodings }}.',
    'This value is not a valid MAC address.' => 'This value is not a valid MAC address.',
    'This URL is missing a top-level domain.' => 'This URL is missing a top-level domain.',
    'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.' => 'This value is too short. It should contain at least one word.|This value is too short. It should contain at least {{ min }} words.',
    'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.' => 'This value is too long. It should contain one word.|This value is too long. It should contain {{ max }} words or less.',
    'This value does not represent a valid week in the ISO 8601 format.' => 'This value does not represent a valid week in the ISO 8601 format.',
    'This value is not a valid week.' => 'This value is not a valid week.',
    'This value should not be before week "{{ min }}".' => 'This value should not be before week "{{ min }}".',
    'This value should not be after week "{{ max }}".' => 'This value should not be after week "{{ max }}".',
    'This value is not a valid Twig template.' => 'This value is not a valid Twig template.',
  ),
  'security' => 
  array (
    'An authentication exception occurred.' => 'An authentication exception occurred.',
    'Authentication credentials could not be found.' => 'Authentication credentials could not be found.',
    'Authentication request could not be processed due to a system problem.' => 'Authentication request could not be processed due to a system problem.',
    'Invalid credentials.' => 'Invalid credentials.',
    'Cookie has already been used by someone else.' => 'Cookie has already been used by someone else.',
    'Not privileged to request the resource.' => 'Not privileged to request the resource.',
    'Invalid CSRF token.' => 'Invalid CSRF token.',
    'No authentication provider found to support the authentication token.' => 'No authentication provider found to support the authentication token.',
    'No session available, it either timed out or cookies are not enabled.' => 'No session available, it either timed out or cookies are not enabled.',
    'No token could be found.' => 'No token could be found.',
    'Username could not be found.' => 'Username could not be found.',
    'Account has expired.' => 'Account has expired.',
    'Credentials have expired.' => 'Credentials have expired.',
    'Account is disabled.' => 'Account is disabled.',
    'Account is locked.' => 'Account is locked.',
    'Too many failed login attempts, please try again later.' => 'Too many failed login attempts, please try again later.',
    'Invalid or expired login link.' => 'Invalid or expired login link.',
    'Too many failed login attempts, please try again in %minutes% minute.' => 'Too many failed login attempts, please try again in %minutes% minute.',
    'Too many failed login attempts, please try again in %minutes% minutes.' => 'Too many failed login attempts, please try again in %minutes% minutes.',
  ),
));
$catalogue->addFallbackCatalogue($catalogueEn);
$catalogueEn_GB = new MessageCatalogue('en_GB', array (
));
$catalogueEn->addFallbackCatalogue($catalogueEn_GB);

return $catalogue;
