<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @Storefront/storefront/component/form/form-select.html.twig */
class __TwigTemplate_afd37bce1b4b304b86e499c2811ab195 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'component_form_select' => [$this, 'block_component_form_select'],
            'component_form_select_label' => [$this, 'block_component_form_select_label'],
            'component_form_select_select' => [$this, 'block_component_form_select_select'],
            'component_form_select_select_options' => [$this, 'block_component_form_select_select_options'],
            'component_form_select_description' => [$this, 'block_component_form_select_description'],
            'component_form_select_feedback' => [$this, 'block_component_form_select_feedback'],
            'component_form_input_feedback_violations' => [$this, 'block_component_form_input_feedback_violations'],
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "@Storefront/storefront/component/form/form-select.html.twig"));

        // line 20
        yield from $this->unwrap()->yieldBlock('component_form_select', $context, $blocks);
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_select(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_select"));

        // line 21
        yield "
    ";
        // line 22
        $context["feedbackId"] = (($context["id"] ?? null) . "-feedback");
        // line 23
        yield "    ";
        $context["descriptionId"] = (($context["id"] ?? null) . "-description");
        // line 24
        yield "
    ";
        // line 25
        $context["areaDescribedBy"] = ($context["feedbackId"] ?? null);
        // line 26
        yield "
    ";
        // line 27
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["description"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 28
            yield "        ";
            $context["areaDescribedBy"] = ((($context["descriptionId"] ?? null) . " ") . ($context["feedbackId"] ?? null));
            // line 29
            yield "    ";
        }
        // line 30
        yield "
    <div class=\"form-group";
        // line 31
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["additionalClass"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield " ";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["additionalClass"] ?? null), "html", null, true);
        }
        yield "\">
        ";
        // line 32
        yield from $this->unwrap()->yieldBlock('component_form_select_label', $context, $blocks);
        // line 43
        yield "
        ";
        // line 44
        yield from $this->unwrap()->yieldBlock('component_form_select_select', $context, $blocks);
        // line 69
        yield "
        ";
        // line 70
        yield from $this->unwrap()->yieldBlock('component_form_select_description', $context, $blocks);
        // line 75
        yield "
        ";
        // line 76
        yield from $this->unwrap()->yieldBlock('component_form_select_feedback', $context, $blocks);
        // line 85
        yield "    </div>

";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 32
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_select_label(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_select_label"));

        // line 33
        yield "            ";
        if ((($tmp = ($context["label"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 34
            yield "                <label class=\"form-label\" for=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["id"] ?? null), "html", null, true);
            yield "\">
                    ";
            // line 35
            yield ($context["label"] ?? null);
            yield "

                    ";
            // line 37
            if (CoreExtension::inFilter("required", ($context["validationRules"] ?? null))) {
                // line 38
                yield "                        <span class=\"form-required-label\" aria-hidden=\"true\">";
                yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("general.required"));
                yield "</span>
                    ";
            }
            // line 40
            yield "                </label>
            ";
        }
        // line 42
        yield "        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 44
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_select_select(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_select_select"));

        // line 45
        yield "            ";
        $context["cssClass"] = "form-select";
        // line 46
        yield "
            ";
        // line 47
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["additionalSelectClass"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 48
            yield "                ";
            $context["cssClass"] = ((($context["cssClass"] ?? null) . " ") . ($context["additionalSelectClass"] ?? null));
            // line 49
            yield "            ";
        }
        // line 50
        yield "
            ";
        // line 51
        if (( !Twig\Extension\CoreExtension::testEmpty(($context["violationPath"] ?? null)) &&  !Twig\Extension\CoreExtension::testEmpty(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["formViolations"] ?? null), "getViolations", [($context["violationPath"] ?? null)], "method", false, false, false, 51)))) {
            // line 52
            yield "                ";
            $context["cssClass"] = (($context["cssClass"] ?? null) . " is-invalid");
            // line 53
            yield "            ";
        }
        // line 54
        yield "
            <select class=\"";
        // line 55
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["cssClass"] ?? null), "html", null, true);
        yield "\"
                    id=\"";
        // line 56
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["id"] ?? null), "html", null, true);
        yield "\"
                    name=\"";
        // line 57
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["name"] ?? null), "html", null, true);
        yield "\"
                    aria-describedby=\"";
        // line 58
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["areaDescribedBy"] ?? null), "html", null, true);
        yield "\"
                    ";
        // line 59
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["autocomplete"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "autocomplete=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["autocomplete"] ?? null), "html", null, true);
            yield "\"";
        }
        // line 60
        yield "                    ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["validationRules"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "data-validation=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["validationRules"] ?? null), "html", null, true);
            yield "\"";
        }
        // line 61
        yield "                    ";
        if (CoreExtension::inFilter("required", ($context["validationRules"] ?? null))) {
            yield "aria-required=\"true\"";
        }
        // line 62
        yield "                    ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["attributes"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(($context["attributes"] ?? null));
            foreach ($context['_seq'] as $context["key"] => $context["value"]) {
                if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty($context["value"])) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(((($context["key"] . "=") . $context["value"]) . " "), "html", null, true);
                }
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['key'], $context['value'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
        }
        // line 63
        yield "                    ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["disabled"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "disabled";
        }
        yield ">
                ";
        // line 64
        yield from $this->unwrap()->yieldBlock('component_form_select_select_options', $context, $blocks);
        // line 67
        yield "            </select>
        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 64
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_select_select_options(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_select_select_options"));

        // line 65
        yield "                    ";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["options"] ?? null), "html", null, true);
        yield "
                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 70
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_select_description(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_select_description"));

        // line 71
        yield "            ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["description"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 72
            yield "                <small id=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["descriptionId"] ?? null), "html", null, true);
            yield "\" class=\"form-text\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["description"] ?? null), "html", null, true);
            yield "</small>
            ";
        }
        // line 74
        yield "        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 76
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_select_feedback(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_select_feedback"));

        // line 77
        yield "            <div id=\"";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["feedbackId"] ?? null), "html", null, true);
        yield "\" class=\"form-field-feedback\">
                ";
        // line 78
        yield from $this->unwrap()->yieldBlock('component_form_input_feedback_violations', $context, $blocks);
        // line 83
        yield "            </div>
        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 78
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_input_feedback_violations(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_input_feedback_violations"));

        // line 79
        yield "                    ";
        if (( !Twig\Extension\CoreExtension::testEmpty(($context["violationPath"] ?? null)) &&  !Twig\Extension\CoreExtension::testEmpty(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["formViolations"] ?? null), "getViolations", [($context["violationPath"] ?? null)], "method", false, false, false, 79)))) {
            // line 80
            yield "                        ";
            yield from $this->load("@Storefront/storefront/utilities/form-violation.html.twig", 80)->unwrap()->yield($context);
            // line 81
            yield "                    ";
        }
        // line 82
        yield "                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@Storefront/storefront/component/form/form-select.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  372 => 82,  369 => 81,  366 => 80,  363 => 79,  353 => 78,  344 => 83,  342 => 78,  337 => 77,  327 => 76,  319 => 74,  311 => 72,  308 => 71,  298 => 70,  287 => 65,  277 => 64,  268 => 67,  266 => 64,  259 => 63,  245 => 62,  240 => 61,  233 => 60,  227 => 59,  223 => 58,  219 => 57,  215 => 56,  211 => 55,  208 => 54,  205 => 53,  202 => 52,  200 => 51,  197 => 50,  194 => 49,  191 => 48,  189 => 47,  186 => 46,  183 => 45,  173 => 44,  165 => 42,  161 => 40,  155 => 38,  153 => 37,  148 => 35,  143 => 34,  140 => 33,  130 => 32,  120 => 85,  118 => 76,  115 => 75,  113 => 70,  110 => 69,  108 => 44,  105 => 43,  103 => 32,  96 => 31,  93 => 30,  90 => 29,  87 => 28,  85 => 27,  82 => 26,  80 => 25,  77 => 24,  74 => 23,  72 => 22,  69 => 21,  52 => 20,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
    -- Select Form Field Component --

    This component makes it easier to use select fields in a form.
    It will implement all necessary accessibility best-practices and field validation for you.

    Properties:

    * id (required) - The id attriute of the input field.
    * name (required) - The name attribute of the input field.
    * options (required) - The options of the select field. Use the set method in Twig to create a template string that will rendered.
    * label (optional) - The text content of the field label.
    * disabled (optional) - The disabled attribute of the input field.
    * validationRules (optional) - A comma-separated list of rules the field should be validated against via client validation.
    * violationPath (optional) - The key under which validation errors are stored within the response of a server validation.
    * additionalClass (optional) - Additional css class names that are added to the form-group wrapper element.
    * additionalSelectClass (optional) - Additional css class names that are adedd to the select element.
    * attributes (optional) - Additional attributes that are added to the select element.
#}
{% block component_form_select %}

    {% set feedbackId = \"#{id}-feedback\" %}
    {% set descriptionId = \"#{id}-description\" %}

    {% set areaDescribedBy = \"#{feedbackId}\" %}

    {% if description is not empty %}
        {% set areaDescribedBy = \"#{descriptionId} #{feedbackId}\" %}
    {% endif %}

    <div class=\"form-group{% if additionalClass is not empty %} {{ additionalClass }}{% endif %}\">
        {% block component_form_select_label %}
            {% if label %}
                <label class=\"form-label\" for=\"{{ id }}\">
                    {{ label|raw }}

                    {% if 'required' in validationRules %}
                        <span class=\"form-required-label\" aria-hidden=\"true\">{{ 'general.required'|trans|sw_sanitize }}</span>
                    {% endif %}
                </label>
            {% endif %}
        {% endblock %}

        {% block component_form_select_select %}
            {% set cssClass = 'form-select' %}

            {% if additionalSelectClass is not empty %}
                {% set cssClass = \"#{cssClass} #{additionalSelectClass}\" %}
            {% endif %}

            {% if violationPath is not empty and formViolations.getViolations(violationPath) is not empty %}
                {% set cssClass = \"#{cssClass} is-invalid\" %}
            {% endif %}

            <select class=\"{{ cssClass }}\"
                    id=\"{{ id }}\"
                    name=\"{{ name }}\"
                    aria-describedby=\"{{ areaDescribedBy }}\"
                    {% if autocomplete is not empty %}autocomplete=\"{{ autocomplete }}\"{% endif %}
                    {% if validationRules is not empty %}data-validation=\"{{ validationRules }}\"{% endif %}
                    {% if 'required' in validationRules %}aria-required=\"true\"{% endif %}
                    {% if attributes is not empty %}{% for key, value in attributes %}{% if value is not empty %}{{ key ~ '=' ~ value ~ ' ' }}{% endif %}{% endfor %}{% endif %}
                    {% if disabled is not empty %}disabled{% endif %}>
                {% block component_form_select_select_options %}
                    {{ options }}
                {% endblock %}
            </select>
        {% endblock %}

        {% block component_form_select_description %}
            {% if description is not empty %}
                <small id=\"{{ descriptionId }}\" class=\"form-text\">{{ description }}</small>
            {% endif %}
        {% endblock %}

        {% block component_form_select_feedback %}
            <div id=\"{{ feedbackId }}\" class=\"form-field-feedback\">
                {% block component_form_input_feedback_violations %}
                    {% if violationPath is not empty and formViolations.getViolations(violationPath) is not empty %}
                        {% sw_include '@Storefront/storefront/utilities/form-violation.html.twig' %}
                    {% endif %}
                {% endblock %}
            </div>
        {% endblock %}
    </div>

{% endblock %}
", "@Storefront/storefront/component/form/form-select.html.twig", "/var/www/html/shopware/vendor/shopware/storefront/Resources/views/storefront/component/form/form-select.html.twig");
    }
}
