<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @Storefront/storefront/component/checkout/offcanvas-cart.html.twig */
class __TwigTemplate_32066f8c2fc2dcc16ce301d9958852e6 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->blocks = [
            'utilities_offcanvas_meta' => [$this, 'block_utilities_offcanvas_meta'],
            'utilities_offcanvas_close_text' => [$this, 'block_utilities_offcanvas_close_text'],
            'utilities_offcanvas_close_icon' => [$this, 'block_utilities_offcanvas_close_icon'],
            'utilities_offcanvas_content' => [$this, 'block_utilities_offcanvas_content'],
            'component_offcanvas_cart' => [$this, 'block_component_offcanvas_cart'],
            'component_offcanvas_cart_header' => [$this, 'block_component_offcanvas_cart_header'],
            'component_offcanvas_cart_header_item_counter' => [$this, 'block_component_offcanvas_cart_header_item_counter'],
            'component_offcanvas_cart_flashbags' => [$this, 'block_component_offcanvas_cart_flashbags'],
            'component_offcanvas_cart_items' => [$this, 'block_component_offcanvas_cart_items'],
            'component_offcanvas_cart_item' => [$this, 'block_component_offcanvas_cart_item'],
            'component_offcanvas_cart_empty' => [$this, 'block_component_offcanvas_cart_empty'],
            'component_offcanvas_summary' => [$this, 'block_component_offcanvas_summary'],
            'component_offcanvas_cart_actions' => [$this, 'block_component_offcanvas_cart_actions'],
            'component_offcanvas_cart_actions_promotion' => [$this, 'block_component_offcanvas_cart_actions_promotion'],
            'component_offcanvas_cart_actions_promotion_form' => [$this, 'block_component_offcanvas_cart_actions_promotion_form'],
            'component_offcanvas_cart_actions_promotion_redirect' => [$this, 'block_component_offcanvas_cart_actions_promotion_redirect'],
            'component_offcanvas_cart_actions_promotion_label' => [$this, 'block_component_offcanvas_cart_actions_promotion_label'],
            'component_offcanvas_cart_actions_promotion_input_group' => [$this, 'block_component_offcanvas_cart_actions_promotion_input_group'],
            'component_offcanvas_cart_actions_promotion_input' => [$this, 'block_component_offcanvas_cart_actions_promotion_input'],
            'component_offcanvas_cart_actions_promotion_submit' => [$this, 'block_component_offcanvas_cart_actions_promotion_submit'],
            'component_offcanvas_cart_actions_checkout' => [$this, 'block_component_offcanvas_cart_actions_checkout'],
            'component_offcanvas_cart_actions_cart' => [$this, 'block_component_offcanvas_cart_actions_cart'],
            'component_offcanvas_cart_hidden_line_items_information' => [$this, 'block_component_offcanvas_cart_hidden_line_items_information'],
        ];
    }

    protected function doGetParent(array $context): bool|string|Template|TemplateWrapper
    {
        // line 2
        return "@Storefront/storefront/utilities/offcanvas.html.twig";
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "@Storefront/storefront/component/checkout/offcanvas-cart.html.twig"));

        $this->parent = $this->load("@Storefront/storefront/utilities/offcanvas.html.twig", 2);
        yield from $this->parent->unwrap()->yield($context, array_merge($this->blocks, $blocks));
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

    }

    // line 3
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_offcanvas_meta(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_offcanvas_meta"));

        // line 4
        yield "    ";
        $context["isAjaxOffcanvas"] = true;
        // line 5
        yield "
    ";
        // line 6
        yield from $this->yieldParentBlock("utilities_offcanvas_meta", $context, $blocks);
        yield "
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 9
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_offcanvas_close_text(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_offcanvas_close_text"));

        // line 10
        yield "    ";
        yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.continueShopping"));
        yield "
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 13
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_offcanvas_close_icon(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_offcanvas_close_icon"));

        // line 14
        yield "    ";
        yield from         ((function () use ($context, $blocks) {
            $finder = $this->env->getExtension('Shopware\Core\Framework\Adapter\Twig\Extension\NodeExtension')->getFinder();

            $includeTemplate = $finder->find("@Storefront/storefront/utilities/icon.html.twig");

            return $this->load($includeTemplate ?? null, 14);
        })())->unwrap()->yield(CoreExtension::merge($context, ["size" => "sm", "name" => "arrow-head-left"]));
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 17
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_offcanvas_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_offcanvas_content"));

        // line 18
        yield "    ";
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart', $context, $blocks);
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart"));

        // line 19
        yield "        ";
        $context["isCartNotEmpty"] = (Twig\Extension\CoreExtension::length($this->env->getCharset(), \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["page"] ?? null), "cart", [], "any", false, false, false, 19), "lineItems", [], "any", false, false, false, 19)) > 0);
        // line 20
        yield "
        <div class=\"offcanvas-cart\">
            ";
        // line 22
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_header', $context, $blocks);
        // line 44
        yield "
            ";
        // line 45
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_flashbags', $context, $blocks);
        // line 55
        yield "
            ";
        // line 56
        if ((($tmp = ($context["isCartNotEmpty"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 57
            yield "                ";
            yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_items', $context, $blocks);
            // line 69
            yield "            ";
        } else {
            // line 70
            yield "                ";
            yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_empty', $context, $blocks);
            // line 76
            yield "            ";
        }
        // line 77
        yield "
            ";
        // line 78
        if ((($tmp = ($context["isCartNotEmpty"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 79
            yield "                ";
            yield from $this->unwrap()->yieldBlock('component_offcanvas_summary', $context, $blocks);
            // line 82
            yield "            ";
        }
        // line 83
        yield "
            ";
        // line 84
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions', $context, $blocks);
        // line 156
        yield "        </div>

        ";
        // line 158
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_hidden_line_items_information', $context, $blocks);
        // line 164
        yield "    ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 22
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_header(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_header"));

        // line 23
        yield "                <div class=\"row align-items-center offcanvas-cart-header\">

                    <div class=\"col\">
                        <h4 data-id=\"off-canvas-headline\">";
        // line 27
        yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.cartHeader"));
        // line 28
        yield "</h4>
                    </div>

                    ";
        // line 31
        $context["checkoutItemCounter"] = Twig\Extension\CoreExtension::length($this->env->getCharset(), \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["page"] ?? null), "cart", [], "any", false, false, false, 31), "lineItems", [], "any", false, false, false, 31));
        // line 32
        yield "
                    ";
        // line 33
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_header_item_counter', $context, $blocks);
        // line 42
        yield "                </div>
            ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 33
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_header_item_counter(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_header_item_counter"));

        // line 34
        yield "                        ";
        if ((($tmp = ($context["isCartNotEmpty"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 35
            yield "                            <div class=\"col-auto\">
                                <small class=\"offcanvas-cart-header-count h4\">";
            // line 37
            yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.itemCounter", ["%count%" => ($context["checkoutItemCounter"] ?? null)]));
            // line 38
            yield "</small>
                            </div>
                        ";
        }
        // line 41
        yield "                    ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 45
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_flashbags(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_flashbags"));

        // line 46
        yield "                <div class=\"flashbags\">
                    ";
        // line 47
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["app"] ?? null), "flashes", [], "any", false, false, false, 47));
        $context['loop'] = [
          'parent' => $context['_parent'],
          'index0' => 0,
          'index'  => 1,
          'first'  => true,
        ];
        if (is_array($context['_seq']) || (is_object($context['_seq']) && $context['_seq'] instanceof \Countable)) {
            $length = count($context['_seq']);
            $context['loop']['revindex0'] = $length - 1;
            $context['loop']['revindex'] = $length;
            $context['loop']['length'] = $length;
            $context['loop']['last'] = 1 === $length;
        }
        foreach ($context['_seq'] as $context["type"] => $context["messages"]) {
            // line 48
            yield "                        ";
            yield from $this->load("@Storefront/storefront/utilities/alert.html.twig", 48)->unwrap()->yield(CoreExtension::merge($context, ["type" =>             // line 49
$context["type"], "list" =>             // line 50
$context["messages"]]));
            // line 52
            yield "                    ";
            ++$context['loop']['index0'];
            ++$context['loop']['index'];
            $context['loop']['first'] = false;
            if (isset($context['loop']['revindex0'], $context['loop']['revindex'])) {
                --$context['loop']['revindex0'];
                --$context['loop']['revindex'];
                $context['loop']['last'] = 0 === $context['loop']['revindex0'];
            }
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['type'], $context['messages'], $context['_parent'], $context['loop']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 53
        yield "                </div>
            ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 57
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_items(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_items"));

        // line 58
        yield "                    <ul class=\"offcanvas-cart-items list-unstyled\">
                        ";
        // line 59
        $context['_parent'] = $context;
        $context['_seq'] = CoreExtension::ensureTraversable(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["page"] ?? null), "cart", [], "any", false, false, false, 59), "lineItems", [], "any", false, false, false, 59));
        $context['loop'] = [
          'parent' => $context['_parent'],
          'index0' => 0,
          'index'  => 1,
          'first'  => true,
        ];
        if (is_array($context['_seq']) || (is_object($context['_seq']) && $context['_seq'] instanceof \Countable)) {
            $length = count($context['_seq']);
            $context['loop']['revindex0'] = $length - 1;
            $context['loop']['revindex'] = $length;
            $context['loop']['length'] = $length;
            $context['loop']['last'] = 1 === $length;
        }
        foreach ($context['_seq'] as $context["_key"] => $context["lineItem"]) {
            // line 60
            yield "                            ";
            yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_item', $context, $blocks);
            // line 66
            yield "                        ";
            ++$context['loop']['index0'];
            ++$context['loop']['index'];
            $context['loop']['first'] = false;
            if (isset($context['loop']['revindex0'], $context['loop']['revindex'])) {
                --$context['loop']['revindex0'];
                --$context['loop']['revindex'];
                $context['loop']['last'] = 0 === $context['loop']['revindex0'];
            }
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_key'], $context['lineItem'], $context['_parent'], $context['loop']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 67
        yield "                    </ul>
                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 60
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_item(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_item"));

        // line 61
        yield "                                ";
        yield from $this->load("@Storefront/storefront/component/line-item/line-item.html.twig", 61)->unwrap()->yield(CoreExtension::merge($context, ["displayMode" => "offcanvas", "redirectTo" => "frontend.cart.offcanvas"]));
        // line 65
        yield "                            ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 70
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_empty(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_empty"));

        // line 71
        yield "                    ";
        yield from $this->load("@Storefront/storefront/utilities/alert.html.twig", 71)->unwrap()->yield(CoreExtension::merge($context, ["type" => "info", "content" => $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.emptyCart"))]));
        // line 75
        yield "                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 79
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_summary(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_summary"));

        // line 80
        yield "                    ";
        yield from $this->load("@Storefront/storefront/component/checkout/offcanvas-cart-summary.html.twig", 80)->unwrap()->yield($context);
        // line 81
        yield "                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 84
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions"));

        // line 85
        yield "                <div class=\"offcanvas-cart-actions\">
                    ";
        // line 86
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions_promotion', $context, $blocks);
        // line 134
        yield "
                    ";
        // line 135
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions_checkout', $context, $blocks);
        // line 144
        yield "
                    ";
        // line 145
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions_cart', $context, $blocks);
        // line 154
        yield "                </div>
            ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 86
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions_promotion(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions_promotion"));

        // line 87
        yield "                        ";
        if ((($tmp = ($context["isCartNotEmpty"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 88
            yield "                            <div class=\"js-offcanvas-cart-promotion\">
                                ";
            // line 89
            yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions_promotion_form', $context, $blocks);
            // line 131
            yield "                            </div>
                        ";
        }
        // line 133
        yield "                    ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 89
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions_promotion_form(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions_promotion_form"));

        // line 90
        yield "                                    <form action=\"";
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("frontend.checkout.promotion.add");
        yield "\"
                                          class=\"offcanvas-cart-promotion-form js-offcanvas-cart-add-promotion\"
                                          method=\"post\">
                                        ";
        // line 93
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions_promotion_redirect', $context, $blocks);
        // line 98
        yield "
                                        ";
        // line 99
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions_promotion_label', $context, $blocks);
        // line 104
        yield "
                                        ";
        // line 105
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions_promotion_input_group', $context, $blocks);
        // line 129
        yield "                                    </form>
                                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 93
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions_promotion_redirect(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions_promotion_redirect"));

        // line 94
        yield "                                            <input type=\"hidden\"
                                                   name=\"redirectTo\"
                                                   value=\"frontend.cart.offcanvas\">
                                        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 99
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions_promotion_label(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions_promotion_label"));

        // line 100
        yield "                                            <label class=\"mb-1\" for=\"addPromotionOffcanvasCartInput\">
                                                ";
        // line 101
        yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.addPromotionLabel"));
        yield "
                                            </label>
                                        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 105
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions_promotion_input_group(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions_promotion_input_group"));

        // line 106
        yield "                                            <div class=\"input-group\">
                                                ";
        // line 107
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions_promotion_input', $context, $blocks);
        // line 118
        yield "
                                                ";
        // line 119
        yield from $this->unwrap()->yieldBlock('component_offcanvas_cart_actions_promotion_submit', $context, $blocks);
        // line 127
        yield "                                            </div>
                                        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 107
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions_promotion_input(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions_promotion_input"));

        // line 108
        yield "                                                    <input type=\"text\"
                                                           name=\"code\"
                                                           class=\"form-control\"
                                                           placeholder=\"";
        // line 111
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::striptags($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.addPromotionPlaceholder")), "html", null, true);
        yield "\"
                                                           id=\"addPromotionOffcanvasCartInput\"
                                                           aria-label=\"";
        // line 113
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::striptags($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.addPromotionLabel")), "html", null, true);
        yield "\"
                                                           aria-describedby=\"addPromotionOffcanvasCart\"
                                                           required=\"required\"
                                                           aria-invalid=\"false\">
                                                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 119
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions_promotion_submit(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions_promotion_submit"));

        // line 120
        yield "                                                    <button class=\"btn btn-outline-secondary offcanvas-cart-promotion-button\"
                                                            type=\"submit\"
                                                            id=\"addPromotionOffcanvasCart\"
                                                            aria-labelledby=\"addPromotionOffcanvasCartInput\">
                                                        ";
        // line 124
        yield from         ((function () use ($context, $blocks) {
            $finder = $this->env->getExtension('Shopware\Core\Framework\Adapter\Twig\Extension\NodeExtension')->getFinder();

            $includeTemplate = $finder->find("@Storefront/storefront/utilities/icon.html.twig");

            return $this->load($includeTemplate ?? null, 124);
        })())->unwrap()->yield(CoreExtension::merge($context, ["name" => "checkmark"]));
        // line 125
        yield "                                                    </button>
                                                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 135
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions_checkout(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions_checkout"));

        // line 136
        yield "                        <div class=\"d-grid\">
                            <a href=\"";
        // line 137
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("frontend.checkout.confirm.page");
        yield "\"
                               class=\"btn begin-checkout-btn";
        // line 138
        if ((($tmp = ($context["isCartNotEmpty"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield " btn-primary";
        } else {
            yield " btn-light disabled";
        }
        yield "\"
                               title=\"";
        // line 139
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::striptags($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.proceedToCheckout")), "html", null, true);
        yield "\">
                                ";
        // line 140
        yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.proceedToCheckout"));
        yield "
                            </a>
                        </div>
                    ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 145
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_actions_cart(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_actions_cart"));

        // line 146
        yield "                        <div class=\"d-grid\">
                            <a href=\"";
        // line 147
        yield $this->extensions['Symfony\Bridge\Twig\Extension\RoutingExtension']->getPath("frontend.checkout.cart.page");
        yield "\"
                               class=\"btn btn-link\"
                               title=\"";
        // line 149
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::striptags($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.proceedToCart")), "html", null, true);
        yield "\">
                                ";
        // line 150
        yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("checkout.proceedToCart"));
        yield "
                            </a>
                        </div>
                    ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 158
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_offcanvas_cart_hidden_line_items_information(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_offcanvas_cart_hidden_line_items_information"));

        // line 159
        yield "            ";
        yield from $this->load("@Storefront/storefront/component/checkout/hidden-line-items-information.html.twig", 159)->unwrap()->yield(CoreExtension::merge($context, ["cart" => \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source,         // line 160
($context["page"] ?? null), "cart", [], "any", false, false, false, 160), "lineItems" => \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, \Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source,         // line 161
($context["page"] ?? null), "cart", [], "any", false, false, false, 161), "lineItems", [], "any", false, false, false, 161)]));
        // line 163
        yield "        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@Storefront/storefront/component/checkout/offcanvas-cart.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable(): bool
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  818 => 163,  816 => 161,  815 => 160,  813 => 159,  803 => 158,  791 => 150,  787 => 149,  782 => 147,  779 => 146,  769 => 145,  757 => 140,  753 => 139,  745 => 138,  741 => 137,  738 => 136,  728 => 135,  719 => 125,  711 => 124,  705 => 120,  695 => 119,  682 => 113,  677 => 111,  672 => 108,  662 => 107,  653 => 127,  651 => 119,  648 => 118,  646 => 107,  643 => 106,  633 => 105,  622 => 101,  619 => 100,  609 => 99,  598 => 94,  588 => 93,  579 => 129,  577 => 105,  574 => 104,  572 => 99,  569 => 98,  567 => 93,  560 => 90,  550 => 89,  542 => 133,  538 => 131,  536 => 89,  533 => 88,  530 => 87,  520 => 86,  511 => 154,  509 => 145,  506 => 144,  504 => 135,  501 => 134,  499 => 86,  496 => 85,  486 => 84,  478 => 81,  475 => 80,  465 => 79,  457 => 75,  454 => 71,  444 => 70,  436 => 65,  433 => 61,  423 => 60,  414 => 67,  400 => 66,  397 => 60,  380 => 59,  377 => 58,  367 => 57,  358 => 53,  344 => 52,  342 => 50,  341 => 49,  339 => 48,  322 => 47,  319 => 46,  309 => 45,  301 => 41,  296 => 38,  294 => 37,  291 => 35,  288 => 34,  278 => 33,  269 => 42,  267 => 33,  264 => 32,  262 => 31,  257 => 28,  255 => 27,  250 => 23,  240 => 22,  232 => 164,  230 => 158,  226 => 156,  224 => 84,  221 => 83,  218 => 82,  215 => 79,  213 => 78,  210 => 77,  207 => 76,  204 => 70,  201 => 69,  198 => 57,  196 => 56,  193 => 55,  191 => 45,  188 => 44,  186 => 22,  182 => 20,  179 => 19,  161 => 18,  151 => 17,  136 => 14,  126 => 13,  115 => 10,  105 => 9,  95 => 6,  92 => 5,  89 => 4,  79 => 3,  62 => 2,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{% sw_extends '@Storefront/storefront/utilities/offcanvas.html.twig' %}

{% block utilities_offcanvas_meta %}
    {% set isAjaxOffcanvas = true %}

    {{ parent() }}
{% endblock %}

{% block utilities_offcanvas_close_text %}
    {{ 'checkout.continueShopping'|trans|sw_sanitize }}
{% endblock %}

{% block utilities_offcanvas_close_icon %}
    {% sw_icon 'arrow-head-left' style { size: 'sm' } %}
{% endblock %}

{% block utilities_offcanvas_content %}
    {% block component_offcanvas_cart %}
        {% set isCartNotEmpty = (page.cart.lineItems|length > 0) %}

        <div class=\"offcanvas-cart\">
            {% block component_offcanvas_cart_header %}
                <div class=\"row align-items-center offcanvas-cart-header\">

                    <div class=\"col\">
                        <h4 data-id=\"off-canvas-headline\">
                            {{- 'checkout.cartHeader'|trans|sw_sanitize -}}
                        </h4>
                    </div>

                    {% set checkoutItemCounter = page.cart.lineItems|length %}

                    {% block component_offcanvas_cart_header_item_counter %}
                        {% if isCartNotEmpty %}
                            <div class=\"col-auto\">
                                <small class=\"offcanvas-cart-header-count h4\">
                                    {{- 'checkout.itemCounter'|trans({'%count%': checkoutItemCounter})|sw_sanitize -}}
                                </small>
                            </div>
                        {% endif %}
                    {% endblock %}
                </div>
            {% endblock %}

            {% block component_offcanvas_cart_flashbags %}
                <div class=\"flashbags\">
                    {% for type, messages in app.flashes %}
                        {% sw_include '@Storefront/storefront/utilities/alert.html.twig' with {
                            type: type,
                            list: messages
                        } %}
                    {% endfor %}
                </div>
            {% endblock %}

            {% if isCartNotEmpty %}
                {% block component_offcanvas_cart_items %}
                    <ul class=\"offcanvas-cart-items list-unstyled\">
                        {% for lineItem in page.cart.lineItems %}
                            {% block component_offcanvas_cart_item %}
                                {% sw_include '@Storefront/storefront/component/line-item/line-item.html.twig' with {
                                    displayMode: 'offcanvas',
                                    redirectTo: 'frontend.cart.offcanvas'
                                } %}
                            {% endblock %}
                        {% endfor %}
                    </ul>
                {% endblock %}
            {% else %}
                {% block component_offcanvas_cart_empty %}
                    {% sw_include '@Storefront/storefront/utilities/alert.html.twig' with {
                        type: 'info',
                        content: 'checkout.emptyCart'|trans|sw_sanitize
                    } %}
                {% endblock %}
            {% endif %}

            {% if isCartNotEmpty %}
                {% block component_offcanvas_summary %}
                    {% sw_include '@Storefront/storefront/component/checkout/offcanvas-cart-summary.html.twig' %}
                {% endblock %}
            {% endif %}

            {% block component_offcanvas_cart_actions %}
                <div class=\"offcanvas-cart-actions\">
                    {% block component_offcanvas_cart_actions_promotion %}
                        {% if isCartNotEmpty %}
                            <div class=\"js-offcanvas-cart-promotion\">
                                {% block component_offcanvas_cart_actions_promotion_form %}
                                    <form action=\"{{ path('frontend.checkout.promotion.add') }}\"
                                          class=\"offcanvas-cart-promotion-form js-offcanvas-cart-add-promotion\"
                                          method=\"post\">
                                        {% block component_offcanvas_cart_actions_promotion_redirect %}
                                            <input type=\"hidden\"
                                                   name=\"redirectTo\"
                                                   value=\"frontend.cart.offcanvas\">
                                        {% endblock %}

                                        {% block component_offcanvas_cart_actions_promotion_label %}
                                            <label class=\"mb-1\" for=\"addPromotionOffcanvasCartInput\">
                                                {{ 'checkout.addPromotionLabel'|trans|sw_sanitize }}
                                            </label>
                                        {% endblock %}

                                        {% block component_offcanvas_cart_actions_promotion_input_group %}
                                            <div class=\"input-group\">
                                                {% block component_offcanvas_cart_actions_promotion_input %}
                                                    <input type=\"text\"
                                                           name=\"code\"
                                                           class=\"form-control\"
                                                           placeholder=\"{{ 'checkout.addPromotionPlaceholder'|trans|striptags }}\"
                                                           id=\"addPromotionOffcanvasCartInput\"
                                                           aria-label=\"{{ 'checkout.addPromotionLabel'|trans|striptags }}\"
                                                           aria-describedby=\"addPromotionOffcanvasCart\"
                                                           required=\"required\"
                                                           aria-invalid=\"false\">
                                                {% endblock %}

                                                {% block component_offcanvas_cart_actions_promotion_submit %}
                                                    <button class=\"btn btn-outline-secondary offcanvas-cart-promotion-button\"
                                                            type=\"submit\"
                                                            id=\"addPromotionOffcanvasCart\"
                                                            aria-labelledby=\"addPromotionOffcanvasCartInput\">
                                                        {% sw_icon 'checkmark' %}
                                                    </button>
                                                {% endblock %}
                                            </div>
                                        {% endblock %}
                                    </form>
                                {% endblock %}
                            </div>
                        {% endif %}
                    {% endblock %}

                    {% block component_offcanvas_cart_actions_checkout %}
                        <div class=\"d-grid\">
                            <a href=\"{{ path('frontend.checkout.confirm.page') }}\"
                               class=\"btn begin-checkout-btn{% if isCartNotEmpty %} btn-primary{% else %} btn-light disabled{% endif %}\"
                               title=\"{{ 'checkout.proceedToCheckout'|trans|striptags }}\">
                                {{ 'checkout.proceedToCheckout'|trans|sw_sanitize }}
                            </a>
                        </div>
                    {% endblock %}

                    {% block component_offcanvas_cart_actions_cart %}
                        <div class=\"d-grid\">
                            <a href=\"{{ path('frontend.checkout.cart.page') }}\"
                               class=\"btn btn-link\"
                               title=\"{{ 'checkout.proceedToCart'|trans|striptags }}\">
                                {{ 'checkout.proceedToCart'|trans|sw_sanitize }}
                            </a>
                        </div>
                    {% endblock %}
                </div>
            {% endblock %}
        </div>

        {% block component_offcanvas_cart_hidden_line_items_information %}
            {% sw_include '@Storefront/storefront/component/checkout/hidden-line-items-information.html.twig' with {
                cart: page.cart,
                lineItems: page.cart.lineItems
            } %}
        {% endblock %}
    {% endblock %}
{% endblock %}
", "@Storefront/storefront/component/checkout/offcanvas-cart.html.twig", "/var/www/html/shopware/vendor/shopware/storefront/Resources/views/storefront/component/checkout/offcanvas-cart.html.twig");
    }
}
