<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @Storefront/storefront/utilities/alert.html.twig */
class __TwigTemplate_81d90dbbabecfac8ef3df4b7309f2c0e extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'utilities_alert' => [$this, 'block_utilities_alert'],
            'utilities_alert_icon' => [$this, 'block_utilities_alert_icon'],
            'utilities_alert_content_container' => [$this, 'block_utilities_alert_content_container'],
            'utilities_alert_heading' => [$this, 'block_utilities_alert_heading'],
            'utilities_alert_content' => [$this, 'block_utilities_alert_content'],
            'utilities_alert_dismissible' => [$this, 'block_utilities_alert_dismissible'],
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "@Storefront/storefront/utilities/alert.html.twig"));

        // line 87
        yield "
";
        // line 88
        yield from $this->unwrap()->yieldBlock('utilities_alert', $context, $blocks);
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_alert(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_alert"));

        // line 89
        yield "    <div role=\"alert\"
         aria-live=\"polite\"
         class=\"alert ";
        // line 91
        if ((($tmp = ($context["type"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "alert-";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["type"] ?? null), "html", null, true);
        }
        if ((($tmp = ($context["dismissible"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield " alert-dismissible fade show";
        }
        if ((($context["icon"] ?? null) != "error")) {
            yield " d-flex align-items-center";
        }
        yield "\">

        ";
        // line 93
        yield from $this->unwrap()->yieldBlock('utilities_alert_icon', $context, $blocks);
        // line 115
        yield "
        ";
        // line 116
        yield from $this->unwrap()->yieldBlock('utilities_alert_content_container', $context, $blocks);
        // line 154
        yield "    </div>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 93
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_alert_icon(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_alert_icon"));

        // line 94
        yield "            ";
        if ((($context["icon"] ?? null) != "false")) {
            // line 95
            yield "                ";
            $context["iconCacheSystem"] = $this->extensions['Shopware\Storefront\Framework\Twig\Extension\ConfigExtension']->config($context, "core.storefrontSettings.iconCache");
            // line 96
            yield "                ";
            if (((($context["iconCache"] ?? null) === false) && (($context["iconCacheSystem"] ?? null) === true))) {
                // line 97
                yield "                    ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Shopware\Storefront\Framework\Twig\Extension\IconCacheTwigFilter::disable(), "html", null, true);
                yield "
                ";
            }
            // line 99
            yield "                ";
            if ((($context["type"] ?? null) == "danger")) {
                // line 100
                yield "                    ";
                yield from                 ((function () use ($context, $blocks) {
                    $finder = $this->env->getExtension('Shopware\Core\Framework\Adapter\Twig\Extension\NodeExtension')->getFinder();

                    $includeTemplate = $finder->find("@Storefront/storefront/utilities/icon.html.twig");

                    return $this->load($includeTemplate ?? null, 100);
                })())->unwrap()->yield(CoreExtension::merge($context, ["name" => "blocked"]));
                // line 101
                yield "                ";
            } elseif ((($context["type"] ?? null) == "warning")) {
                // line 102
                yield "                    ";
                yield from                 ((function () use ($context, $blocks) {
                    $finder = $this->env->getExtension('Shopware\Core\Framework\Adapter\Twig\Extension\NodeExtension')->getFinder();

                    $includeTemplate = $finder->find("@Storefront/storefront/utilities/icon.html.twig");

                    return $this->load($includeTemplate ?? null, 102);
                })())->unwrap()->yield(CoreExtension::merge($context, ["name" => "warning"]));
                // line 103
                yield "                ";
            } elseif ((($context["type"] ?? null) == "info")) {
                // line 104
                yield "                    ";
                yield from                 ((function () use ($context, $blocks) {
                    $finder = $this->env->getExtension('Shopware\Core\Framework\Adapter\Twig\Extension\NodeExtension')->getFinder();

                    $includeTemplate = $finder->find("@Storefront/storefront/utilities/icon.html.twig");

                    return $this->load($includeTemplate ?? null, 104);
                })())->unwrap()->yield(CoreExtension::merge($context, ["name" => "info"]));
                // line 105
                yield "                ";
            } elseif ((($context["type"] ?? null) == "success")) {
                // line 106
                yield "                    ";
                yield from                 ((function () use ($context, $blocks) {
                    $finder = $this->env->getExtension('Shopware\Core\Framework\Adapter\Twig\Extension\NodeExtension')->getFinder();

                    $includeTemplate = $finder->find("@Storefront/storefront/utilities/icon.html.twig");

                    return $this->load($includeTemplate ?? null, 106);
                })())->unwrap()->yield(CoreExtension::merge($context, ["name" => "checkmark-circle"]));
                // line 107
                yield "                ";
            } else {
                // line 108
                yield "                    ";
                yield from                 ((function () use ($context, $blocks) {
                    $finder = $this->env->getExtension('Shopware\Core\Framework\Adapter\Twig\Extension\NodeExtension')->getFinder();

                    $includeTemplate = $finder->find("@Storefront/storefront/utilities/icon.html.twig");

                    return $this->load($includeTemplate ?? null, 108);
                })())->unwrap()->yield(CoreExtension::merge($context, ["name" => "alert"]));
                // line 109
                yield "                ";
            }
            // line 110
            yield "                ";
            if (((($context["iconCache"] ?? null) == false) && (($context["iconCacheSystem"] ?? null) === true))) {
                // line 111
                yield "                    ";
                yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Shopware\Storefront\Framework\Twig\Extension\IconCacheTwigFilter::enable(), "html", null, true);
                yield "
                ";
            }
            // line 113
            yield "            ";
        }
        // line 114
        yield "        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 116
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_alert_content_container(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_alert_content_container"));

        // line 117
        yield "            <div class=\"alert-content-container\">
                ";
        // line 118
        yield from $this->unwrap()->yieldBlock('utilities_alert_heading', $context, $blocks);
        // line 125
        yield "
                ";
        // line 126
        yield from $this->unwrap()->yieldBlock('utilities_alert_content', $context, $blocks);
        // line 141
        yield "
                ";
        // line 142
        yield from $this->unwrap()->yieldBlock('utilities_alert_dismissible', $context, $blocks);
        // line 152
        yield "            </div>
        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 118
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_alert_heading(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_alert_heading"));

        // line 119
        yield "                    ";
        if ((($tmp = ($context["heading"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 120
            yield "                        <div class=\"alert-heading h5\">
                            ";
            // line 121
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["heading"] ?? null), "html", null, true);
            yield "
                        </div>
                    ";
        }
        // line 124
        yield "                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 126
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_alert_content(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_alert_content"));

        // line 127
        yield "                    ";
        if ((Twig\Extension\CoreExtension::length($this->env->getCharset(), ($context["list"] ?? null)) > 1)) {
            // line 128
            yield "                        <ul class=\"alert-list\">
                            ";
            // line 129
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(($context["list"] ?? null));
            foreach ($context['_seq'] as $context["_key"] => $context["entry"]) {
                // line 130
                yield "                                <li>";
                yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($context["entry"]);
                yield "</li>
                            ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['entry'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 132
            yield "                        </ul>
                    ";
        } elseif ((Twig\Extension\CoreExtension::length($this->env->getCharset(),         // line 133
($context["list"] ?? null)) == 1)) {
            // line 134
            yield "                        ";
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(($context["list"] ?? null));
            foreach ($context['_seq'] as $context["_key"] => $context["entry"]) {
                // line 135
                yield "                            ";
                yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($context["entry"]);
                yield "
                        ";
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['_key'], $context['entry'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
            // line 137
            yield "                    ";
        } else {
            // line 138
            yield "                        ";
            yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize(($context["content"] ?? null));
            yield "
                    ";
        }
        // line 140
        yield "                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 142
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_utilities_alert_dismissible(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "utilities_alert_dismissible"));

        // line 143
        yield "                    ";
        if ((($tmp = ($context["dismissible"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 144
            yield "                        <button type=\"button\"
                                class=\"btn-close\"
                                data-bs-dismiss=\"alert\"
                                aria-label=\"";
            // line 147
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(Twig\Extension\CoreExtension::striptags($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("global.default.close")), "html", null, true);
            yield "\">
                            <span aria-hidden=\"true\"></span>
                        </button>
                    ";
        }
        // line 151
        yield "                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@Storefront/storefront/utilities/alert.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  367 => 151,  360 => 147,  355 => 144,  352 => 143,  342 => 142,  334 => 140,  328 => 138,  325 => 137,  316 => 135,  311 => 134,  309 => 133,  306 => 132,  297 => 130,  293 => 129,  290 => 128,  287 => 127,  277 => 126,  269 => 124,  263 => 121,  260 => 120,  257 => 119,  247 => 118,  238 => 152,  236 => 142,  233 => 141,  231 => 126,  228 => 125,  226 => 118,  223 => 117,  213 => 116,  205 => 114,  202 => 113,  196 => 111,  193 => 110,  190 => 109,  181 => 108,  178 => 107,  169 => 106,  166 => 105,  157 => 104,  154 => 103,  145 => 102,  142 => 101,  133 => 100,  130 => 99,  124 => 97,  121 => 96,  118 => 95,  115 => 94,  105 => 93,  96 => 154,  94 => 116,  91 => 115,  89 => 93,  75 => 91,  71 => 89,  54 => 88,  51 => 87,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
Global messages template

@sw-package framework

https://getbootstrap.com/docs/5.2/components/alerts

*Type:
The template provides an easy way to display messages in the storefront. The following types are supported:

* primary
* secondary
* danger (red)
* success (green)
* warning (yellow)
* info (blue)
* light (white)
* dark (dark gray)

    {% sw_include '@Storefront/storefront/utilities/alert.html.twig' with {
        type:\"primary\",
        content:\"Primary Lorem ipsum dolor\"
    } %}

*Icons:
Icons are shown by default. To hide the icon within the alert, set the value of \"icon\" to false:

    {% sw_include '@Storefront/storefront/utilities/alert.html.twig' with {
        type:\"primary\",
        content:\"Primary Lorem ipsum dolor\",
        icon: false
    } %}

*IconCache:
IconCache is used by system settings. To avoid using the icon cache regardless of the system settings (e.g. for an icon rendered in an invisible area like <noscript>), set \"iconCache\" to false:

    {% sw_include '@Storefront/storefront/utilities/alert.html.twig' with {
        type:\"primary\",
        content:\"Primary Lorem ipsum dolor\",
        iconCache: false
    } %}


*Message Content:
The component requires the parameters ```content``` or ```list``` to display a message. If no ```type``` is defined it
will use the fallback option (success).

    {% sw_include '@Storefront/storefront/utilities/alert.html.twig' with {
        type:\"primary\",
        content:\"Primary Lorem ipsum dolor\"
    } %}

*Message List:
If you need to display a bunch of messages (for example error messages in the registration), you can pass an array
of messages to the template using the parameter ```list```:

     {% set list1 = [
        'Error message 1',
        'Error message 2',
        'Error message 3'
    ] %}

    {% sw_include '@Storefront/storefront/utilities/alert.html.twig' with {
        type:\"secondary\",
        list: list1
    } %}

*Heading:
To display a heading, use \"heading\".

    {% sw_include '@Storefront/storefront/utilities/alert.html.twig' with {
        type:\"primary\",
        content:\"Primary Lorem ipsum dolor\",
        heading: \"Test Heading\"
    } %}

*Dismissible Button:
To display a dismissible button set the value of \"dismissible\" to true.

    {% sw_include '@Storefront/storefront/utilities/alert.html.twig' with {
        type:\"primary\",
        content:\"Primary Lorem ipsum dolor\",
        dismissible: true
    } %}

#}

{% block utilities_alert %}
    <div role=\"alert\"
         aria-live=\"polite\"
         class=\"alert {% if type %}alert-{{ type }}{% endif %}{% if dismissible %} alert-dismissible fade show{% endif %}{% if icon != 'error' %} d-flex align-items-center{% endif %}\">

        {% block utilities_alert_icon %}
            {% if icon != 'false' %}
                {% set iconCacheSystem = config('core.storefrontSettings.iconCache') %}
                {% if iconCache === false and iconCacheSystem === true %}
                    {{ sw_icon_cache_disable() }}
                {% endif %}
                {% if type == 'danger' %}
                    {% sw_icon 'blocked' %}
                {% elseif type == 'warning' %}
                    {% sw_icon 'warning' %}
                {% elseif type == 'info' %}
                    {% sw_icon 'info' %}
                {% elseif type == 'success' %}
                    {% sw_icon 'checkmark-circle' %}
                {% else %}
                    {% sw_icon 'alert' %}
                {% endif %}
                {% if iconCache == false and iconCacheSystem === true %}
                    {{ sw_icon_cache_enable() }}
                {% endif %}
            {% endif %}
        {% endblock %}

        {% block utilities_alert_content_container %}
            <div class=\"alert-content-container\">
                {% block utilities_alert_heading %}
                    {% if heading %}
                        <div class=\"alert-heading h5\">
                            {{ heading }}
                        </div>
                    {% endif %}
                {% endblock %}

                {% block utilities_alert_content %}
                    {% if list|length > 1 %}
                        <ul class=\"alert-list\">
                            {% for entry in list %}
                                <li>{{ entry|sw_sanitize }}</li>
                            {% endfor %}
                        </ul>
                    {% elseif list|length == 1 %}
                        {% for entry in list %}
                            {{ entry|sw_sanitize }}
                        {% endfor %}
                    {% else %}
                        {{ content|sw_sanitize }}
                    {% endif %}
                {% endblock %}

                {% block utilities_alert_dismissible %}
                    {% if dismissible %}
                        <button type=\"button\"
                                class=\"btn-close\"
                                data-bs-dismiss=\"alert\"
                                aria-label=\"{{ 'global.default.close'|trans|striptags }}\">
                            <span aria-hidden=\"true\"></span>
                        </button>
                    {% endif %}
                {% endblock %}
            </div>
        {% endblock %}
    </div>
{% endblock %}
", "@Storefront/storefront/utilities/alert.html.twig", "/var/www/html/shopware/vendor/shopware/storefront/Resources/views/storefront/utilities/alert.html.twig");
    }
}
