<?php

declare(strict_types=1);

/**
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Namespaces\AbstractNamespace;

/**
 * Class ObservabilityNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class ObservabilityNamespace extends AbstractNamespace
{
    /**
     * Creates a new observability object.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function createObject(array $params = [])
    {
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Observability\CreateObject');
        $endpoint->setParams($params);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Deletes specific observability object specified by ID.
     *
     * $params['object_id']   = (string) The ID of the Observability Object.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteObject(array $params = [])
    {
        $object_id = $this->extractArgument($params, 'object_id');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Observability\DeleteObject');
        $endpoint->setParams($params);
        $endpoint->setObjectId($object_id);

        return $this->performRequest($endpoint);
    }
    /**
     * Deletes specific observability objects specified by ID or a list of IDs.
     *
     * $params['objectId']     = (string) The ID of a single Observability Object to delete.
     * $params['objectIdList'] = (string) A comma-separated list of Observability Object IDs to delete.
     * $params['pretty']       = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']        = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']  = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']       = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']  = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function deleteObjects(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Observability\DeleteObjects');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves Local Stats of all observability objects.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getLocalstats(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Observability\GetLocalstats');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves specific observability object specified by ID.
     *
     * $params['object_id']   = (string) The ID of the Observability Object.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function getObject(array $params = [])
    {
        $object_id = $this->extractArgument($params, 'object_id');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Observability\GetObject');
        $endpoint->setParams($params);
        $endpoint->setObjectId($object_id);

        return $this->performRequest($endpoint);
    }
    /**
     * Retrieves list of all observability objects.
     *
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function listObjects(array $params = [])
    {
        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Observability\ListObjects');
        $endpoint->setParams($params);

        return $this->performRequest($endpoint);
    }
    /**
     * Updates an existing observability object.
     *
     * $params['object_id']   = (string) The ID of the Observability Object.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function updateObject(array $params = [])
    {
        $object_id = $this->extractArgument($params, 'object_id');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Observability\UpdateObject');
        $endpoint->setParams($params);
        $endpoint->setObjectId($object_id);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
}
