const t=`{% block sw_list_price_field %} <div :class="{ 'sw-list-price-field': true, 'sw-list-price-field__vertical': vertical }" > <div class="sw-list-price-field__price"> {% block sw_list_price_field_price %} <sw-price-field class="sw-list-price-field__price-field" :value="price" required :compact="compact" :disable-suffix="disableSuffix" :default-price="defaultPrice" :tax-rate="taxRate" :error="error" :disabled="disabled || undefined" :enable-inheritance="enableInheritance" :label="label" :currency="currency" /> {% endblock %} </div> {% block sw_product_price_form_purchase_price_field %} <div v-if="!hidePurchasePrices && showSettingPrice" class="sw-list-price-field__purchase-price" > {% block sw_product_price_form_purchase_price_field_content %} <sw-price-field class="sw-purchase-price-field" :value="purchasePrices" :gross-label="$tc('sw-product.priceForm.labelPurchasePriceGross')" :net-label="$tc('sw-product.priceForm.labelPurchasePriceNet')" :tax-rate="taxRate" :disabled="disabled || undefined" :currency="currency" /> {% endblock %} </div> {% endblock %} <div class="sw-list-price-field__list-price"> {% block sw_list_price_field_list_price %} <sw-price-field v-if="!hideListPrices && showSettingPrice" :value="listPrice" :default-price="defaultListPrice" :tax-rate="taxRate" :disabled="disabled || undefined" allow-empty :gross-label="$tc('global.sw-list-price-field.labelListPriceGross')" :gross-help-text="listPriceHelpText" :net-label="$tc('global.sw-list-price-field.labelListPriceNet')" :compact="compact" :disable-suffix="disableSuffix" :label="label" :enable-inheritance="enableInheritance" :inherited="isInherited" class="sw-list-price-field__list-price-field" :currency="currency" @change="listPriceChanged" /> {% endblock %} </div> <div class="sw-list-price-field__regulation-price"> {% block sw_list_price_field_regulation_price %} <sw-price-field v-if="!hideRegulationPrices && showSettingPrice" :value="regulationPrice" :default-price="defaultRegulationPrice" :tax-rate="taxRate" :disabled="disabled || undefined" allow-empty :gross-label="$tc('global.sw-list-price-field.labelRegulationPriceGross')" :gross-help-text="regulationPriceHelpText" :net-label="$tc('global.sw-list-price-field.labelRegulationPriceNet')" :compact="compact" :disable-suffix="disableSuffix" :label="label" :enable-inheritance="enableInheritance" :inherited="isInherited" class="sw-list-price-field__regulation-price-field" :currency="currency" @change="regulationPriceChanged" /> {% endblock %} </div> </div> {% endblock %}`,c={template:t,inheritAttrs:!1,props:{price:{type:Array,required:!0,default(){return[]}},purchasePrices:{type:Array,default(){return[]}},defaultPrice:{type:Object,required:!1,default(){return{}}},label:{required:!1,default:!0},taxRate:{type:Object,required:!0,default(){return{}}},currency:{type:Object,required:!0,default(){return{}}},compact:{required:!1,default:!1},error:{type:Object,required:!1,default:null},disabled:{required:!1,default:!1},enableInheritance:{type:Boolean,required:!1,default:!1},disableSuffix:{type:Boolean,required:!1,default:!1},vertical:{type:Boolean,required:!1,default:!1},hideListPrices:{type:Boolean,required:!1,default:!1},hidePurchasePrices:{type:Boolean,required:!1,default:!1},hideRegulationPrices:{type:Boolean,required:!1,default:!1},showSettingPrice:{type:Boolean,required:!1,default:!0}},computed:{priceForCurrency:{get(){const e=Object.values(this.price).find(r=>r.currencyId===this.currency.id);return e||{gross:this.convertPrice(this.defaultPrice.gross),linked:this.defaultPrice.linked,net:this.convertPrice(this.defaultPrice.net),listPrice:this.defaultPrice.listPrice,regulationPrice:this.defaultPrice.regulationPrice}},set(e){this.priceForCurrency.gross=e.gross,this.priceForCurrency.linked=e.linked,this.priceForCurrency.net=e.net}},listPrice:{get(){const e=this.priceForCurrency;return e.listPrice?[e.listPrice]:[{gross:null,currencyId:this.defaultPrice.currencyId?this.defaultPrice.currencyId:this.currency.id,linked:!0,net:null}]},set(e){const r=this.priceForCurrency;r&&(r.listPrice=e)}},regulationPrice:{get(){const e=this.priceForCurrency;return e.regulationPrice?[e.regulationPrice]:[{gross:null,currencyId:this.defaultPrice.currencyId?this.defaultPrice.currencyId:this.currency.id,linked:!0,net:null}]},set(e){const r=this.priceForCurrency;r&&(r.regulationPrice=e)}},defaultListPrice(){return this.defaultPrice.listPrice?this.defaultPrice.listPrice:{currencyId:this.defaultPrice.currencyId?this.defaultPrice.currencyId:this.currency.id,gross:null,net:null,linked:!0}},defaultRegulationPrice(){return this.defaultPrice.regulationPrice?this.defaultPrice.regulationPrice:{currencyId:this.defaultPrice.currencyId?this.defaultPrice.currencyId:this.currency.id,gross:null,net:null,linked:!0}},isInherited(){return!Object.values(this.price).find(r=>r.currencyId===this.currency.id)},listPriceHelpText(){return!this.vertical||this.compact?null:this.$tc("global.sw-list-price-field.helpTextListPriceGross")},regulationPriceHelpText(){return!this.vertical||this.compact?null:this.$tc("global.sw-list-price-field.helpTextRegulationPriceGross")}},methods:{listPriceChanged(e){(Number.isNaN(e.gross)||Number.isNaN(e.net))&&(e=null),this.listPrice=e},regulationPriceChanged(e){(Number.isNaN(e.gross)||Number.isNaN(e.net))&&(e=null),this.regulationPrice=e},convertPrice(e){const i=(e*this.currency.factor).toFixed(this.currency.decimalPrecision);return Number(i)}}};export{c as default};
