const r=`{% block sw_advanced_selection_product %} <sw-entity-advanced-selection-modal entity-name="product" :entity-display-text="$tc('global.sw-entity-advanced-selection-modal.entity.product')" store-key="advancedSelection.product" :entity-context="productContext" :entity-columns="productColumns" :entity-filters="productFilters" :entity-associations="productAssociations" empty-image-path="/administration/static/img/empty-states/products-empty-state.svg" v-bind="$attrs" @selection-submit="$emit('selection-submit', $event)" @modal-close="$emit('modal-close', $event)" > {% block sw_advanced_selection_product_list_grid_columns_name_preview %} <template #preview-name="{ item }"> <sw-media-preview-v2 :source="item.cover ? item.cover.media : null" /> </template> {% endblock %} {% block sw_advanced_selection_product_list_grid_columns_name %} <template #column-name="{ item }"> {% block sw_advanced_selection_product_list_grid_columns_name_content %} <sw-product-variant-info :variations="item.variation" > <span> {{ item.translated.name || item.name }} </span> </sw-product-variant-info> {% endblock %} </template> {% endblock %} {% block sw_advanced_selection_product_list_grid_columns_active %} <template #column-active="{ item }"> {% block sw_advanced_selection_product_list_grid_columns_active_content %} <mt-icon v-if="item.active" name="regular-checkmark-xs" size="16px" class="is--active" /> <mt-icon v-else name="regular-times-s" size="16px" class="is--inactive" /> {% endblock %} </template> {% endblock %} {% block sw_advanced_selection_product_list_grid_columns_price %} <template v-for="currency in currencies" #[\`column-price-\${currency.isoCode}\`]="{ item }" > {{ currencyFilter(getCurrencyPriceByCurrencyId(currency.id, item.price).gross, currency.isoCode) }} </template> {% endblock %} {% block sw_advanced_selection_product_list_grid_columns_stock %} <template #column-stock="{ item, compact }"> {% block sw_advanced_selection_product_list_grid_columns_stock_content %} {{ item.stock }} <sw-color-badge :variant="stockColorVariantFilter(item.stock)" /> {% endblock %} </template> {% endblock %} {% block sw_advanced_selection_product_list_grid_columns_release_date %} <template #column-releaseDate="{ item }"> {% block sw_advanced_selection_product_list_grid_columns_release_date_content %} <template v-if="item.releaseDate"> {{ dateFilter(item.releaseDate, { month: '2-digit', day: '2-digit' }) }} </template> <template v-else> - </template> {% endblock %} </template> {% endblock %} {% block sw_advanced_selection_product_list_grid_columns_visibilities %} <template #column-visibilities="{ item }"> <span class="sw-data-grid__cell-value"> <template v-if="item.visibilities.length > 0"> <sw-label v-for="visibility in item.visibilities" :key="visibility.id" size="medium" > {% block sw_advanced_selection_product_list_grid_columns_visibilities_content %} {{ visibility.salesChannel.translated.name || visibility.salesChannel.name }} {% endblock %} </sw-label> </template> <template v-else> - </template> </span> </template> {% endblock %} {% block sw_advanced_selection_product_list_grid_columns_categories %} <template #column-categories="{ item }"> <span class="sw-data-grid__cell-value"> <template v-if="item.categories.length > 0"> <sw-label v-for="category in item.categories" :key="category.id" v-tooltip="{ message: getCategoryBreadcrumb(category), width: 300 }" size="medium" > {% block sw_advanced_selection_product_list_grid_columns_categories_content %} {{ category.translated.name || category.name }} {% endblock %} </sw-label> </template> <template v-else> - </template> </span> </template> {% endblock %} {% block sw_advanced_selection_product_list_grid_columns_tags %} <template #column-tags="{ item }"> <span class="sw-data-grid__cell-value"> <template v-if="item.tags.length > 0"> <sw-label v-for="tag in item.tags" :key="tag.id" size="medium" > {% block sw_advanced_selection_product_list_grid_columns_tags_content %} {{ tag.name }} {% endblock %} </sw-label> </template> <template v-else> - </template> </span> </template> {% endblock %} </sw-entity-advanced-selection-modal> {% endblock %}`,{Criteria:s}=Shopware.Data,a={template:r,inject:["repositoryFactory"],emits:["selection-submit","modal-close"],data(){return{currencies:[]}},computed:{currencyRepository(){return this.repositoryFactory.create("currency")},productContext(){return{...Shopware.Context.api,inheritance:!0}},currenciesColumns(){return[...this.currencies].sort((e,t)=>t.isSystemDefault?1:-1).map(e=>({property:`price-${e.isoCode}`,dataIndex:`price.${e.id}`,label:`${e.name}`,routerLink:"sw.product.detail",allowResize:!0,currencyId:e.id,visible:e.isSystemDefault,align:"right",useCustomSort:!0}))},productColumns(){return[{property:"name",label:this.$tc("sw-product.list.columnName"),routerLink:"sw.product.detail",inlineEdit:"string",allowResize:!0,primary:!0},{property:"productNumber",naturalSorting:!0,label:this.$tc("sw-product.list.columnProductNumber"),align:"right",allowResize:!0},{property:"manufacturer.name",label:this.$tc("sw-product.list.columnManufacturer"),allowResize:!0},{property:"active",label:this.$tc("sw-product.list.columnActive"),inlineEdit:"boolean",allowResize:!0,align:"center"},...this.currenciesColumns,{property:"stock",label:this.$tc("sw-product.list.columnInStock"),inlineEdit:"number",allowResize:!0,align:"right"},{property:"availableStock",label:this.$tc("sw-product.list.columnAvailableStock"),allowResize:!0,align:"right"},{property:"releaseDate",label:this.$tc("sw-product.list.columnReleaseDate"),allowResize:!0},{property:"visibilities",dataIndex:"visibilities.salesChannel",label:this.$tc("sw-product.list.columnVisibilities"),allowResize:!0,sortable:!1,visible:!1},{property:"categories",label:this.$tc("sw-product.list.columnCategories"),allowResize:!0,sortable:!1,visible:!1},{property:"tags",label:this.$tc("sw-product.list.columnTags"),allowResize:!0,sortable:!1,visible:!1}]},productFilters(){return{"active-filter":{property:"active",label:this.$tc("sw-product.filters.activeFilter.label"),placeholder:this.$tc("sw-product.filters.activeFilter.placeholder")},"stock-filter":{property:"stock",label:this.$tc("sw-product.filters.stockFilter.label"),numberType:"int",step:1,min:0,fromPlaceholder:this.$tc("sw-product.filters.fromPlaceholder"),toPlaceholder:this.$tc("sw-product.filters.toPlaceholder")},"product-without-images-filter":{property:"media",label:this.$tc("sw-product.filters.imagesFilter.label"),placeholder:this.$tc("sw-product.filters.imagesFilter.placeholder"),optionHasCriteria:this.$tc("sw-product.filters.imagesFilter.textHasCriteria"),optionNoCriteria:this.$tc("sw-product.filters.imagesFilter.textNoCriteria")},"manufacturer-filter":{property:"manufacturer",label:this.$tc("sw-product.filters.manufacturerFilter.label"),placeholder:this.$tc("sw-product.filters.manufacturerFilter.placeholder")},"visibilities-filter":{property:"visibilities.salesChannel",label:this.$tc("sw-product.filters.salesChannelsFilter.label"),placeholder:this.$tc("sw-product.filters.salesChannelsFilter.placeholder")},"categories-filter":{property:"categories",label:this.$tc("sw-product.filters.categoriesFilter.label"),placeholder:this.$tc("sw-product.filters.categoriesFilter.placeholder"),displayPath:!0},"sales-filter":{property:"sales",label:this.$tc("sw-product.filters.salesFilter.label"),digits:20,min:0,fromPlaceholder:this.$tc("sw-product.filters.fromPlaceholder"),toPlaceholder:this.$tc("sw-product.filters.toPlaceholder")},"price-filter":{property:"price",label:this.$tc("sw-product.filters.priceFilter.label"),digits:20,min:0,fromPlaceholder:this.$tc("sw-product.filters.fromPlaceholder"),toPlaceholder:this.$tc("sw-product.filters.toPlaceholder")},"tags-filter":{property:"tags",label:this.$tc("sw-product.filters.tagsFilter.label"),placeholder:this.$tc("sw-product.filters.tagsFilter.placeholder")},"release-date-filter":{property:"releaseDate",label:this.$tc("sw-product.filters.releaseDateFilter.label"),dateType:"datetime-local",fromFieldLabel:null,toFieldLabel:null,showTimeframe:!0}}},productAssociations(){return["cover","media","manufacturer","options.group","visibilities.salesChannel","categories","tags"]},currencyFilter(){return Shopware.Filter.getByName("currency")},dateFilter(){return Shopware.Filter.getByName("date")},stockColorVariantFilter(){return Shopware.Filter.getByName("stockColorVariant")}},created(){this.createdComponent()},methods:{createdComponent(){this.currencyRepository.search(new s(1,500)).then(e=>{this.currencies=e})},productHasVariants(e){const t=e.childCount;return t!==null&&t>0},getCurrencyPriceByCurrencyId(e,t){const l=t.find(i=>i.currencyId===e);return l||{currencyId:null,gross:null,linked:!0,net:null}},getCategoryBreadcrumb(e){return e.breadcrumb?e.breadcrumb.join(" / "):e.translated.name||e.name}}};export{a as default};
