const k=`{% block sw_search_bar %} <div class="sw-search-bar"> {% block sw_search_bar_container %} <div class="sw-search-bar__container"> {% block sw_search_bar_mobile_controls %} <div v-if="!isSearchBarShown" class="sw-search-bar__mobile-controls" > {% block sw_search_bar_button_off_canvas_toggle %} <button class="sw-search-bar__button" @click="toggleOffCanvas" > <mt-icon v-if="isOffCanvasShown" name="regular-times" /> <mt-icon v-else name="regular-bars-s" /> </button> {% endblock %} {% block sw_search_bar_version_display %} <sw-version /> {% endblock %} {% block sw_search_bar_button_search %} <button class="sw-search-bar__button" @click="showSearchBar" > <mt-icon name="regular-search" /> </button> {% endblock %} </div> {% endblock %} {% block sw_search_bar_field %} <div v-if="isSearchBarShown" class="sw-search-bar__field" :class="searchBarFieldClasses" > {% block sw_search_bar_type %} <span class="sw-search-bar__type--v2" :style="{ 'background-color': getEntityIconColor(currentSearchType) }" role="button" tabindex="0" @click="onOpenModuleFiltersDropDown" @keydown.enter="onOpenModuleFiltersDropDown" > {{ getLabelSearchType() }} <mt-icon name="regular-chevron-down-xxs" /> </span> {% endblock %} {% block sw_search_bar_input %} <slot name="search-input"> {% block sw_search_bar_slot_input %} <input ref="searchInput" v-model="searchTerm" class="sw-search-bar__input" :placeholder="placeholderSearchInput" :aria-label="placeholderSearchInput" role="searchbox" @input="onSearchTermChange" @focus="onFocusInput" @blur="onBlur" @keydown.delete="resetSearchType" @keyup.esc="clearSearchTerm" @keyup.enter.prevent="onKeyUpEnter" @keydown.up.prevent="navigateUpResults" @keydown.down.prevent="navigateDownResults" > {% endblock %} </slot> {% endblock %} {% block sw_search_bar_icon %} <button class="sw-search-bar__field-icon sw-search-bar__field-close" @click="hideSearchBar" > <mt-icon name="regular-times-s" size="16px" /> </button> <span class="sw-search-bar__field-icon sw-search-bar__field-search-icon"> <mt-icon name="regular-search-s" size="16px" /> </span> {% endblock %} </div> {% endblock %} {% block sw_search_bar_results %} <div v-if="showResultsContainer" ref="resultsContainer" class="sw-search-bar__results sw-search-bar__results--v2" :class="{'is-empty-state': isResultEmpty()}" > {% block sw_search_bar_results_content %} <div class="sw-search-bar__results-wrapper-content"> {% block sw_search_bar_results_empty_state %} <sw-loader v-if="isLoading" /> {% endblock %} <template v-for="(entity, column) in results" v-else-if="!isResultEmpty()" :key="entity.entity" > {% block sw_search_bar_results_list %} <div class="sw-search-bar__results-column" > {% block sw_search_bar_results_list_column %} {% block sw_search_bar_results_list_column_header %} <div class="sw-search-bar__results-column-header"> {% block sw_search_bar_results_list_column_header_title %} <span class="sw-search-bar__types-header-entity" > {{ $tc(\`global.entities.\${entity.entity}\`, entity.total) }} </span> {% endblock %} </div> {% endblock %} {# "34" below is the <sw-search-bar-item />'s height #} <ul class="sw-search-bar__results-list" :style="{ minHeight: \`\${34 * entity.entities.length}px\` }" > <sw-search-bar-item v-for="(item, index) in entity.entities" :key="item.id" :item="item" :type="entity.entity" :search-term="searchTerm" :column="column" :index="index" :entity-icon-color="getEntityIconColor(entity.entity)" :entity-icon-name="getEntityIconName(entity.entity)" /> {% block sw_search_bar_results_list_bar_item %} <li v-if="entity.entity !== 'module'" class="sw-search-bar-item sw-search-bar-item--v2" > {% block sw_search_bar_results_list_bar_item_icon %} <mt-icon name="regular-double-chevron-right-s" color="rgb(179, 191, 204)" /> {% endblock %} {% block sw_search_bar_results_list_bar_item_more_results %} <sw-search-more-results :entity="entity.entity" :term="searchTerm" /> {% endblock %} </li> {% endblock %} </ul> {% endblock %} </div> {% endblock %} </template> {% block sw_search_bar_results_empty %} <div v-else class="sw-search-bar__results-empty-message sw-search-bar__results-empty-message--v2" > {% block sw_search_bar_results_empty_content %} {% block sw_search_bar_results_empty_text %} <div class="sw-search-bar__results-empty-text"> {{ $tc('global.sw-search-bar.messageNoResultsV2', { term: searchTerm }, 0) }} </div> {% endblock %} {% block sw_search_bar_results_empty_detail %} <div class="sw-search-bar__results-empty-detail"> {{ $tc('global.sw-search-bar.messageNoResultsDetailV2') }} </div> {% endblock %} {% endblock %} </div> {% endblock %} </div> {% endblock %} {% block sw_search_bar_results_footer %} <div v-if="showSearchTipForEsSearch" class="sw-search-bar__footer" > <p class="sw-search-bar__shortcut-tip" v-html="$tc('global.sw-search-bar.placeholderESSearchShortcutInfo')" ></p> </div> <div v-else class="sw-search-bar__footer" > <p class="sw-search-bar__shortcut-tip" v-html="$tc('global.sw-search-bar.placeholderSearchShortcutInfo')" ></p> <mt-icon name="regular-cog" class="sw-search-bar__footer-action-setting" color="var(--color-icon-primary-default)" size="var(--scale-size-16)" @click="toggleSearchPreferencesModal" /> </div> {% endblock %} </div> {% endblock %} {% block sw_search_bar_types_container %} <div v-if="showTypeSelectContainer" class="sw-search-bar__types_container--v2" > {% block sw_search_bar_types_container_header %} <div class="sw-search-bar__header" > <p class="sw-search-bar__header-title"> {{ $tc('global.sw-search-bar.moduleFiltersHeadline') }} </p> </div> {% endblock %} <div v-for="(type, index) in typeSelectResults" :key="index" class="sw-search-bar__type-item" :class="{ 'is--active': activeTypeListIndex === index }" role="row" tabindex="0" @mouseenter="onMouseEnterSearchType(index)" @click="onClickType(type.entityName)" > <span class="sw-search-bar__type-item-name" > <mt-icon class="sw-search-bar__type-item-icon" size="12px" :style="{ 'color': getEntityIconColor(type.entityName) }" :name="type.entityName ? getEntityIcon(type.entityName) : 'regular-circle'" /> {{ type.entityName ? getLabelSearchType(type.entityName) : $tc('global.sw-search-bar.searchTypeAll') }} </span> <p class="sw-search-bar__type--filter" > {{ $tc('global.sw-search-bar.moduleFilter') }} </p> </div> {% block sw_search_bar_types_container_empty %} <div v-if="typeSelectResults.length < 1" class="sw-search-bar__type-results-empty-message" > {% block sw_search_bar_types_container_empty_text %} {{ $tc('global.sw-search-bar.messageNoTypeResults') }} {% endblock %} </div> {% endblock %} {% block sw_search_bar_types_container_footer %} <div class="sw-search-bar__footer" > <p class="sw-search-bar__shortcut-tip" v-html="$tc('global.sw-search-bar.placeholderSearchShortcutInfo')" ></p> <mt-icon name="regular-cog" class="sw-search-bar__footer-action-setting" color="var(--color-icon-primary-default)" size="var(--scale-size-16)" @click="toggleSearchPreferencesModal" /> </div> {% endblock %} </div> {% endblock %} {% block sw_search_bar_types_module_filters_container %} <div v-if="showModuleFiltersContainer" class="sw-search-bar__types_module-filters-container sw-search-bar__types_container--v2" > <div v-for="(type, index) in typeSelectResults" :key="index" class="sw-search-bar__type-item" :class="{ 'is--active': activeTypeListIndex === index }" role="row" tabindex="0" @mouseenter="onMouseEnterSearchType(index)" @click="onClickType(type.entityName)" > <span class="sw-search-bar__type-item-name" > <mt-icon class="sw-search-bar__type-item-icon" size="14px" :style="{ 'color': getEntityIconColor(type.entityName) }" :name="type.entityName ? getEntityIcon(type.entityName) : 'regular-circle'" /> {{ type.entityName ? getLabelSearchType(type.entityName) : $tc('global.sw-search-bar.searchTypeAll') }} </span> </div> {% block sw_search_bar_types_module_filters_container_empty %} <div v-if="typeSelectResults.length < 1" class="sw-search-bar__type-results-empty-message" > {% block sw_search_bar_types_module_filters_container_empty_text %} {{ $tc('global.sw-search-bar.messageNoTypeResults') }} {% endblock %} </div> {% endblock %} {% block sw_search_bar_types_module_filters_container_footer %} <div class="sw-search-bar__footer"> <p class="sw-search-bar__shortcut-tip" v-html="$tc('global.sw-search-bar.placeholderFilterShortcutInfo')" ></p> </div> {% endblock %} </div> {% endblock %} {% block sw_search_bar_trends_results %} <div v-if="showResultsSearchTrends && !showResultsContainer" class="sw-search-bar__results sw-search-bar__results--v2" > {% block sw_search_bar_trends_results_content %} <div class="sw-search-bar__results-wrapper-content"> <template v-for="(entity, column) in resultsSearchTrends" :key="entity.entity" > {% block sw_search_bar_trends_results_list %} <div class="sw-search-bar__results-column" > {% block sw_search_bar_trends_results_list_column %} {% block sw_search_bar_trends_results_list_column_header %} <div class="sw-search-bar__results-column-header"> {% block sw_search_bar_trends_results_list_column_header_title %} <span class="sw-search-bar__types-header-entity"> {{ $tc(\`global.entities.\${entity.entity}\`, entity.total) }} </span> {% endblock %} </div> {% endblock %} <ul class="sw-search-bar__results-list"> <sw-search-bar-item v-for="(item, index) in entity.entities" :key="index" :item="entity.entity === 'frequently_used' ? item : item.item" :type="entity.entity === 'frequently_used' ? entity.entity : item.entity" :search-term="searchTerm" :column="column" :index="index" :entity-icon-color="getEntityIconColor(item.entity)" :entity-icon-name="getEntityIconName(item.entity)" /> </ul> {% endblock %} </div> {% endblock %} </template> </div> {% endblock %} {% block sw_search_bar_trends_results_empty_content %}{% endblock %} {% block sw_search_bar_trends_results_footer %} <div class="sw-search-bar__footer"> <p class="sw-search-bar__shortcut-tip" v-html="$tc('global.sw-search-bar.placeholderSearchShortcutInfo')" ></p> <mt-icon name="regular-cog" class="sw-search-bar__footer-action-setting" color="var(--color-icon-primary-default)" size="var(--scale-size-16)" @click="toggleSearchPreferencesModal" /> </div> {% endblock %} </div> {% endblock %} </div> {% endblock %} {% block sw_search_bar_search_preferences_modal %} <sw-search-preferences-modal v-if="showSearchPreferencesModal" @modal-close="toggleSearchPreferencesModal" /> {% endblock %} </div> {% endblock %}`,{Application:_,Context:y}=Shopware,{Criteria:u}=Shopware.Data,d=Shopware.Utils,{cloneDeep:C}=d.object,R={template:k,inject:["searchService","searchTypeService","repositoryFactory","acl","feature","searchRankingService","userActivityApiService","recentlySearchService"],provide(){return{searchBarOnMouseOver:this.onMouseOver,searchBarRegisterActiveItemIndexSelectHandler:this.registerActiveItemIndexSelectHandler,searchBarUnregisterActiveItemIndexSelectHandler:this.unregisterActiveItemIndexSelectHandler,searchBarRegisterKeyupEnterHandler:this.registerKeyupEnterHandler,searchBarUnregisterKeyupEnterHandler:this.unregisterKeyupEnterHandler}},emits:["search","active-item-index-select","keyup-enter"],shortcuts:{f:"setFocus"},props:{initialSearchType:{type:String,required:!1,default:""},typeSearchAlwaysInContainer:{type:Boolean,required:!1,default:y.app.adminEsEnable??!1},placeholder:{type:String,required:!1,default:""},initialSearch:{type:String,required:!1,default:""},entitySearchColor:{type:String,required:!1,default:""}},data(){return{currentSearchType:this.initialSearchType,showResultsContainer:!1,showModuleFiltersContainer:!1,searchTerm:this.initialSearch,results:[],isActive:!1,isOffCanvasShown:!1,isSearchBarShown:!1,activeResultIndex:0,activeResultColumn:0,activeTypeListIndex:0,isLoading:!1,searchTypes:null,showTypeSelectContainer:!1,typeSelectResults:[],salesChannelTypes:[],moduleFactory:_.getContainer("factory").module||{},showResultsSearchTrends:!1,resultsSearchTrends:[],showSearchPreferencesModal:!1,searchLimit:10,userSearchPreference:null,isComponentMounted:!0,activeItemIndexSelectHandler:[],keyupEnterHandler:[]}},computed:{searchBarFieldClasses(){return{"is--active":this.isActive}},placeholderSearchInput(){let e=this.$tc("global.sw-search-bar.placeholderSearchField");return this.currentSearchType&&(this.placeholder!==""?e=this.placeholder:Object.keys(this.searchTypes).includes(this.currentSearchType)&&(e=this.$tc(this.searchTypes[this.currentSearchType].placeholderSnippet))),e},salesChannelRepository(){return this.repositoryFactory.create("sales_channel")},salesChannelTypeRepository(){return this.repositoryFactory.create("sales_channel_type")},salesChannelCriteria(){const e=new u(1,25);return e.addAssociation("type"),e},canCreateSalesChannels(){return this.acl.can("sales_channel.creator")},moduleRegistry(){return this.moduleFactory.getModuleRegistry()},searchableModules(){const e=[];return this.moduleRegistry.forEach(t=>{var i,a,r,c;const s=(r=(a=(i=t.manifest.routes)==null?void 0:i.index)==null?void 0:a.meta)==null?void 0:r.privilege;!((c=t.manifest)!=null&&c.title)||s&&!this.acl.can(s)||e.push(t)}),e.sort((t,s)=>{var i;return(i=t.manifest.name)==null?void 0:i.localeCompare(s.manifest.name)}),e},criteriaCollection(){return{product:new u(1,this.searchLimit+1).addAssociation("options.group")}},currentUser(){return Shopware.Store.get("session").currentUser},showSearchTipForEsSearch(){return this.adminEsEnable?this.searchTerm.match(/^[\w]+\s/):!1},adminEsEnable(){return y.app.adminEsEnable??!1}},watch:{$route(e){this.isComponentMounted===!0&&e.query.term===void 0&&this.initialSearchType&&(this.currentSearchType=this.initialSearchType),!this.isActive&&(this.searchTerm=e.query.term?e.query.term:"")},"$route.name":{handler(e,t){t===void 0||e===t||(this.resultsSearchTrends=[])},immediate:!0}},created(){this.createdComponent()},unmounted(){this.destroyedComponent()},methods:{async createdComponent(){const e=this;this.showSearchFieldOnLargerViewports(),this.$device.onResize({listener(){e.showSearchFieldOnLargerViewports()},component:this}),this.$route.query.term&&(this.searchTerm=this.$route.query.term),this.searchTypes=this.searchTypeService.getTypes(),this.typeSelectResults=Object.values(this.searchTypes).filter(t=>!t.hideOnGlobalSearchBar),this.registerListener(),this.userSearchPreference=await this.searchRankingService.getUserSearchPreference(),this.canCreateSalesChannels&&await this.loadSalesChannelType()},destroyedComponent(){document.removeEventListener("click",this.closeOnClickOutside)},registerListener(){document.addEventListener("click",this.closeOnClickOutside)},onMouseOver(e,t){this.setActiveResultPosition({index:e,column:t})},registerActiveItemIndexSelectHandler(e){this.activeItemIndexSelectHandler.push(e)},unregisterActiveItemIndexSelectHandler(e){this.activeItemIndexSelectHandler=this.activeItemIndexSelectHandler.filter(t=>t!==e)},registerKeyupEnterHandler(e){this.keyupEnterHandler.push(e)},unregisterKeyupEnterHandler(e){this.keyupEnterHandler=this.keyupEnterHandler.filter(t=>t!==e)},getLabelSearchType(e){if(!e&&!this.currentSearchType&&(e="all"),!e&&this.currentSearchType&&(e=this.currentSearchType),e.startsWith("custom_entity_")||e.startsWith("ce_")){const t=`${e}.moduleTitle`;return this.$te(t)?this.$tc(t):e}return this.$te(`global.entities.${e}`)?this.$tc(`global.entities.${e}`,2):this.currentSearchType},setFocus(){this.$refs.searchInput.focus()},closeOnClickOutside(e){e.target.closest(".sw-search-bar")||(this.clearSearchTerm(),this.showTypeSelectContainer=!1,this.showModuleFiltersContainer=!1)},clearSearchTerm(){this.showResultsContainer=!1,this.showResultsSearchTrends=!1,this.activeResultPosition=0},onFocusInput(){var e;if(this.isActive=!0,this.searchTerm==="#"&&this.showTypeContainer(),(e=this.resultsSearchTrends)!=null&&e.length){this.showModuleFiltersContainer=!1,this.showResultsSearchTrends=!0;return}this.loadSearchTrends().then(t=>{this.resultsSearchTrends=t,this.showResultsSearchTrends=!!(t!=null&&t.length)})},onBlur(){this.isActive=!1},showSearchBar(){this.isSearchBarShown=!0,this.isActive=!0,this.isOffCanvasShown=!1,Shopware.Utils.EventBus.emit("sw-admin-menu/toggle-offcanvas",this.isOffCanvasShown)},hideSearchBar(){this.isSearchBarShown=!1,this.isActive=!1,this.showResultsContainer=!1},showSearchFieldOnLargerViewports(){this.$device.getViewportWidth()>500&&(this.isSearchBarShown=!0)},onSearchTermChange(){const e=this.searchTerm.match(/^#(.*)/);if(e!==null){this.showTypeContainer(),this.filterTypeSelectResults(e[1]);return}if(!(this.searchTerm.trim().length>155)){if(this.showTypeSelectContainer=!1,this.showResultsSearchTrends=!1,this.typeSearchAlwaysInContainer&&this.currentSearchType&&this.searchTypes[this.currentSearchType]){this.doListSearchWithContainer();return}if(!this.initialSearchType&&this.currentSearchType){this.doListSearchWithContainer();return}if(this.initialSearchType&&this.currentSearchType&&this.initialSearchType!==this.currentSearchType){this.doListSearchWithContainer();return}if(this.currentSearchType){this.doListSearch();return}this.doGlobalSearch()}},showTypeContainer(){this.showTypeSelectContainer=!0,this.showModuleFiltersContainer=!1,this.showResultsContainer=!1,this.showResultsSearchTrends=!1,this.activeTypeListIndex=0},filterTypeSelectResults(e){this.typeSelectResults=[],Object.keys(this.searchTypes).forEach(t=>{(this.$tc(`global.entities.${this.searchTypes[t].entityName}`,2).toLowerCase().includes(e.toLowerCase())||e==="")&&this.typeSelectResults.push(this.searchTypes[t])})},onClickType(e){this.setSearchType(e),this.$refs.searchInput.focus()},setSearchType(e){this.currentSearchType=e,this.showTypeSelectContainer=!1,this.showModuleFiltersContainer=!1,this.showResultsSearchTrends=!1,this.searchTerm=""},toggleOffCanvas(){this.isOffCanvasShown=!this.isOffCanvasShown,Shopware.Utils.EventBus.emit("sw-admin-menu/toggle-offcanvas",this.isOffCanvasShown)},resetSearchType(){this.searchTerm.length===0&&(this.isComponentMounted=!1,this.currentSearchType=null)},doListSearch:d.debounce(function(){const t=this.searchTerm.trim();this.$emit("search",t)},750),doListSearchWithContainer:d.debounce(function(){const t=this.searchTerm.trim();t&&t.length>0?this.loadTypeSearchResults(t):this.showResultsContainer=!1},y.app.adminEsEnable?30:750),doGlobalSearch:d.debounce(function(){const t=this.searchTerm.trim();t&&t.length>0?this.loadResults(t):(this.showResultsContainer=!1,this.showResultsSearchTrends=!1)},y.app.adminEsEnable?30:750),async loadResults(e){this.isLoading=!0,this.results=[];const t=this.getModuleEntities(e);if(t!=null&&t.length&&this.results.unshift({entity:"module",total:t.length,entities:t}),!this.userSearchPreference||Object.keys(this.userSearchPreference).length<1){this.activeResultColumn=0,this.activeResultIndex=0,this.isLoading=!1,this.showTypeSelectContainer||(this.showResultsContainer=!0);return}let s;if(this.adminEsEnable){const a=[];Object.keys(this.userSearchPreference).forEach(r=>{d.types.isEmpty(this.userSearchPreference[r])||a.push(r)}),s=await this.searchService.elastic(e,a,this.searchLimit+1,{"sw-inheritance":!0})}else{const a=this.searchRankingService.buildGlobalSearchQueries(this.userSearchPreference,e,this.criteriaCollection,this.searchLimit+1,0);s=await this.searchService.searchQuery(a,{"sw-inheritance":!0})}const i=s.data;i&&(Object.keys(i).forEach(a=>{if(i[a].total>0){const r=i[a];r.entities=Object.values(r.data).slice(0,this.searchLimit),r.entity=a,this.results=this.results.filter(c=>a!==c.entity),this.results=[...this.results,r]}}),this.activeResultColumn=0,this.activeResultIndex=0,this.isLoading=!1,this.showTypeSelectContainer||(this.showResultsContainer=!0))},async loadTypeSearchResults(e){var i;if((i=this.searchTypes[this.currentSearchType])!=null&&i.entityService){this.loadTypeSearchResultsByService(e);return}this.isLoading=!0,this.results=[];const t={entity:this.currentSearchType,total:0},s=this.searchTypes[this.currentSearchType].entityName;if(this.adminEsEnable){const a=await this.searchService.elastic(e,[s],this.searchLimit+1,{"sw-inheritance":!0}),r=(a==null?void 0:a.data[this.currentSearchType])??{total:0,data:{}};t.total=r.total,t.entities=Object.values(r.data).slice(0,this.searchLimit)}else{const a=this.repositoryFactory.create(s);let r=this.criteriaCollection.hasOwnProperty(s)?this.criteriaCollection[s]:new u(1,this.searchLimit+1);r.setTerm(e),r.setLimit(this.searchLimit+1),r.setTotalCountMode(0);const c=await this.searchRankingService.getSearchFieldsByEntity(s);if(!c||Object.keys(c).length<1){t.total=0,this.results.push(t),this.isLoading=!1,this.showTypeSelectContainer||(this.showResultsContainer=!0);return}r=this.searchRankingService.buildSearchQueriesForEntity(c,e,r);const n=await a.search(r,{...Shopware.Context.api,inheritance:!0});t.total=n.total,t.entities=n.slice(0,this.searchLimit)}t.total>0&&(this.results=this.results.filter(a=>this.currentSearchType!==a.entity),this.results=[...this.results,t]),this.isLoading=!1,this.showTypeSelectContainer||(this.showResultsContainer=!0)},loadTypeSearchResultsByService(e){this.isLoading=!0;const t={limit:25,term:e};this.results=[];const s={},i=this.searchTypes[this.currentSearchType].entityService;if(!_.getContainer("factory").apiService.has(i))throw new Error(`sw-search-bar - Api service ${i} not found`);_.getContainer("factory").apiService.getByName(i).getList(t).then(r=>{s.total=r.meta.total,s.entity=this.currentSearchType,s.entities=r.data,this.results.push(s),this.isLoading=!1}),this.showTypeSelectContainer||(this.showResultsContainer=!0)},setActiveResultPosition({index:e,column:t}){this.activeResultIndex=e,this.activeResultColumn=t,this.emitActiveResultPosition()},emitActiveResultPosition(){this.$emit("active-item-index-select",{index:this.activeResultIndex,column:this.activeResultColumn}),this.activeItemIndexSelectHandler.forEach(e=>e({index:this.activeResultIndex,column:this.activeResultColumn}))},navigateUpResults(){if(this.showTypeSelectContainer&&this.activeTypeListIndex!==0&&(this.activeTypeListIndex-=1),!!this.showResultsContainer){if(this.activeResultIndex===0){if(this.activeResultColumn>0){this.activeResultColumn-=1;const e=Object.keys(this.results[this.activeResultColumn].entities).length;this.activeResultIndex=e-1}}else this.activeResultIndex-=1;this.setActiveResultPosition({index:this.activeResultIndex,column:this.activeResultColumn}),this.checkScrollPosition()}},navigateDownResults(){if(this.showTypeSelectContainer&&this.activeTypeListIndex!==this.typeSelectResults.length-1&&(this.activeTypeListIndex+=1),!this.showResultsContainer)return;const e=this.results[this.activeResultColumn].entities.length;if(this.activeResultIndex===e-1||e<1){if(this.activeResultColumn<this.results.length-1)if(this.results[this.activeResultColumn+1])this.activeResultColumn+=1,this.activeResultIndex=0;else return}else this.activeResultIndex+=1;this.setActiveResultPosition({index:this.activeResultIndex,column:this.activeResultColumn}),this.checkScrollPosition()},checkScrollPosition(){this.$nextTick(()=>{const e=this.$refs.resultsContainer,t=e.querySelector(".is--active"),s=e.querySelector(".sw-search-bar-item").offsetHeight,i=e.offsetHeight,a=t.offsetTop+s;a+s*2>i+e.scrollTop?e.scrollTop=a+s*2-i:a-s*3<e.scrollTop&&(e.scrollTop=a-s*3)})},onKeyUpEnter(){this.$emit("keyup-enter",this.activeResultIndex,this.activeResultColumn),this.keyupEnterHandler.forEach(e=>e(this.activeResultIndex,this.activeResultColumn)),this.showTypeSelectContainer&&this.typeSelectResults.length>0&&this.setSearchType(this.typeSelectResults[this.activeTypeListIndex].entityName)},getSearchTypeProperty(e,t){return!this.searchTypes[e]||!this.searchTypes[e].hasOwnProperty(t)?"":this.searchTypes[e][t]},getEntityIconName(e){var s;const t=this.moduleFactory.getModuleByEntityName(e);return((s=t==null?void 0:t.manifest)==null?void 0:s.icon)??"regular-books"},getEntityIconColor(e){if(this.entitySearchColor!=="")return this.entitySearchColor;const t=this.moduleFactory.getModuleByEntityName(e);return t&&t.manifest.color||"#5C738A"},getEntityIcon(e){var s;const t=this.moduleFactory.getModuleByEntityName(e);return((s=t==null?void 0:t.manifest)==null?void 0:s.icon)??"regular-books"},isResultEmpty(){return!this.results.some(e=>e.total!==0)},onMouseEnterSearchType(e){this.activeTypeListIndex=e},onOpenModuleFiltersDropDown(){this.isActive=!0,this.showModuleFiltersContainer=!0,this.showTypeSelectContainer=!1,this.showResultsSearchTrends=!1},loadSalesChannelType(){return new Promise(e=>{this.salesChannelTypeRepository.search(new u(1,25)).then(t=>{this.salesChannelTypes=t,e(t)})})},getModuleEntities(e,t=5){const i=new RegExp(`^${e.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&").toLowerCase()}(.*)`);if(!e||e.length<3)return[];let a=[];return this.searchableModules.forEach(r=>{const c=typeof r.manifest.searchMatcher=="function"?r.manifest.searchMatcher:this.getDefaultMatchSearchableModules,n=this.$te(`${r.manifest.title}`)&&this.$tc(`${r.manifest.title}`,2);if(!n)return;const l=c(i,n,r.manifest);!l||l.length===0||a.push(...l.filter(o=>!o.privilege||this.acl.can(o.privilege)))}),a.push(...this.getSalesChannelTypesBySearchTerm(i)),a=a.filter(r=>r==null?void 0:r.entity),a.slice(0,t)},getDefaultMatchSearchableModules(e,t,s){var m,b,f,w,S,v,g,T;const i=t.toLowerCase().match(e),a=`${this.$tc("global.sw-search-bar.addNew")} ${t}`.toLowerCase().match(e);if(!i&&!a||!((m=s==null?void 0:s.routes)!=null&&m.index)&&!((b=s==null?void 0:s.routes)!=null&&b.list))return!1;const r=((f=s==null?void 0:s.routes)==null?void 0:f.index)||((w=s==null?void 0:s.routes)==null?void 0:w.list),{name:c,icon:n,color:l,entity:o,routes:h}=s,p=[];return i&&h.index&&p.push({name:c,icon:n,color:l,label:t,entity:o,route:r,privilege:(v=(S=h.index)==null?void 0:S.meta)==null?void 0:v.privilege}),h.create&&p.push({name:c,icon:n,color:l,entity:o,route:h.create,privilege:(T=(g=h.create)==null?void 0:g.meta)==null?void 0:T.privilege,action:!0}),p},getSalesChannelTypesBySearchTerm(e){return this.salesChannelTypes.reduce((t,s)=>s!=null&&s.translated.name.toLowerCase().match(e)?[{name:"sales-channel",icon:(s==null?void 0:s.iconName)??"regular-server",color:"#14D7A5",entity:"sales_channel",label:s==null?void 0:s.translated.name,route:{name:"sw.sales.channel.create",params:{typeId:s.id}},action:!0}]:t,[])},toggleSearchPreferencesModal(){this.showSearchPreferencesModal=!this.showSearchPreferencesModal,this.searchTerm=null,this.showResultsContainer=!1,this.showTypeSelectContainer=!1,this.showResultsSearchTrends=!1},loadSearchTrends(){return Promise.all([this.getFrequentlyUsedModules(),this.getRecentlySearch()]).then(e=>e.filter(t=>t==null?void 0:t.total))},async getFrequentlyUsedModules(e=!0){try{const t=await this.userActivityApiService.getIncrement({cluster:this.currentUser.id}),i=Object.keys(t||{}).map(c=>({key:c,info:this.getInfoModuleFrequentlyUsed(c)})),a=e?i.filter(c=>Object.keys(c.info).length===0).map(c=>c.key):[],r=i.filter(c=>Object.keys(c.info).length>0).map(c=>c.info);if(a.length>0)try{return await this.userActivityApiService.deleteActivityKeys({keys:a,cluster:this.currentUser.id}),await this.getFrequentlyUsedModules(!1)}catch{return{entity:"frequently_used",total:r.length,entities:r}}return{entity:"frequently_used",total:r.length,entities:r}}catch{return{entity:"frequently_used",total:0,entities:[]}}},getRecentlySearch(){return new Promise(e=>{const t=this.recentlySearchService.get(this.currentUser.id),s={};if(t.forEach(i=>{if(!this.acl.can(`${i.entity}:read`))return;s.hasOwnProperty(i.entity)||(s[i.entity]=this.criteriaCollection.hasOwnProperty(i.entity)?C(this.criteriaCollection[i.entity]):new u(1,25));const a=[i.id,...s[i.entity].ids];s[i.entity].setIds(a)}),Object.keys(s).length===0){e();return}this.searchService.searchQuery(s,{"sw-inheritance":!0}).then(i=>{if(!i.data){e();return}const a=[];t.forEach(r=>{const n=(i.data[r.entity]?i.data[r.entity].data:{})[r.id];n&&a.push({item:n,entity:r.entity})}),e({entity:"recently_searched",total:a.length,entities:a})})})},getInfoModuleFrequentlyUsed(e){var n;const[t,s]=e.split("@"),i=this.moduleFactory.getModuleByKey("name",t);if(!i)return null;const{routes:a,...r}=i.manifest;if(typeof r.searchMatcher=="function")return r.searchMatcher(new RegExp(`^${this.$tc(r.title).toLowerCase()}(.*)`),this.$tc(r.title,2),i.manifest).find(o=>o.route.name===s);const c=Object.values(a).find(l=>l.name===s);return{...r,route:c,privilege:(n=c==null?void 0:c.meta)==null?void 0:n.privilege,action:c.routeKey==="create"}}}};export{R as default};
