const i=`{% block sw_manufacturer_detail %} <sw-page class="sw-manufacturer-detail"> {% block sw_manufacturer_detail_header %} <template #smart-bar-header> <h2>{{ placeholder(manufacturer, 'name', $tc('sw-manufacturer.detail.textHeadline')) }}</h2> </template> {% endblock %} {% block sw_manufacturer_detail_actions %} <template #smart-bar-actions> {% block sw_manufacturer_detail_actions_abort %} <mt-button v-tooltip.bottom="tooltipCancel" :disabled="manufacturerIsLoading || undefined" variant="secondary" size="default" @click="onCancel" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_manufacturer_detail_actions_save %} <sw-button-process v-model:process-success="isSaveSuccessful" v-tooltip.bottom="tooltipSave" class="sw-manufacturer-detail__save-action" :is-loading="isLoading" :disabled="isLoading || !acl.can('product_manufacturer.editor') || undefined" variant="primary" @click.prevent="onSave" > {{ $tc('sw-manufacturer.detail.buttonSave') }} </sw-button-process> {% endblock %} </template> {% endblock %} {% block sw_manufacturer_detail_language_switch %} <template #language-switch> <sw-language-switch :disabled="manufacturerId == null || undefined" :save-changes-function="saveOnLanguageChange" :abort-change-function="abortOnLanguageChange" @on-change="onChangeLanguage" /> </template> {% endblock %} {% block sw_manufacturer_detail_content %} <template #content> <sw-card-view> <template v-if="manufacturerIsLoading"> <sw-skeleton variant="detail-bold" /> <sw-skeleton /> </template> <template v-else> {% block sw_manufacturer_detail_content_language_info %} <sw-language-info :entity-description="placeholder(manufacturer, 'name', $tc('sw-manufacturer.detail.textHeadline'))" /> {% endblock %} {% block sw_manufacturer_detail_base_basic_info_card %} <mt-card position-identifier="sw-manufacturer-detail-basic-info" :title="$tc('sw-manufacturer.detail.cardTitleManufacturerInfo')" > <sw-container class="sw-manufacturer-detail__container" columns="repeat(auto-fit, minmax(250px, 1fr))" gap="0 30px" > <div class="sw-manufacturer-detail__base-info-wrapper"> {% block sw_manufacturer_detail_base_info_field_name %} <mt-text-field v-model="manufacturer.name" :label="$tc('sw-manufacturer.detail.labelName')" :placeholder="placeholder(manufacturer, 'name', $tc('sw-manufacturer.detail.placeholderName'))" name="name" validation="required" required :error="manufacturerNameError" :disabled="!acl.can('product_manufacturer.editor') || undefined" /> {% endblock %} {% block sw_manufacturer_detail_base_info_field_link %} <mt-text-field v-model="manufacturer.link" :label="$tc('sw-manufacturer.detail.labelLink')" :placeholder="$tc('sw-manufacturer.detail.placeholderLink')" name="link" :disabled="!acl.can('product_manufacturer.editor') || undefined" /> {% endblock %} </div> {% block sw_manufacturer_detail_logo_upload %} <sw-upload-listener :upload-tag="mediaUploadTag" auto-upload @media-upload-finish="setMediaItem" /> <sw-media-upload-v2 class="sw-manufacturer-detail__logo-upload" :source="manufacturer.mediaId" :allow-multi-select="false" variant="regular" :upload-tag="mediaUploadTag" :label="$tc('sw-manufacturer.detail.labelLogo')" :default-folder="manufacturerRepository.entityName" :disabled="!acl.can('product_manufacturer.editor') || undefined" @sw-media-upload-v2-media-upload-success="setMediaItem" @media-drop="onDropMedia" @media-upload-sidebar-open="showMediaModal = true" @media-upload-remove-image="onUnlinkLogo" /> <sw-media-modal-v2 v-if="showMediaModal" :allow-multi-select="false" :initial-folder-id="mediaDefaultFolderId" :entity-context="manufacturer.getEntityName()" @modal-close="showMediaModal = false" @media-modal-selection-change="onMediaSelectionChange" /> {% endblock %} </sw-container> {% block sw_manufacturer_detail_base_info_field_description %} <sw-text-editor v-model:value="manufacturer.description" :label="$tc('sw-manufacturer.detail.labelDescription')" :placeholder="placeholder(manufacturer, 'description', $tc('sw-manufacturer.detail.placeholderDescription'))" name="description" sanitize-input sanitize-field-name="product_manufacturer_translation.description" :disabled="!acl.can('product_manufacturer.editor') || undefined" /> {% endblock %} </mt-card> {% endblock %} {% block sw_manufacturer_detail_custom_field_sets %} <mt-card v-if="customFieldSets.length > 0" position-identifier="sw-manufacturer-detail-custom-field-sets" :title="$tc('sw-settings-custom-field.general.mainMenuItemGeneral')" :is-loading="manufacturerIsLoading" > <sw-custom-field-set-renderer v-if="manufacturer" :entity="manufacturer" :sets="customFieldSets" :disabled="!acl.can('product_manufacturer.editor') || undefined" /> </mt-card> {% endblock %} </template> </sw-card-view> </template> {% endblock %} {# @deprecated tag:v6.8.0 - Will be removed without replacement #} {% block sw_manufacturer_detail_sidebar %} {% endblock %} </sw-page> {% endblock %}`,{Mixin:t,Data:{Criteria:r}}=Shopware,{mapPropertyErrors:n}=Shopware.Component.getComponentHelper(),o={template:i,inject:["repositoryFactory","acl","mediaDefaultFolderService"],mixins:[t.getByName("placeholder"),t.getByName("notification"),t.getByName("discard-detail-page-changes")("manufacturer")],shortcuts:{"SYSTEMKEY+S":"onSave",ESCAPE:"onCancel"},props:{manufacturerId:{type:String,required:!1,default:null}},data(){return{manufacturer:null,customFieldSets:[],isLoading:!1,isSaveSuccessful:!1,showMediaModal:!1,mediaDefaultFolderId:null}},metaInfo(){return{title:this.$createTitle(this.identifier)}},computed:{identifier(){return this.placeholder(this.manufacturer,"name")},manufacturerIsLoading(){return this.isLoading||this.manufacturer==null},manufacturerRepository(){return this.repositoryFactory.create("product_manufacturer")},mediaRepository(){return this.repositoryFactory.create("media")},customFieldSetRepository(){return this.repositoryFactory.create("custom_field_set")},customFieldSetCriteria(){const e=new r(1,null);return e.addFilter(r.equals("relations.entityName","product_manufacturer")),e},mediaUploadTag(){return`sw-manufacturer-detail--${this.manufacturer.id}`},tooltipSave(){return this.acl.can("product_manufacturer.editor")?{message:`${this.$device.getSystemKey()} + S`,appearance:"light"}:{showDelay:300,message:this.$tc("sw-privileges.tooltip.warning"),disabled:this.acl.can("order.editor"),showOnDisabledElements:!0}},tooltipCancel(){return{message:"ESC",appearance:"light"}},...n("manufacturer",["name"])},watch:{manufacturerId(){this.createdComponent()}},created(){this.createdComponent()},methods:{createdComponent(){if(Shopware.ExtensionAPI.publishData({id:"sw-manufacturer-detail__manufacturer",path:"manufacturer",scope:this}),this.manufacturerId){this.loadEntityData();return}Shopware.Store.get("context").resetLanguageToDefault(),this.manufacturer=this.manufacturerRepository.create()},async loadEntityData(){this.isLoading=!0;const[e,a]=await Promise.allSettled([this.manufacturerRepository.get(this.manufacturerId),this.customFieldSetRepository.search(this.customFieldSetCriteria),this.getMediaDefaultFolderId()]);e.status==="fulfilled"&&(this.manufacturer=e.value),a.status==="fulfilled"&&(this.customFieldSets=a.value),(e.status==="rejected"||a.status==="rejected")&&this.createNotificationError({message:this.$tc("global.notification.notificationLoadingDataErrorMessage")}),this.isLoading=!1},abortOnLanguageChange(){return this.manufacturerRepository.hasChanges(this.manufacturer)},saveOnLanguageChange(){return this.onSave()},onChangeLanguage(){this.loadEntityData()},setMediaItem({targetId:e}){this.manufacturer.mediaId=e},setMediaFromSidebar(e){this.manufacturer.mediaId=e.id},onUnlinkLogo(){this.manufacturer.mediaId=null},openMediaSidebar(){this.$refs.mediaSidebarItem.openContent()},onDropMedia(e){this.setMediaItem({targetId:e.id})},onMediaSelectionChange([e]){this.manufacturer.mediaId=e.id},getMediaDefaultFolderId(){this.mediaDefaultFolderService.getDefaultFolderId("product_manufacturer").then(e=>{this.mediaDefaultFolderId=e})},onSave(){this.acl.can("product_manufacturer.editor")&&(this.isLoading=!0,this.manufacturerRepository.save(this.manufacturer).then(()=>{if(this.isLoading=!1,this.isSaveSuccessful=!0,this.manufacturerId===null){this.$router.push({name:"sw.manufacturer.detail",params:{id:this.manufacturer.id}});return}this.loadEntityData()}).catch(e=>{throw this.isLoading=!1,this.createNotificationError({message:this.$tc("global.notification.notificationSaveErrorMessageRequiredFieldsInvalid")}),e}))},onCancel(){this.$router.push({name:"sw.manufacturer.index"})}}};export{o as default};
