const r=`{% block sw_order_create_address_modal %} <sw-modal :title="editAddressModalTitle" class="sw-order-create-address-modal" @modal-close="onCancel" > {% block sw_order_create_address_modal_content %} {% block sw_order_create_address_form_modal %} <sw-modal v-if="showAddressFormModal" :title="getAddressFormModalTitle()" @modal-close="onCloseAddressModal" > {% block sw_order_create_address_form_modal_content %} <sw-customer-address-form :address="currentAddress" :customer="activeCustomer" :disabled="isLoading" > <sw-customer-address-form-options :address="currentAddress" :customer="activeCustomer" :custom-field-sets="[]" @default-address-change="onChangeDefaultAddress" /> </sw-customer-address-form> {% endblock %} {% block sw_order_create_address_form_modal_footer %} <template #modal-footer> {% block sw_order_create_address_form_modal_cancel_button %} <mt-button size="small" variant="secondary" @click="onCloseAddressModal" > {{ $tc('global.default.cancel') }} </mt-button> {% endblock %} {% block sw_order_create_address_form_modal_apply_button %} <mt-button :is-loading="isLoading" variant="primary" size="small" @click="onSubmitAddressForm" > {{ $tc('sw-customer.detailAddresses.buttonSaveAndSelect') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %} <mt-card :is-loading="isLoading" :large="true" position-identifier="sw-order-create-address-modal" class="sw-order-create-address-modal__card-filter" > {% block sw_order_create_address_modal_toolbar %} <template #toolbar> <sw-card-filter :placeholder="$tc('sw-order.addressSelection.searchAddressToolbarPlaceholder')" @sw-card-filter-term-change="onSearchAddress" > {% block sw_order_create_address_modal_add_button %} <template #filter> <mt-button class="sw-order-create-address-modal__add-btn" size="small" variant="secondary" @click="onAddNewAddress" > <mt-icon name="regular-plus-circle-s" size="16px" /> {{ $tc('sw-customer.detailAddresses.buttonAddAddress') }} </mt-button> </template> {% endblock %} </sw-card-filter> </template> {% endblock %} {% block sw_order_create_address_modal_empty_state %} <template #grid> <div v-if="!isLoading && !addresses.length" class="sw-order-create-address-modal__card is--empty" > <sw-empty-state :title="$tc('sw-order.addressSelection.emptySearchResults')" :icon="'regular-book-user'" > {% block sw_order_create_address_modal_empty_state_content %} <span></span> {% endblock %} </sw-empty-state> </div> <div v-for="(address, index) in addresses" :key="address.id" :class="{ 'is--selected': isCurrentSelected(address.id)}" class="sw-order-create-address-modal__card" > <div class="sw-order-create-address-modal__card-body"> <span v-if="isCurrentSelected(address.id)" class="sw-order-create-address-modal__card-label" > {{ $tc('sw-order.addressSelection.currentlySelected') }}<br><br> </span> <sw-address :address="address" /> <a class="sw-order-create-address-modal__edit-btn" role="button" tabindex="0" @click="onEditAddress(address)" @keydown.enter="onEditAddress(address)" > {{ $tc('sw-customer.detailBase.buttonTitleEditAddress') }} </a> </div> <div class="sw-order-create-address-modal__select-btn"> <mt-button v-if="!isCurrentSelected(address.id)" variant="secondary" @click="onSelectExistingAddress(address)" > {{ $tc('sw-customer.detailAddresses.buttonSelect') }} </mt-button> </div> </div> </template> {% endblock %} </mt-card> {% endblock %} {% block sw_order_create_address_modal_actions %} <template #modal-footer> {% block sw_order_create_address_modal_cancel_button %} <mt-button size="small" variant="secondary" @click="onCancel" > {{ $tc('sw-customer.detailAddresses.buttonClose') }} </mt-button> {% endblock %} </template> {% endblock %} </sw-modal> {% endblock %}`,{Mixin:t,Store:a,Service:d}=Shopware,{Criteria:o}=Shopware.Data,i={template:r,emits:["set-customer-address","close-modal"],mixins:[t.getByName("notification"),t.getByName("placeholder")],props:{customer:{type:Object,required:!0},address:{type:Object,required:!0},addAddressModalTitle:{type:String,required:!0},editAddressModalTitle:{type:String,required:!0},cart:{type:Object,required:!0}},data(){return{addresses:[],selectedAddressId:null,activeCustomer:this.customer,isLoading:!1,term:null,showAddressFormModal:!1,defaultAddressIdMapping:{"billing-address":"defaultBillingAddressId","shipping-address":"defaultShippingAddressId"},currentAddress:null}},computed:{addressCriteria(){const e=new o(1,25);return e.addAssociation("salutation"),e.addAssociation("country"),e.addAssociation("countryState"),this.term&&e.setTerm(this.term),e},customerRepository(){return d("repositoryFactory").create("customer")},addressRepository(){return d("repositoryFactory").create(this.activeCustomer.addresses.entity,this.activeCustomer.addresses.source)},isValidCompanyField(){var e;return this.customer.company!==null&&!!((e=this.currentAddress.company)!=null&&e.trim().length)}},created(){this.createdComponent()},methods:{async createdComponent(){await this.getCustomerAddresses()},async getCustomerAddresses(){this.isLoading=!0;try{this.addresses=await this.addressRepository.search(this.addressCriteria),this.selectedAddressId=this.activeCustomer[this.address.contextId]||this.activeCustomer[this.address.contextDataDefaultId],await Shopware.Store.get("error").resetApiErrors()}catch{this.createNotificationError({message:this.$tc("sw-order.create.messageFetchCustomerAddressesError")})}finally{this.isLoading=!1}},onNewActiveItem(){this.selectedAddressId=null},isCurrentSelected(e){return this.selectedAddressId===e},async onSearchAddress(e){this.term=e,await this.getCustomerAddresses()},async onSelectExistingAddress(e){this.selectedAddressId=e.id,await this.onSave()},findSelectedAddress(){return this.addresses.find(e=>e.id===this.selectedAddressId)},async updateOrderContext(){const e=this.findSelectedAddress(),s={[this.address.contextId]:e.id,[this.address.contextDataKey]:e,[this.address.contextDataDefaultId]:e[this.address.contextDataDefaultId]};await a.get("swOrder").updateOrderContext({context:s,salesChannelId:this.activeCustomer.salesChannelId,contextToken:this.cart.token}),this.$emit("set-customer-address",{contextId:this.address.contextId,contextDataKey:this.address.contextDataKey,data:e})},async saveCurrentCustomer(){return this.hasOwnProperty("defaultShippingAddressId")&&(this.activeCustomer.defaultShippingAddressId=this.defaultShippingAddressId),this.hasOwnProperty("defaultBillingAddressId")&&(this.activeCustomer.defaultBillingAddressId=this.defaultBillingAddressId),this.customerRepository.save(this.activeCustomer)},async saveCurrentAddress(){if(this.selectedAddressId=this.currentAddress.id,this.currentAddress.isNew()&&this.addresses.push(this.currentAddress),!this.isValidCompanyField){const e=new Shopware.Classes.ShopwareError({code:"c1051bb4-d103-4f74-8988-acbcafc7fdc3"});return await Shopware.Store.get("error").addApiError({expression:`customer_address.${this.currentAddress.id}.company`,error:e}),Promise.reject(e)}return this.addressRepository.save(this.currentAddress)},closeModal(){this.$emit("close-modal")},onCancel(){this.closeModal()},async onSave(){this.isLoading=!0;try{await this.updateOrderContext(),this.closeModal()}catch{this.createNotificationError({message:this.$tc("sw-order.detail.messageSaveError")})}finally{this.isLoading=!1}},onCloseAddressModal(){this.showAddressFormModal=!1},onAddNewAddress(){this.createNewCustomerAddress(),this.showAddressFormModal=!0},onEditAddress(e){this.currentAddress=e,this.showAddressFormModal=!0},onChangeDefaultAddress(e){if(!e.value)return;const s=this.defaultAddressIdMapping[e.name];this[s]=e.id},async onSubmitAddressForm(){try{if(this.isLoading=!0,this.currentAddress===null)return;await this.saveCurrentAddress(),await this.saveCurrentCustomer(),await this.updateOrderContext(),await this.getCustomerAddresses(),this.currentAddress=null,this.showAddressFormModal=!1}catch{this.createNotificationError({message:this.$tc("sw-order.detail.messageSaveError")})}finally{this.isLoading=!1}},getAddressFormModalTitle(){return!this.currentAddress||this.currentAddress.isNew()?this.addAddressModalTitle:this.editAddressModalTitle},createNewCustomerAddress(){const e=this.addressRepository.create();e.customerId=this.activeCustomer.id,this.currentAddress=e}}};export{i as default};
