<?php

namespace Symfony\Config\Storefront;

use Symfony\Component\Config\Loader\ParamConfigurator;
use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;

/**
 * This class is automatically generated to help in creating a config.
 */
class RouterConfig 
{
    private $allowedRoutes;
    private $_usedProperties = [];

    /**
     * @param ParamConfigurator|list<ParamConfigurator|mixed> $value
     *
     * @return $this
     */
    public function allowedRoutes(ParamConfigurator|array $value): static
    {
        $this->_usedProperties['allowedRoutes'] = true;
        $this->allowedRoutes = $value;

        return $this;
    }

    public function __construct(array $value = [])
    {
        if (array_key_exists('allowed_routes', $value)) {
            $this->_usedProperties['allowedRoutes'] = true;
            $this->allowedRoutes = $value['allowed_routes'];
            unset($value['allowed_routes']);
        }

        if ([] !== $value) {
            throw new InvalidConfigurationException(sprintf('The following keys are not supported by "%s": ', __CLASS__).implode(', ', array_keys($value)));
        }
    }

    public function toArray(): array
    {
        $output = [];
        if (isset($this->_usedProperties['allowedRoutes'])) {
            $output['allowed_routes'] = $this->allowedRoutes;
        }

        return $output;
    }

}
