<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\CoreExtension;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;
use Twig\TemplateWrapper;

/* @Storefront/storefront/component/form/form-input.html.twig */
class __TwigTemplate_9d54342c61b5ad6c4922cc9b377fbc46 extends Template
{
    private Source $source;
    /**
     * @var array<string, Template>
     */
    private array $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
            'component_form_input' => [$this, 'block_component_form_input'],
            'component_form_input_label' => [$this, 'block_component_form_input_label'],
            'component_form_input_input' => [$this, 'block_component_form_input_input'],
            'component_form_input_description' => [$this, 'block_component_form_input_description'],
            'component_form_input_feedback' => [$this, 'block_component_form_input_feedback'],
            'component_form_input_feedback_violations' => [$this, 'block_component_form_input_feedback_violations'],
        ];
    }

    protected function doDisplay(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "template", "@Storefront/storefront/component/form/form-input.html.twig"));

        // line 24
        yield from $this->unwrap()->yieldBlock('component_form_input', $context, $blocks);
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_input(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_input"));

        // line 25
        yield "
    ";
        // line 26
        if ((($tmp =  !($context["type"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 27
            yield "        ";
            $context["type"] = "text";
            // line 28
            yield "    ";
        }
        // line 29
        yield "
    ";
        // line 30
        $context["isInvalid"] = false;
        // line 31
        yield "
    ";
        // line 32
        if ((( !Twig\Extension\CoreExtension::testEmpty(($context["violationPath"] ?? null)) &&  !Twig\Extension\CoreExtension::testEmpty(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["formViolations"] ?? null), "getViolations", [($context["violationPath"] ?? null)], "method", false, false, false, 32))) ||  !Twig\Extension\CoreExtension::testEmpty(($context["error"] ?? null)))) {
            // line 33
            yield "        ";
            $context["isInvalid"] = true;
            // line 34
            yield "    ";
        }
        // line 35
        yield "
    ";
        // line 36
        $context["feedbackId"] = (($context["id"] ?? null) . "-feedback");
        // line 37
        yield "    ";
        $context["descriptionId"] = (($context["id"] ?? null) . "-description");
        // line 38
        yield "
    ";
        // line 39
        $context["areaDescribedBy"] = ($context["feedbackId"] ?? null);
        // line 40
        yield "
    ";
        // line 41
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["description"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 42
            yield "        ";
            $context["areaDescribedBy"] = ((($context["descriptionId"] ?? null) . " ") . ($context["feedbackId"] ?? null));
            // line 43
            yield "    ";
        }
        // line 44
        yield "
    <div class=\"form-group";
        // line 45
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["additionalClass"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield " ";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["additionalClass"] ?? null), "html", null, true);
        }
        yield "\">
        ";
        // line 46
        yield from $this->unwrap()->yieldBlock('component_form_input_label', $context, $blocks);
        // line 57
        yield "
        ";
        // line 58
        yield from $this->unwrap()->yieldBlock('component_form_input_input', $context, $blocks);
        // line 84
        yield "
        ";
        // line 85
        yield from $this->unwrap()->yieldBlock('component_form_input_description', $context, $blocks);
        // line 90
        yield "
        ";
        // line 91
        yield from $this->unwrap()->yieldBlock('component_form_input_feedback', $context, $blocks);
        // line 100
        yield "    </div>
";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 46
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_input_label(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_input_label"));

        // line 47
        yield "            ";
        if ((($tmp = ($context["label"] ?? null)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 48
            yield "                <label class=\"form-label\" for=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["id"] ?? null), "html", null, true);
            yield "\">
                    ";
            // line 49
            yield ($context["label"] ?? null);
            yield "

                    ";
            // line 51
            if (CoreExtension::inFilter("required", ($context["validationRules"] ?? null))) {
                // line 52
                yield "                        <span class=\"form-required-label\" aria-hidden=\"true\">";
                yield $this->extensions['Shopware\Core\Framework\Adapter\Twig\Extension\SwSanitizeTwigFilter']->sanitize($this->extensions['Symfony\Bridge\Twig\Extension\TranslationExtension']->trans("general.required"));
                yield "</span>
                    ";
            }
            // line 54
            yield "                </label>
            ";
        }
        // line 56
        yield "        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 58
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_input_input(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_input_input"));

        // line 59
        yield "            ";
        $context["cssClass"] = "form-control";
        // line 60
        yield "
            ";
        // line 61
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["additionalInputClass"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 62
            yield "                ";
            $context["cssClass"] = ((($context["cssClass"] ?? null) . " ") . ($context["additionalInputClass"] ?? null));
            // line 63
            yield "            ";
        }
        // line 64
        yield "
            ";
        // line 65
        if ((($tmp = (($context["isInvalid"] ?? null) === true)) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 66
            yield "                ";
            $context["cssClass"] = (($context["cssClass"] ?? null) . " is-invalid");
            // line 67
            yield "            ";
        }
        // line 68
        yield "
            <input type=\"";
        // line 69
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["type"] ?? null), "html", null, true);
        yield "\"
                   class=\"";
        // line 70
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["cssClass"] ?? null), "html", null, true);
        yield "\"
                   id=\"";
        // line 71
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["id"] ?? null), "html", null, true);
        yield "\"
                   name=\"";
        // line 72
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["name"] ?? null), "html", null, true);
        yield "\"
                   aria-describedby=\"";
        // line 73
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["areaDescribedBy"] ?? null), "html", null, true);
        yield "\"
                   ";
        // line 74
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["value"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "value=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["value"] ?? null), "html", null, true);
            yield "\"";
        }
        // line 75
        yield "                   ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["placeholder"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "placeholder=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["placeholder"] ?? null), "html", null, true);
            yield "\"";
        }
        // line 76
        yield "                   ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["autocomplete"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "autocomplete=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["autocomplete"] ?? null), "html", null, true);
            yield "\"";
        }
        // line 77
        yield "                   ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["minlength"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "minlength=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["minlength"] ?? null), "html", null, true);
            yield "\"";
        }
        // line 78
        yield "                   ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["maxlength"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "maxlength=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["maxlength"] ?? null), "html", null, true);
            yield "\"";
        }
        // line 79
        yield "                   ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["validationRules"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "data-validation=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["validationRules"] ?? null), "html", null, true);
            yield "\"";
        }
        // line 80
        yield "                   ";
        if (CoreExtension::inFilter("required", ($context["validationRules"] ?? null))) {
            yield "aria-required=\"true\"";
        }
        // line 81
        yield "                   ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["attributes"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            $context['_parent'] = $context;
            $context['_seq'] = CoreExtension::ensureTraversable(($context["attributes"] ?? null));
            foreach ($context['_seq'] as $context["key"] => $context["value"]) {
                if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty($context["value"])) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["key"], "html", null, true);
                    yield "=\"";
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["value"], "html", null, true);
                    yield "\" ";
                } else {
                    yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape($context["key"], "html", null, true);
                    yield " ";
                }
            }
            $_parent = $context['_parent'];
            unset($context['_seq'], $context['key'], $context['value'], $context['_parent']);
            $context = array_intersect_key($context, $_parent) + $_parent;
        }
        // line 82
        yield "                   ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["disabled"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            yield "disabled";
        }
        yield ">
        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 85
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_input_description(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_input_description"));

        // line 86
        yield "            ";
        if ((($tmp =  !Twig\Extension\CoreExtension::testEmpty(($context["description"] ?? null))) && $tmp instanceof Markup ? (string) $tmp : $tmp)) {
            // line 87
            yield "                <small id=\"";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["descriptionId"] ?? null), "html", null, true);
            yield "\" class=\"form-text\">";
            yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["description"] ?? null), "html", null, true);
            yield "</small>
            ";
        }
        // line 89
        yield "        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 91
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_input_feedback(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_input_feedback"));

        // line 92
        yield "            <div id=\"";
        yield $this->env->getRuntime('Twig\Runtime\EscaperRuntime')->escape(($context["feedbackId"] ?? null), "html", null, true);
        yield "\" class=\"form-field-feedback\">
                ";
        // line 93
        yield from $this->unwrap()->yieldBlock('component_form_input_feedback_violations', $context, $blocks);
        // line 98
        yield "            </div>
        ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    // line 93
    /**
     * @return iterable<null|scalar|\Stringable>
     */
    public function block_component_form_input_feedback_violations(array $context, array $blocks = []): iterable
    {
        $macros = $this->macros;
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f = $this->extensions["Symfony\\Bridge\\Twig\\Extension\\ProfilerExtension"];
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->enter($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof = new \Twig\Profiler\Profile($this->getTemplateName(), "block", "component_form_input_feedback_violations"));

        // line 94
        yield "                    ";
        if (( !Twig\Extension\CoreExtension::testEmpty(($context["violationPath"] ?? null)) &&  !Twig\Extension\CoreExtension::testEmpty(\Shopware\Core\Framework\Adapter\Twig\SwTwigFunction::getAttribute($this->env, $this->source, ($context["formViolations"] ?? null), "getViolations", [($context["violationPath"] ?? null)], "method", false, false, false, 94)))) {
            // line 95
            yield "                        ";
            yield from $this->load("@Storefront/storefront/utilities/form-violation.html.twig", 95)->unwrap()->yield($context);
            // line 96
            yield "                    ";
        }
        // line 97
        yield "                ";
        
        $__internal_6f47bbe9983af81f1e7450e9a3e3768f->leave($__internal_6f47bbe9983af81f1e7450e9a3e3768f_prof);

        yield from [];
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName(): string
    {
        return "@Storefront/storefront/component/form/form-input.html.twig";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo(): array
    {
        return array (  409 => 97,  406 => 96,  403 => 95,  400 => 94,  390 => 93,  381 => 98,  379 => 93,  374 => 92,  364 => 91,  356 => 89,  348 => 87,  345 => 86,  335 => 85,  322 => 82,  302 => 81,  297 => 80,  290 => 79,  283 => 78,  276 => 77,  269 => 76,  262 => 75,  256 => 74,  252 => 73,  248 => 72,  244 => 71,  240 => 70,  236 => 69,  233 => 68,  230 => 67,  227 => 66,  225 => 65,  222 => 64,  219 => 63,  216 => 62,  214 => 61,  211 => 60,  208 => 59,  198 => 58,  190 => 56,  186 => 54,  180 => 52,  178 => 51,  173 => 49,  168 => 48,  165 => 47,  155 => 46,  146 => 100,  144 => 91,  141 => 90,  139 => 85,  136 => 84,  134 => 58,  131 => 57,  129 => 46,  122 => 45,  119 => 44,  116 => 43,  113 => 42,  111 => 41,  108 => 40,  106 => 39,  103 => 38,  100 => 37,  98 => 36,  95 => 35,  92 => 34,  89 => 33,  87 => 32,  84 => 31,  82 => 30,  79 => 29,  76 => 28,  73 => 27,  71 => 26,  68 => 25,  51 => 24,);
    }

    public function getSourceContext(): Source
    {
        return new Source("{#
    -- Input Form Field Component --

    This component makes it easier to use input fields in a form.
    It will implement all necessary accessibility best-practices and field validation for you.

    Properties:

    * id (required) - The id attriute of the input field.
    * name (required) - The name attribute of the input field.
    * type (optional) - The type attribute of the input field. Default is \"text\".
    * label (optional) - The text content of the field label.
    * value (optional) - The initial value of the field.
    * placeholder (optional) - The placeholder attribute of the input field.
    * minlength (optional) - The minlength attribute of the input field.
    * maxlength (optional) - The maxlength attribute of the input field.
    * disabled (optional) - The disabled attribute of the input field.
    * validationRules (optional) - A comma-separated list of rules the field should be validated against via client validation.
    * violationPath (optional) - The key under which validation errors are stored within the response of a server validation.
    * additionalClass (optional) - Additional css class names that are added to the form-group wrapper element.
    * additionalInputClass (optional) - Additional css class names that are added to the input element.
    * attributes (optional) - Additional attributes that are added to the input element.
#}
{% block component_form_input %}

    {% if not type %}
        {% set type = 'text' %}
    {% endif %}

    {% set isInvalid = false %}

    {% if (violationPath is not empty and formViolations.getViolations(violationPath) is not empty) or error is not empty %}
        {% set isInvalid = true %}
    {% endif %}

    {% set feedbackId = \"#{id}-feedback\" %}
    {% set descriptionId = \"#{id}-description\" %}

    {% set areaDescribedBy = \"#{feedbackId}\" %}

    {% if description is not empty %}
        {% set areaDescribedBy = \"#{descriptionId} #{feedbackId}\" %}
    {% endif %}

    <div class=\"form-group{% if additionalClass is not empty %} {{ additionalClass }}{% endif %}\">
        {% block component_form_input_label %}
            {% if label %}
                <label class=\"form-label\" for=\"{{ id }}\">
                    {{ label|raw }}

                    {% if 'required' in validationRules %}
                        <span class=\"form-required-label\" aria-hidden=\"true\">{{ 'general.required'|trans|sw_sanitize }}</span>
                    {% endif %}
                </label>
            {% endif %}
        {% endblock %}

        {% block component_form_input_input %}
            {% set cssClass = 'form-control' %}

            {% if additionalInputClass is not empty %}
                {% set cssClass = \"#{cssClass} #{additionalInputClass}\" %}
            {% endif %}

            {% if isInvalid === true %}
                {% set cssClass = \"#{cssClass} is-invalid\" %}
            {% endif %}

            <input type=\"{{ type }}\"
                   class=\"{{ cssClass }}\"
                   id=\"{{ id }}\"
                   name=\"{{ name }}\"
                   aria-describedby=\"{{ areaDescribedBy }}\"
                   {% if value is not empty %}value=\"{{ value }}\"{% endif %}
                   {% if placeholder is not empty %}placeholder=\"{{ placeholder }}\"{% endif %}
                   {% if autocomplete is not empty %}autocomplete=\"{{ autocomplete }}\"{% endif %}
                   {% if minlength is not empty %}minlength=\"{{ minlength }}\"{% endif %}
                   {% if maxlength is not empty %}maxlength=\"{{ maxlength }}\"{% endif %}
                   {% if validationRules is not empty %}data-validation=\"{{ validationRules }}\"{% endif %}
                   {% if 'required' in validationRules %}aria-required=\"true\"{% endif %}
                   {% if attributes is not empty %}{% for key, value in attributes %}{% if value is not empty %}{{ key }}=\"{{ value }}\" {% else %}{{ key }} {% endif %}{% endfor %}{% endif %}
                   {% if disabled is not empty %}disabled{% endif %}>
        {% endblock %}

        {% block component_form_input_description %}
            {% if description is not empty %}
                <small id=\"{{ descriptionId }}\" class=\"form-text\">{{ description }}</small>
            {% endif %}
        {% endblock %}

        {% block component_form_input_feedback %}
            <div id=\"{{ feedbackId }}\" class=\"form-field-feedback\">
                {% block component_form_input_feedback_violations %}
                    {% if violationPath is not empty and formViolations.getViolations(violationPath) is not empty %}
                        {% sw_include '@Storefront/storefront/utilities/form-violation.html.twig' %}
                    {% endif %}
                {% endblock %}
            </div>
        {% endblock %}
    </div>
{% endblock %}
", "@Storefront/storefront/component/form/form-input.html.twig", "/var/www/html/shopware/vendor/shopware/storefront/Resources/views/storefront/component/form/form-input.html.twig");
    }
}
