<?php

/**
 * This file is a part of horstoeko/zugferd.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace horstoeko\zugferd\codelists;

/**
 * Class representing the Charge codes
 *
 * @category Zugferd
 * @package  Zugferd
 * @author   D. Erling <horstoeko@erling.com.de>
 * @license  https://opensource.org/licenses/MIT MIT
 * @link     https://github.com/horstoeko/zugferd
 */
class ZugferdChargeCodes
{
    /**
     * Advertising
     */
    public const ADVERTISING = "AA";

    /**
     * Telecommunication
     */
    public const TELECOMMUNICATION = "AAA";

    /**
     * Technical modification
     */
    public const TECHNICAL_MODIFICATION = "AAC";

    /**
     * Job-order production
     */
    public const JOBORDER_PRODUCTION = "AAD";

    /**
     * Outlays
     */
    public const OUTLAYS = "AAE";

    /**
     * Off-premises
     */
    public const OFFPREMISES = "AAF";

    /**
     * Additional processing
     */
    public const ADDITIONAL_PROCESSING = "AAH";

    /**
     * Attesting
     */
    public const ATTESTING = "AAI";

    /**
     * Acceptance
     */
    public const ACCEPTANCE = "AAS";

    /**
     * Rush delivery
     */
    public const RUSH_DELIVERY = "AAT";

    /**
     * Special construction
     */
    public const SPECIAL_CONSTRUCTION = "AAV";

    /**
     * Airport facilities
     */
    public const AIRPORT_FACILITIES = "AAY";

    /**
     * Concession
     */
    public const CONCESSION = "AAZ";

    /**
     * Compulsory storage
     */
    public const COMPULSORY_STORAGE = "ABA";

    /**
     * Fuel removal
     */
    public const FUEL_REMOVAL = "ABB";

    /**
     * Into plane
     */
    public const INTO_PLANE = "ABC";

    /**
     * Overtime
     */
    public const OVERTIME = "ABD";

    /**
     * Tooling
     */
    public const TOOLING = "ABF";

    /**
     * Miscellaneous
     */
    public const MISCELLANEOUS = "ABK";

    /**
     * Additional packaging
     */
    public const ADDITIONAL_PACKAGING = "ABL";

    /**
     * Dunnage
     */
    public const DUNNAGE = "ABN";

    /**
     * Containerisation
     */
    public const CONTAINERISATION = "ABR";

    /**
     * Carton packing
     */
    public const CARTON_PACKING = "ABS";

    /**
     * Hessian wrapped
     */
    public const HESSIAN_WRAPPED = "ABT";

    /**
     * Polyethylene wrap packing
     */
    public const POLYETHYLENE_WRAP_PACKING = "ABU";

    /**
     * Miscellaneous treatment
     */
    public const MISCELLANEOUS_TREATMENT = "ACF";

    /**
     * Enamelling treatment
     */
    public const ENAMELLING_TREATMENT = "ACG";

    /**
     * Heat treatment
     */
    public const HEAT_TREATMENT = "ACH";

    /**
     * Plating treatment
     */
    public const PLATING_TREATMENT = "ACI";

    /**
     * Painting
     */
    public const PAINTING = "ACJ";

    /**
     * Polishing
     */
    public const POLISHING = "ACK";

    /**
     * Priming
     */
    public const PRIMING = "ACL";

    /**
     * Preservation treatment
     */
    public const PRESERVATION_TREATMENT = "ACM";

    /**
     * Fitting
     */
    public const FITTING = "ACS";

    /**
     * Consolidation
     */
    public const CONSOLIDATION = "ADC";

    /**
     * Bill of lading
     */
    public const BILL_OF_LADING = "ADE";

    /**
     * Airbag
     */
    public const AIRBAG = "ADJ";

    /**
     * Transfer
     */
    public const TRANSFER = "ADK";

    /**
     * Slipsheet
     */
    public const SLIPSHEET = "ADL";

    /**
     * Binding
     */
    public const BINDING = "ADM";

    /**
     * Repair or replacement of broken returnable package
     */
    public const REPAIR_OR_REPLACEMENT_OF_BROKEN_RETURNABLE_PACKAGE = "ADN";

    /**
     * Efficient logistics
     */
    public const EFFICIENT_LOGISTICS = "ADO";

    /**
     * Merchandising
     */
    public const MERCHANDISING = "ADP";

    /**
     * Product mix
     */
    public const PRODUCT_MIX = "ADQ";

    /**
     * Other services
     */
    public const OTHER_SERVICES = "ADR";

    /**
     * Pick-up
     */
    public const PICKUP = "ADT";

    /**
     * Chronic illness
     */
    public const CHRONIC_ILLNESS = "ADW";

    /**
     * New product introduction
     */
    public const NEW_PRODUCT_INTRODUCTION = "ADY";

    /**
     * Direct delivery
     */
    public const DIRECT_DELIVERY = "ADZ";

    /**
     * Diversion
     */
    public const DIVERSION = "AEA";

    /**
     * Disconnect
     */
    public const DISCONNECT = "AEB";

    /**
     * Distribution
     */
    public const DISTRIBUTION = "AEC";

    /**
     * Handling of hazardous cargo
     */
    public const HANDLING_OF_HAZARDOUS_CARGO = "AED";

    /**
     * Rents and leases
     */
    public const RENTS_AND_LEASES = "AEF";

    /**
     * Location differential
     */
    public const LOCATION_DIFFERENTIAL = "AEH";

    /**
     * Aircraft refueling
     */
    public const AIRCRAFT_REFUELING = "AEI";

    /**
     * Fuel shipped into storage
     */
    public const FUEL_SHIPPED_INTO_STORAGE = "AEJ";

    /**
     * Cash on delivery
     */
    public const CASH_ON_DELIVERY = "AEK";

    /**
     * Small order processing service
     */
    public const SMALL_ORDER_PROCESSING_SERVICE = "AEL";

    /**
     * Clerical or administrative services
     */
    public const CLERICAL_OR_ADMINISTRATIVE_SERVICES = "AEM";

    /**
     * Guarantee
     */
    public const GUARANTEE = "AEN";

    /**
     * Collection and recycling
     */
    public const COLLECTION_AND_RECYCLING = "AEO";

    /**
     * Copyright fee collection
     */
    public const COPYRIGHT_FEE_COLLECTION = "AEP";

    /**
     * Veterinary inspection service
     */
    public const VETERINARY_INSPECTION_SERVICE = "AES";

    /**
     * Pensioner service
     */
    public const PENSIONER_SERVICE = "AET";

    /**
     * Medicine free pass holder
     */
    public const MEDICINE_FREE_PASS_HOLDER = "AEU";

    /**
     * Environmental protection service
     */
    public const ENVIRONMENTAL_PROTECTION_SERVICE = "AEV";

    /**
     * Environmental clean-up service
     */
    public const ENVIRONMENTAL_CLEANUP_SERVICE = "AEW";

    /**
     * National cheque processing service outside account area
     */
    public const NATIONAL_CHEQUE_PROCESSING_SERVICE_OUTSIDE_ACCOUNT_AREA = "AEX";

    /**
     * National payment service outside account area
     */
    public const NATIONAL_PAYMENT_SERVICE_OUTSIDE_ACCOUNT_AREA = "AEY";

    /**
     * National payment service within account area
     */
    public const NATIONAL_PAYMENT_SERVICE_WITHIN_ACCOUNT_AREA = "AEZ";

    /**
     * Adjustments
     */
    public const ADJUSTMENTS = "AJ";

    /**
     * Authentication
     */
    public const AUTHENTICATION = "AU";

    /**
     * Cataloguing
     */
    public const CATALOGUING = "CA";

    /**
     * Cartage
     */
    public const CARTAGE = "CAB";

    /**
     * Certification
     */
    public const CERTIFICATION = "CAD";

    /**
     * Certificate of conformance
     */
    public const CERTIFICATE_OF_CONFORMANCE = "CAE";

    /**
     * Certificate of origin
     */
    public const CERTIFICATE_OF_ORIGIN = "CAF";

    /**
     * Cutting
     */
    public const CUTTING = "CAI";

    /**
     * Consular service
     */
    public const CONSULAR_SERVICE = "CAJ";

    /**
     * Customer collection
     */
    public const CUSTOMER_COLLECTION = "CAK";

    /**
     * Payroll payment service
     */
    public const PAYROLL_PAYMENT_SERVICE = "CAL";

    /**
     * Cash transportation
     */
    public const CASH_TRANSPORTATION = "CAM";

    /**
     * Home banking service
     */
    public const HOME_BANKING_SERVICE = "CAN";

    /**
     * Bilateral agreement service
     */
    public const BILATERAL_AGREEMENT_SERVICE = "CAO";

    /**
     * Insurance brokerage service
     */
    public const INSURANCE_BROKERAGE_SERVICE = "CAP";

    /**
     * Cheque generation
     */
    public const CHEQUE_GENERATION = "CAQ";

    /**
     * Preferential merchandising location
     */
    public const PREFERENTIAL_MERCHANDISING_LOCATION = "CAR";

    /**
     * Crane
     */
    public const CRANE = "CAS";

    /**
     * Special colour service
     */
    public const SPECIAL_COLOUR_SERVICE = "CAT";

    /**
     * Sorting
     */
    public const SORTING = "CAU";

    /**
     * Battery collection and recycling
     */
    public const BATTERY_COLLECTION_AND_RECYCLING = "CAV";

    /**
     * Product take back fee
     */
    public const PRODUCT_TAKE_BACK_FEE = "CAW";

    /**
     * Quality control released
     */
    public const QUALITY_CONTROL_RELEASED = "CAX";

    /**
     * Quality control held
     */
    public const QUALITY_CONTROL_HELD = "CAY";

    /**
     * Quality control embargo
     */
    public const QUALITY_CONTROL_EMBARGO = "CAZ";

    /**
     * Car loading
     */
    public const CAR_LOADING = "CD";

    /**
     * Cleaning
     */
    public const CLEANING = "CG";

    /**
     * Cigarette stamping
     */
    public const CIGARETTE_STAMPING = "CS";

    /**
     * Count and recount
     */
    public const COUNT_AND_RECOUNT = "CT";

    /**
     * Layout/design
     */
    public const LAYOUT_DESIGN = "DAB";

    /**
     * Assortment allowance
     */
    public const ASSORTMENT_ALLOWANCE = "DAC";

    /**
     * Driver assigned unloading
     */
    public const DRIVER_ASSIGNED_UNLOADING = "DAD";

    /**
     * Debtor bound
     */
    public const DEBTOR_BOUND = "DAF";

    /**
     * Dealer allowance
     */
    public const DEALER_ALLOWANCE = "DAG";

    /**
     * Allowance transferable to the consumer
     */
    public const ALLOWANCE_TRANSFERABLE_TO_THE_CONSUMER = "DAH";

    /**
     * Growth of business
     */
    public const GROWTH_OF_BUSINESS = "DAI";

    /**
     * Introduction allowance
     */
    public const INTRODUCTION_ALLOWANCE = "DAJ";

    /**
     * Multi-buy promotion
     */
    public const MULTIBUY_PROMOTION = "DAK";

    /**
     * Partnership
     */
    public const PARTNERSHIP = "DAL";

    /**
     * Return handling
     */
    public const RETURN_HANDLING = "DAM";

    /**
     * Minimum order not fulfilled charge
     */
    public const MINIMUM_ORDER_NOT_FULFILLED_CHARGE = "DAN";

    /**
     * Point of sales threshold allowance
     */
    public const POINT_OF_SALES_THRESHOLD_ALLOWANCE = "DAO";

    /**
     * Wholesaling discount
     */
    public const WHOLESALING_DISCOUNT = "DAP";

    /**
     * Documentary credits transfer commission
     */
    public const DOCUMENTARY_CREDITS_TRANSFER_COMMISSION = "DAQ";

    /**
     * Delivery
     */
    public const DELIVERY = "DL";

    /**
     * Engraving
     */
    public const ENGRAVING = "EG";

    /**
     * Expediting
     */
    public const EXPEDITING = "EP";

    /**
     * Exchange rate guarantee
     */
    public const EXCHANGE_RATE_GUARANTEE = "ER";

    /**
     * Fabrication
     */
    public const FABRICATION = "FAA";

    /**
     * Freight equalization
     */
    public const FREIGHT_EQUALIZATION = "FAB";

    /**
     * Freight extraordinary handling
     */
    public const FREIGHT_EXTRAORDINARY_HANDLING = "FAC";

    /**
     * Freight service
     */
    public const FREIGHT_SERVICE = "FC";

    /**
     * Filling/handling
     */
    public const FILLING_HANDLING = "FH";

    /**
     * Financing
     */
    public const FINANCING = "FI";

    /**
     * Grinding
     */
    public const GRINDING = "GAA";

    /**
     * Hose
     */
    public const HOSE = "HAA";

    /**
     * Handling
     */
    public const HANDLING = "HD";

    /**
     * Hoisting and hauling
     */
    public const HOISTING_AND_HAULING = "HH";

    /**
     * Installation
     */
    public const INSTALLATION = "IAA";

    /**
     * Installation and warranty
     */
    public const INSTALLATION_AND_WARRANTY = "IAB";

    /**
     * Inside delivery
     */
    public const INSIDE_DELIVERY = "ID";

    /**
     * Inspection
     */
    public const INSPECTION = "IF";

    /**
     * Installation and training
     */
    public const INSTALLATION_AND_TRAINING = "IR";

    /**
     * Invoicing
     */
    public const INVOICING = "IS";

    /**
     * Koshering
     */
    public const KOSHERING = "KO";

    /**
     * Carrier count
     */
    public const CARRIER_COUNT = "L1";

    /**
     * Labelling
     */
    public const LABELLING = "LA";

    /**
     * Labour
     */
    public const LABOUR = "LAA";

    /**
     * Repair and return
     */
    public const REPAIR_AND_RETURN = "LAB";

    /**
     * Legalisation
     */
    public const LEGALISATION = "LF";

    /**
     * Mounting
     */
    public const MOUNTING = "MAE";

    /**
     * Mail invoice
     */
    public const MAIL_INVOICE = "MI";

    /**
     * Mail invoice to each location
     */
    public const MAIL_INVOICE_TO_EACH_LOCATION = "ML";

    /**
     * Non-returnable containers
     */
    public const NONRETURNABLE_CONTAINERS = "NAA";

    /**
     * Outside cable connectors
     */
    public const OUTSIDE_CABLE_CONNECTORS = "OA";

    /**
     * Invoice with shipment
     */
    public const INVOICE_WITH_SHIPMENT = "PA";

    /**
     * Phosphatizing (steel treatment)
     */
    public const PHOSPHATIZING_STEEL_TREATMENT = "PAA";

    /**
     * Packing
     */
    public const PACKING = "PC";

    /**
     * Palletizing
     */
    public const PALLETIZING = "PL";

    /**
     * Repacking
     */
    public const REPACKING = "RAB";

    /**
     * Repair
     */
    public const REPAIR = "RAC";

    /**
     * Returnable container
     */
    public const RETURNABLE_CONTAINER = "RAD";

    /**
     * Restocking
     */
    public const RESTOCKING = "RAF";

    /**
     * Re-delivery
     */
    public const REDELIVERY = "RE";

    /**
     * Refurbishing
     */
    public const REFURBISHING = "RF";

    /**
     * Rail wagon hire
     */
    public const RAIL_WAGON_HIRE = "RH";

    /**
     * Loading
     */
    public const LOADING = "RV";

    /**
     * Salvaging
     */
    public const SALVAGING = "SA";

    /**
     * Shipping and handling
     */
    public const SHIPPING_AND_HANDLING = "SAA";

    /**
     * Special packaging
     */
    public const SPECIAL_PACKAGING = "SAD";

    /**
     * Stamping
     */
    public const STAMPING = "SAE";

    /**
     * Consignee unload
     */
    public const CONSIGNEE_UNLOAD = "SAI";

    /**
     * Shrink-wrap
     */
    public const SHRINKWRAP = "SG";

    /**
     * Special handling
     */
    public const SPECIAL_HANDLING = "SH";

    /**
     * Special finish
     */
    public const SPECIAL_FINISH = "SM";

    /**
     * Set-up
     */
    public const SETUP = "SU";

    /**
     * Tank renting
     */
    public const TANK_RENTING = "TAB";

    /**
     * Testing
     */
    public const TESTING = "TAC";

    /**
     * Transportation - third party billing
     */
    public const TRANSPORTATION__THIRD_PARTY_BILLING = "TT";

    /**
     * Transportation by vendor
     */
    public const TRANSPORTATION_BY_VENDOR = "TV";

    /**
     * Drop yard
     */
    public const DROP_YARD = "V1";

    /**
     * Drop dock
     */
    public const DROP_DOCK = "V2";

    /**
     * Warehousing
     */
    public const WAREHOUSING = "WH";

    /**
     * Combine all same day shipment
     */
    public const COMBINE_ALL_SAME_DAY_SHIPMENT = "XAA";

    /**
     * Split pick-up
     */
    public const SPLIT_PICKUP = "YY";

    /**
     * Mutually defined
     */
    public const MUTUALLY_DEFINED = "ZZZ";
}
