<?php

declare(strict_types=1);

/**
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 *
 * OpenSearch PHP client
 *
 * @link      https://github.com/opensearch-project/opensearch-php/
 * @copyright Copyright (c) Elasticsearch B.V (https://www.elastic.co)
 * @license   http://www.apache.org/licenses/LICENSE-2.0 Apache License, Version 2.0
 * @license   https://www.gnu.org/licenses/lgpl-2.1.html GNU Lesser General Public License, Version 2.1
 *
 * Licensed to Elasticsearch B.V under one or more agreements.
 * Elasticsearch B.V licenses this file to you under the Apache 2.0 License or
 * the GNU Lesser General Public License, Version 2.1, at your option.
 * See the LICENSE file in the project root for more information.
 */

namespace OpenSearch\Namespaces;

use OpenSearch\Namespaces\AbstractNamespace;

/**
 * Class NodesNamespace
 *
 * NOTE: This file is autogenerated using util/GenerateEndpoints.php
 */
class NodesNamespace extends AbstractNamespace
{
    /**
     * Returns information about hot threads on each node in the cluster.
     *
     * $params['node_id']             = (array) Comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes.
     * $params['ignore_idle_threads'] = (boolean) Don't show threads that are in known-idle places, such as waiting on a socket select or pulling from an empty task queue. (Default = true)
     * $params['interval']            = (string) The interval for the second sampling of threads.
     * $params['snapshots']           = (integer) Number of samples of thread stacktrace. (Default = 10)
     * $params['threads']             = (integer) Specify the number of threads to provide information for. (Default = 3)
     * $params['timeout']             = (string) Operation timeout.
     * $params['type']                = (enum) The type to sample. (Options = block,cpu,wait)
     * $params['pretty']              = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']               = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']         = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']              = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']         = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function hotThreads(array $params = [])
    {
        $node_id = $this->extractArgument($params, 'node_id');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Nodes\HotThreads');
        $endpoint->setParams($params);
        $endpoint->setNodeId($node_id);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns information about nodes in the cluster.
     *
     * $params['node_id_or_metric'] = (any) Limits the information returned to a list of node IDs or specific metrics. Supports a comma-separated list, such as node1,node2 or http,ingest.
     * $params['metric']            = (array) Limits the information returned to the specific metrics. Supports a comma-separated list, such as http,ingest.
     * $params['node_id']           = (array) Comma-separated list of node IDs or names used to limit returned information.
     * $params['flat_settings']     = (boolean) If true, returns settings in flat format. (Default = false)
     * $params['timeout']           = (string) Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
     * $params['pretty']            = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']             = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']       = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']            = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']       = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function info(array $params = [])
    {
        $node_id_or_metric = $this->extractArgument($params, 'node_id_or_metric');
        $metric = $this->extractArgument($params, 'metric');
        $node_id = $this->extractArgument($params, 'node_id');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Nodes\Info');
        $endpoint->setParams($params);
        $endpoint->setNodeIdOrMetric($node_id_or_metric);
        $endpoint->setMetric($metric);
        $endpoint->setNodeId($node_id);

        return $this->performRequest($endpoint);
    }
    /**
     * Reloads secure settings.
     *
     * $params['node_id']     = (array) The names of particular nodes in the cluster to target.
     * $params['timeout']     = (string) Period to wait for a response.If no response is received before the timeout expires, the request fails and returns an error.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     * $params['body']        = (array) An object containing the password for the opensearch keystore
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function reloadSecureSettings(array $params = [])
    {
        $node_id = $this->extractArgument($params, 'node_id');
        $body = $this->extractArgument($params, 'body');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Nodes\ReloadSecureSettings');
        $endpoint->setParams($params);
        $endpoint->setNodeId($node_id);
        $endpoint->setBody($body);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns statistical information about nodes in the cluster.
     *
     * $params['node_id']                    = (array) Comma-separated list of node IDs or names used to limit returned information.
     * $params['metric']                     = (array) Limit the information returned to the specified metrics
     * $params['index_metric']               = (array) Limit the information returned for indices metric to the specific index metrics. It can be used only if indices (or all) metric is specified.
     * $params['completion_fields']          = (any) Comma-separated list or wildcard expressions of fields to include in fielddata and suggest statistics.
     * $params['fielddata_fields']           = (any) Comma-separated list or wildcard expressions of fields to include in fielddata statistics.
     * $params['fields']                     = (any) Comma-separated list or wildcard expressions of fields to include in the statistics.
     * $params['groups']                     = (array) Comma-separated list of search groups to include in the search statistics.
     * $params['include_segment_file_sizes'] = (boolean) If true, the call reports the aggregated disk usage of each one of the Lucene index files (only applies if segment stats are requested). (Default = false)
     * $params['level']                      = (enum) Indicates whether statistics are aggregated at the cluster, index, or shard level. (Options = cluster,indices,shards)
     * $params['timeout']                    = (string) Period to wait for a response. If no response is received before the timeout expires, the request fails and returns an error.
     * $params['types']                      = (array) A comma-separated list of document types for the indexing index metric.
     * $params['pretty']                     = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']                      = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace']                = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']                     = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path']                = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function stats(array $params = [])
    {
        $node_id = $this->extractArgument($params, 'node_id');
        $metric = $this->extractArgument($params, 'metric');
        $index_metric = $this->extractArgument($params, 'index_metric');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Nodes\Stats');
        $endpoint->setParams($params);
        $endpoint->setNodeId($node_id);
        $endpoint->setMetric($metric);
        $endpoint->setIndexMetric($index_metric);

        return $this->performRequest($endpoint);
    }
    /**
     * Returns low-level information about REST actions usage on nodes.
     *
     * $params['node_id']     = (array) A comma-separated list of node IDs or names to limit the returned information; use `_local` to return information from the node you're connecting to, leave empty to get information from all nodes
     * $params['metric']      = (array) Limits the information returned to the specific metrics. A comma-separated list of the following options: `_all`, `rest_actions`.
     * $params['timeout']     = (string) Period to wait for a response.If no response is received before the timeout expires, the request fails and returns an error.
     * $params['pretty']      = (boolean) Whether to pretty format the returned JSON response.
     * $params['human']       = (boolean) Whether to return human readable values for statistics.
     * $params['error_trace'] = (boolean) Whether to include the stack trace of returned errors.
     * $params['source']      = (string) The URL-encoded request definition. Useful for libraries that do not accept a request body for non-POST requests.
     * $params['filter_path'] = (any) Comma-separated list of filters used to reduce the response.
     *
     * @param array $params Associative array of parameters
     * @return array
     */
    public function usage(array $params = [])
    {
        $node_id = $this->extractArgument($params, 'node_id');
        $metric = $this->extractArgument($params, 'metric');

        $endpointBuilder = $this->endpoints;
        $endpoint = $endpointBuilder('Nodes\Usage');
        $endpoint->setParams($params);
        $endpoint->setNodeId($node_id);
        $endpoint->setMetric($metric);

        return $this->performRequest($endpoint);
    }
}
