const o=`{% block sw_settings_country_state_list_card %} <mt-card v-if="!isLoading" position-identifier="sw-settings-country-state" > <template #toolbar> <sw-container columns="1fr 32px minmax(100px, 200px)" gap="0 10px" > {% block sw_attribute_list_toolbar_searchfield %} <sw-simple-search-field v-model:value="term" size="small" variant="form" @search-term-change="onSearchCountryState" /> {% endblock %} {% block sw_settings_country_state_list_toolbar_delete %} <mt-button v-tooltip.bottom="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('country.editor'), showOnDisabledElements: true }" square size="small" class="sw-settings-country-state-list__delete-button" :disabled="deleteButtonDisabled || !acl.can('country.editor')" variant="secondary" @click="onDeleteCountryStates" > <mt-icon name="regular-trash" size="16px" /> </mt-button> {% endblock %} {% block sw_settings_country_state_list_toolbar_add %} <mt-button v-tooltip.bottom="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('country.editor'), showOnDisabledElements: true }" class="sw-settings-country-state__add-country-state-button" size="x-small" variant="primary" :disabled="!acl.can('country.editor') || undefined" @click="onAddCountryState" > {{ $tc('sw-settings-country.detail.buttonAddCountryState') }} </mt-button> {% endblock %} </sw-container> </template> <template #grid> {% block sw_settings_country_state_list_listing %} <sw-one-to-many-grid ref="countryStateGrid" class="sw-settings-country-state-list__content" :is-loading="countryStateLoading" :collection="country.states" :full-page="undefined" :local-mode="country.isNew()" :columns="stateColumns" :allow-delete="acl.can('country.editor')" :tooltip-delete="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('country.editor'), showOnDisabledElements: true }" @selection-change="countryStateSelectionChanged" @load-finish="checkEmptyState" > <template #column-name="{ item }"> {% block sw_settings_country_state_list_listing_column_name %} <a class="sw-settings-country-state__link" role="button" tabindex="0" @click="onClickCountryState(item)" @keydown.enter="onClickCountryState(item)" > {{ getCountryStateName(item) }} </a> {% endblock %} </template> <template #more-actions="{ item }"> {% block sw_settings_country_state_list_listing_action_edit %} <sw-context-menu-item v-tooltip.top="{ message: $tc('sw-privileges.tooltip.warning'), disabled: acl.can('country.editor'), showOnDisabledElements: true }" class="sw-settings-country-state__edit-country-state-action" :disabled="!acl.can('country.editor') || undefined" @click="onClickCountryState(item)" > {{ $tc('sw-settings-country.detail.editAction') }} </sw-context-menu-item> {% endblock %} </template> </sw-one-to-many-grid> {% endblock %} {% block sw_settings_country_state_list_empty %} <sw-empty-state v-if="showEmptyState" :absolute="false" :title="$tc('sw-country-state-detail.emptyTitle')" :subline="$tc('sw-country-state-detail.emptySubline')" auto-height /> {% endblock %} </template> {% block sw_settings_country_state_detail %} <sw-country-state-detail v-if="currentCountryState" :country-state="currentCountryState" @attribute-edit-save="onSaveCountryState" @attribute-edit-cancel="onCancelCountryState" /> {% endblock %} </mt-card> {% endblock %}`,{Mixin:a}=Shopware,r={template:o,inject:["repositoryFactory","acl"],mixins:[a.getByName("notification")],props:{country:{type:Object,required:!0},isLoading:{type:Boolean,required:!1,default:!1},countryStateRepository:{type:Object,required:!1,default:null}},data(){return{deleteButtonDisabled:!0,term:null,currentCountryState:null,countryStateLoading:!1,showEmptyState:!1}},computed:{stateColumns(){return this.getStateColumns()},countryStates(){return this.country.states}},watch:{countryStates(){this.checkEmptyState()}},mounted(){this.mountedComponent()},methods:{mountedComponent(){this.checkEmptyState()},getStateColumns(){return[{property:"name",label:this.$tc("sw-settings-country.detail.columnStateNameLabel"),inlineEdit:"string",primary:!0},{property:"shortCode",label:this.$tc("sw-settings-country.detail.columnStateShortCodeLabel"),inlineEdit:"string"}]},countryStateSelectionChanged(t,e){this.deleteButtonDisabled=e<=0},onSearchCountryState(){this.country.states.criteria.setTerm(this.term),this.refreshCountryStateList()},onDeleteCountryStates(){const t=this.$refs.countryStateGrid.selection,e=Object.keys(t);return e.length?this.country.isNew()?(e.forEach(n=>{this.country.states.remove(n)}),this.$refs.countryStateGrid.resetSelection(),Promise.resolve()):(this.countryStateLoading=!0,this.countryStateRepository.syncDeleted(e,Shopware.Context.api).then(()=>{this.$refs.countryStateGrid.resetSelection(),this.refreshCountryStateList()}).finally(()=>{this.countryStateLoading=!1})):Promise.resolve()},onAddCountryState(){this.currentCountryState=this.countryStateRepository.create(Shopware.Context.api)},onSaveCountryState(t){return this.country.isNew()?(this.country.states.add(t),Promise.resolve().then(()=>{this.currentCountryState=null})):this.countryStateRepository.save(this.currentCountryState).then(()=>{this.refreshCountryStateList()}).catch(e=>{e.response.data.errors[0].code==="MISSING-SYSTEM-TRANSLATION"&&this.createNotificationError({message:this.$tc("sw-country-state-detail.createNewStateError")})})},onCancelCountryState(){this.currentCountryState=null},onClickCountryState(t){const e=this.countryStateRepository.create(Shopware.Context.api,t.id);e._isNew=!1,this.currentCountryState=Object.assign(e,t)},refreshCountryStateList(){this.countryStateLoading=!0,this.$refs.countryStateGrid.load().then(()=>{this.countryStateLoading=!1,this.currentCountryState=null})},getCountryStateName(t){var e;return((e=t==null?void 0:t.translated)==null?void 0:e.name)||(t==null?void 0:t.name)},checkEmptyState(){var t,e,n,s;if((t=this.country)!=null&&t.isNew()){this.showEmptyState=((n=(e=this.country)==null?void 0:e.states)==null?void 0:n.length)===0;return}this.showEmptyState=((s=this.$refs.countryStateGrid)==null?void 0:s.total)===0}}};export{r as default};
